/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.IdentityHashMap;
import java.util.Map;
import org.jcodings.util.IntHash;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::Enum"}, parent="Object")
public final class Enum
extends RubyObject {
    private final IRubyObject nativeType;
    private volatile Map<RubySymbol, RubyInteger> symbolToValue = new IdentityHashMap<RubySymbol, RubyInteger>();
    private volatile IntHash<RubySymbol> valueToSymbol = new IntHash();

    public static RubyClass createEnumClass(Ruby runtime2, RubyModule ffiModule) {
        RubyClass enumClass = ffiModule.defineClassUnder("Enum", runtime2.getObject(), Allocator.INSTANCE);
        enumClass.defineAnnotatedMethods(Enum.class);
        enumClass.defineAnnotatedConstants(Enum.class);
        enumClass.includeModule(ffiModule.fastGetConstant("DataConverter"));
        return enumClass;
    }

    private Enum(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.nativeType = runtime2.fastGetModule("FFI").fastGetClass("Type").fastGetConstant("INT");
    }

    @JRubyMethod(name={"init_values"})
    public final IRubyObject init_values(ThreadContext context, IRubyObject values) {
        if (!(values instanceof RubyHash)) {
            throw context.getRuntime().newTypeError(values, context.getRuntime().getHash());
        }
        IdentityHashMap<RubySymbol, RubyInteger> s2v = new IdentityHashMap<RubySymbol, RubyInteger>();
        IntHash<RubySymbol> v2s = new IntHash<RubySymbol>();
        for (Object obj : ((RubyHash)values).directEntrySet()) {
            Map.Entry entry = (Map.Entry)obj;
            if (!(entry.getKey() instanceof RubySymbol)) {
                throw context.getRuntime().newTypeError(values, context.getRuntime().getSymbol());
            }
            if (!(entry.getValue() instanceof RubyInteger)) {
                throw context.getRuntime().newTypeError(values, context.getRuntime().getInteger());
            }
            RubySymbol sym = (RubySymbol)entry.getKey();
            s2v.put(sym, (RubyInteger)entry.getValue());
            v2s.put(RubyNumeric.num2int((IRubyObject)entry.getValue()), sym);
        }
        this.symbolToValue = s2v;
        this.valueToSymbol = v2s;
        return this;
    }

    @JRubyMethod(name={"native_type"})
    public final IRubyObject native_type(ThreadContext context) {
        return this.nativeType;
    }

    @JRubyMethod(name={"to_native"})
    public final IRubyObject to_native(ThreadContext context, IRubyObject name2, IRubyObject ctx) {
        RubyInteger value2;
        if (name2 instanceof RubySymbol && (value2 = this.symbolToValue.get((RubySymbol)name2)) != null) {
            return value2;
        }
        if (name2 instanceof RubyInteger) {
            return name2;
        }
        if (name2.respondsTo("to_int")) {
            return name2.convertToInteger();
        }
        throw name2.getRuntime().newArgumentError("invalid enum value, " + name2.inspect());
    }

    @JRubyMethod(name={"from_native"})
    public final IRubyObject from_native(ThreadContext context, IRubyObject value2, IRubyObject ctx) {
        RubySymbol sym;
        if (value2 instanceof RubyInteger && (sym = this.valueToSymbol.get((int)((RubyInteger)value2).getLongValue())) != null) {
            return sym;
        }
        return value2;
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new Enum(runtime2, klass);
        }
    }
}

