/*
 * Decompiled with CFR 0.152.
 */
package GeneralData_preprocess;

import GeneralData_preprocess.PrintParameters;
import GeneralData_preprocess.build_RelDB;
import GeneralData_preprocess.build_RelDB_SbySEdition4arff_Maptask_test;
import GeneralData_preprocess.build_Sequences_SbyS;
import GeneralData_preprocess.offsets;
import GeneralData_preprocess.phrase_annotations;
import RLpackage.TreeNode;
import RLpackage.TreeRepresentation;
import SemEval2013.build_RelDB_SbySForSVMstructSemanticWeb;
import SemEval2013.build_RelDB_SbySForSVMstructSemanticWeb_Train_Test;
import SemEval2013.spatialFrame;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import util13.XmLExtract;

public class sentence {
    private final Logger logger = Logger.getLogger("SemEval2013-SpRL");
    private String loggingInfo;
    public String content;
    public Vector<relation> relations = new Vector();
    public Vector<nonrelation> nonrelations = new Vector();
    public Vector<Integer> selectedNegatives = new Vector();
    public Vector<nonrelation> allnonrel = new Vector();
    public Vector<nonrelation> allPosRelCandids = new Vector();
    Vector<ling_features> sentence_feat = new Vector();
    potential_pivots_class potential_pivots = new potential_pivots_class();
    Vector<Integer> non_SP_tpps = new Vector();
    Vector<Integer> non_tr = new Vector();
    Vector<Integer> non_lm = new Vector();
    Vector<Integer> tr_candidates = new Vector();
    Vector<Integer> lm_candidates = new Vector();
    Vector<Integer> sp_candidates = new Vector();

    public sentence() {
        this.loggingInfo = "<unknown>";
    }

    public sentence(String loggingInfo) {
        this.loggingInfo = loggingInfo;
    }

    private void log(Level level, String msg) {
        this.logger.log(level, String.valueOf(this.loggingInfo) + ": " + msg);
    }

    public boolean isInrelations(nonrelation x) {
        int i = 0;
        while (i < this.relations.size()) {
            if (this.relations.elementAt((int)i).wh_tr.head_index == -1) {
                this.relations.elementAt((int)i).wh_tr.head_index = this.sentence_feat.size();
            }
            if (this.relations.elementAt((int)i).wh_lm.head_index == -1) {
                this.relations.elementAt((int)i).wh_lm.head_index = this.sentence_feat.size();
            }
            if (x.lm == this.relations.elementAt((int)i).wh_lm.head_index && x.tr == this.relations.elementAt((int)i).wh_tr.head_index && x.sp == this.relations.elementAt((int)i).wh_sp.head_index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int[][] make_similarity_matrix() {
        if (this.relations.size() != 0 & this.allnonrel.size() != 0) {
            int[][] sim = new int[this.relations.size()][this.allnonrel.size()];
            int i = 0;
            while (i < this.relations.size()) {
                int j = 0;
                while (j < this.allnonrel.size()) {
                    if (this.relations.elementAt((int)i).wh_sp.head_index == this.allnonrel.elementAt((int)j).sp) {
                        sim[i][j] = sim[i][j] + 2;
                    }
                    if (this.relations.elementAt((int)i).wh_lm.head_index == this.allnonrel.elementAt((int)j).lm) {
                        sim[i][j] = sim[i][j] + 2;
                    }
                    if (this.relations.elementAt((int)i).wh_tr.head_index == this.allnonrel.elementAt((int)j).tr) {
                        sim[i][j] = sim[i][j] + 2;
                    }
                    if (this.relations.elementAt((int)i).wh_tr.head_index == this.allnonrel.elementAt((int)j).lm) {
                        sim[i][j] = sim[i][j] + 1;
                    }
                    if (this.relations.elementAt((int)i).wh_lm.head_index == this.allnonrel.elementAt((int)j).tr) {
                        sim[i][j] = sim[i][j] + 1;
                    }
                    ++j;
                }
                ++i;
            }
            return sim;
        }
        return null;
    }

    int[] maxim(int[][] a, int n) {
        int max;
        int[] b = new int[a[0].length];
        int j = 0;
        while (j < a[0].length) {
            max = -1;
            int i = 0;
            while (i < a.length) {
                if (a[i][j] < max) {
                    b[j] = max;
                } else {
                    b[j] = a[i][j];
                    max = b[j];
                }
                ++i;
            }
            ++j;
        }
        int[] m = new int[n + 1];
        if (b.length != 0) {
            max = 0;
            int index = 0;
            int j2 = 0;
            while (j2 < n) {
                max = -1;
                int i = 0;
                while (i < b.length) {
                    if (b[i] > max) {
                        max = b[i];
                        index = i;
                    }
                    ++i;
                }
                m[j2] = index;
                b[index] = -1;
                ++j2;
            }
        }
        if (n != 0 & b.length != 0) {
            m[n] = -1;
        }
        return m;
    }

    public void selective_negatives() {
        int[][] sim_matrix = this.make_similarity_matrix();
        if (sim_matrix != null) {
            int[] m = this.maxim(sim_matrix, sim_matrix[0].length);
            int mind = 0;
            while (m[mind] != -1) {
                this.selectedNegatives.addElement(m[mind]);
                ++mind;
            }
        } else if (this.allnonrel.size() > 0) {
            this.selectedNegatives.addElement(0);
        }
    }

    public Vector<Vector<String>> fetch_lth_matrix(BufferedReader lth_file) throws IOException {
        Vector<Vector<String>> Feature_Matrix = new Vector<Vector<String>>();
        while (lth_file.ready()) {
            String input = lth_file.readLine();
            this.log(Level.FINE, input);
            Vector<String> Rows = new Vector<String>();
            StringTokenizer st = new StringTokenizer(input);
            while (st.hasMoreTokens()) {
                Rows.addElement(st.nextToken());
            }
            if (Rows.size() < 10) continue;
            Feature_Matrix.addElement(Rows);
        }
        return Feature_Matrix;
    }

    public TreeNode fetch_char(BufferedReader brChar) throws IOException {
        TreeNode top = null;
        String sen1 = brChar.readLine();
        this.log(Level.FINE, sen1);
        if (sen1.toUpperCase() == sen1) {
            sen1 = brChar.readLine();
        }
        if (sen1 == null) {
            return null;
        }
        if (sen1.toUpperCase() != sen1) {
            top = TreeRepresentation.readTree(sen1);
        }
        return top;
    }

    public static Vector<String> type_tok(String s, String c) {
        StringTokenizer st = new StringTokenizer(s, c);
        Vector<String> t = new Vector<String>();
        while (st.hasMoreTokens()) {
            String S = st.nextToken();
            t.addElement(S);
        }
        return t;
    }

    public void read_rel_Sentence_xml(Vector<spatialFrame> rels, Vector<phrase_annotations> Trs, Vector<phrase_annotations> Lms, Vector<phrase_annotations> Sps, Vector<phrase_annotations> Mos, Vector<phrase_annotations> Dirs, Vector<phrase_annotations> Diss, Vector<phrase_annotations> Pats, int SenB) {
        int i = 0;
        while (i < rels.size()) {
            relation myRel = new relation();
            phrase_annotations Tr = XmLExtract.find_roleInfo(rels.elementAt(i).get_Tr(), Trs);
            phrase_annotations Lm = XmLExtract.find_roleInfo(rels.elementAt(i).get_Lm(), Lms);
            phrase_annotations Sp = XmLExtract.find_roleInfo(rels.elementAt(i).get_Sp(), Sps);
            phrase_annotations Mo = XmLExtract.find_roleInfo(rels.elementAt(i).get_Motion(), Mos);
            phrase_annotations Dir = XmLExtract.find_roleInfo(rels.elementAt(i).get_Dir(), Dirs);
            phrase_annotations Dis = XmLExtract.find_roleInfo(rels.elementAt(i).get_Dis(), Diss);
            phrase_annotations Pat = XmLExtract.find_roleInfo(rels.elementAt(i).get_path(), Pats);
            if (Tr.id != null || Lm.id != null || Sp.id != null || Mo.id != null || Dir.id != null || Dis.id != null || Pat.id != null) {
                myRel.wh_tr = this.ProcessRole(Tr, SenB);
                myRel.wh_lm = this.ProcessRole(Lm, SenB);
                myRel.wh_sp = this.ProcessRole(Sp, SenB);
                this.relations.addElement(myRel);
                if (Tr.id == null) {
                    ++build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.UndefTrajectors;
                }
                if (Lm.id == null) {
                    ++build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.UndefLandmark;
                }
                if (Sp.id == null) {
                    ++build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.UndefSp;
                }
                if (Mo.id == null) {
                    ++build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.UndefMotion;
                }
                if (Mo.id == null && Sp.id == null) {
                    ++build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.UndefSp_Mo;
                }
                if (Sp.id == null && Dir.id == null) {
                    ++build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.UndefSp_DIR;
                }
                if (Sp.id == null && Dir.id == null && Mo.id == null) {
                    ++build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.Undef_Sp_Mo_DIR;
                }
                if (Sp.id == null && Dir.id == null && Mo.id == null && Dis.id == null) {
                    ++build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.Undef_Sp_Mo_DIR_DIS;
                }
                if (Lm.id == null && Pat.id == null) {
                    ++build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.Undef_Path_Lm;
                }
                ++build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.SpatialRelations;
            }
            ++i;
        }
    }

    public phrase ProcessRole(phrase_annotations role, int SenB) {
        phrase converTrole = new phrase();
        converTrole.head_index = -1;
        offsets tempOffset = new offsets();
        tempOffset.set(role.phrase_offset.B - SenB, role.phrase_offset.E - SenB);
        boolean foundRepresentation = false;
        if (role.id != null) {
            int i = 0;
            while (i < this.sentence_feat.size()) {
                if (tempOffset.contains(this.sentence_feat.elementAt((int)i).words.offset)) {
                    foundRepresentation = true;
                    converTrole.ph.addElement(this.sentence_feat.elementAt((int)i).words.word);
                    role.wordIndexes = Arrays.copyOf(role.wordIndexes, role.wordIndexes.length + 1);
                    role.wordIndexes[role.wordIndexes.length - 1] = i;
                }
                ++i;
            }
            if (!foundRepresentation) {
                this.log(Level.SEVERE, "Could not find representation for role at offsets " + tempOffset.B + " - " + tempOffset.E + " substring:" + this.content.substring(tempOffset.B, tempOffset.E) + ". Expected text: " + role.phrase_text + ", id: " + role.id);
            }
            converTrole.head_index = build_RelDB_SbySForSVMstructSemanticWeb.HeadW_with_index(role.wordIndexes, this.sentence_feat);
            converTrole.ph_head = this.sentence_feat.elementAt((int)converTrole.head_index).words.word;
        }
        return converTrole;
    }

    public void fetch_allnonrel() {
        Vector<nonrelation> candidates = new Vector<nonrelation>();
        int i = 0;
        while (i < this.sp_candidates.size()) {
            int j = 0;
            while (j < this.tr_candidates.size()) {
                int k = 0;
                while (k < this.lm_candidates.size()) {
                    nonrelation temp = new nonrelation();
                    temp.sp = this.sp_candidates.elementAt(i);
                    temp.tr = this.tr_candidates.elementAt(j);
                    temp.lm = this.lm_candidates.elementAt(k);
                    if (!this.isInrelations(temp) & temp.lm != temp.tr & temp.lm != temp.sp & temp.tr != temp.sp) {
                        candidates.addElement(temp);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < candidates.size()) {
            this.allnonrel.addElement((nonrelation)candidates.elementAt(j));
            ++j;
        }
        this.selective_negatives();
    }

    public void fetch_nonrel() {
        Vector<nonrelation> candidates = new Vector<nonrelation>();
        int a = 0;
        while (a < this.non_SP_tpps.size()) {
            int b = 0;
            while (b < this.non_tr.size()) {
                int c = 0;
                while (c < this.non_lm.size()) {
                    if (this.non_SP_tpps.elementAt(a) != this.non_tr.elementAt(b) && this.non_tr.elementAt(b) != this.non_lm.elementAt(c) && this.non_SP_tpps.elementAt(a) != this.non_lm.elementAt(c)) {
                        nonrelation temp = new nonrelation();
                        temp.sp = this.non_SP_tpps.elementAt(a);
                        temp.tr = this.non_tr.elementAt(b);
                        temp.lm = this.non_lm.elementAt(c);
                        candidates.addElement(temp);
                    }
                    ++c;
                }
                ++b;
            }
            ++a;
        }
        int j = 0;
        while (j < candidates.size()) {
            this.nonrelations.addElement((nonrelation)candidates.elementAt(j));
            ++j;
        }
    }

    public void fetch_prunedrel(int count) {
        int p = 0;
        int i = 0;
        while (i < this.nonrelations.size()) {
            count += p;
            ++i;
        }
    }

    public void prun_empty_relations() {
        int r = 0;
        while (r < this.relations.size()) {
            if (this.relations.elementAt((int)r).wh_sp.head_index == -1) {
                this.relations.removeElementAt(r);
                continue;
            }
            ++r;
        }
    }

    public void fetch_allPosRelCandids(int j) {
        int i = 0;
        while (i < this.relations.size()) {
            if (this.relations.elementAt((int)i).wh_lm.head_index == -1) {
                this.relations.elementAt((int)i).wh_lm.head_index = this.sentence_feat.size();
            }
            if (this.relations.elementAt((int)i).wh_tr.head_index == -1) {
                this.relations.elementAt((int)i).wh_tr.head_index = this.sentence_feat.size();
            }
            if (this.lm_candidates.contains(this.relations.elementAt((int)i).wh_lm.head_index) & this.tr_candidates.contains(this.relations.elementAt((int)i).wh_tr.head_index) & this.sp_candidates.contains(this.relations.elementAt((int)i).wh_sp.head_index)) {
                nonrelation temp = new nonrelation();
                temp.sp = this.relations.elementAt((int)i).wh_sp.head_index;
                temp.tr = this.relations.elementAt((int)i).wh_tr.head_index;
                temp.lm = this.relations.elementAt((int)i).wh_lm.head_index;
                this.allPosRelCandids.addElement(temp);
            }
            ++i;
        }
    }

    public void fetch_rel(Vector<Vector<String>> Rows, int i) {
        if (Rows.elementAt(i).size() < 15) {
            this.log(Level.WARNING, "this row" + i + " does not contain a full sentence!!");
        } else {
            this.content = Rows.elementAt(i).elementAt(0);
            this.content = this.content.trim();
            this.content = this.content.replace(",", " , ");
            this.content = this.content.replace("(", " ( ");
            this.content = this.content.replace("?", " ? ");
            this.content = this.content.replace(")", " ) ");
            this.content = this.content.replaceAll("[\\s][\\s]*", " ");
            this.content = this.content.replaceAll("\"", "");
            do {
                relation r = new relation();
                if (Rows.elementAt(i).size() == 15) {
                    Rows.elementAt(i).add(0, " ");
                }
                r.read_rel(Rows.elementAt(i));
                this.relations.addElement(r);
            } while (Rows.elementAt(++i).size() != 16 && !Rows.elementAt(i).elementAt(0).contains("*"));
        }
    }

    public void fetch_relXml(Node Tag, String sen, offsets ind, Vector<spatialFrame> rels) throws FileNotFoundException {
        Vector<Object> Trs = new Vector();
        Vector<Object> Lms = new Vector();
        Vector<Object> Sps = new Vector();
        Vector<Object> Mos = new Vector();
        Vector<Object> Dirs = new Vector();
        Vector<Object> Dis = new Vector();
        Vector<Object> Pat = new Vector();
        Trs = XmLExtract.role_annotations("TRAJECTOR", ind, Tag, sen);
        Lms = XmLExtract.role_annotations("LANDMARK", ind, Tag, sen);
        Sps = XmLExtract.role_annotations("SPATIAL_INDICATOR", ind, Tag, sen);
        Mos = XmLExtract.role_annotations("MOTION_INDICATOR", ind, Tag, sen);
        Dirs = XmLExtract.role_annotations("DIRECTION", ind, Tag, sen);
        Dis = XmLExtract.role_annotations("DISTANCE", ind, Tag, sen);
        Pat = XmLExtract.role_annotations("PATH", ind, Tag, sen);
        build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.Trajector_num += Trs.size();
        build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.Landmark_num += Lms.size();
        build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.SpatialIndicator_num += Sps.size();
        build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.Motion_Indicator_num += Mos.size();
        build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.Direction_Indicator_num += Dirs.size();
        build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.Distance_value += Dis.size();
        build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.Path_num += Pat.size();
        this.read_rel_Sentence_xml(rels, Trs, Lms, Sps, Mos, Dirs, Dis, Pat, ind.B);
    }

    public Vector<Vector<String>> fix(Vector<Vector<String>> lth_m) {
        int index = -1;
        int i = 0;
        while (i < lth_m.size()) {
            if (lth_m.elementAt(i).elementAt(1).equals("p")) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            lth_m.elementAt(index).set(1, "p.m.");
            lth_m.remove(index + 1);
            lth_m.remove(index + 1);
            i = index + 1;
            while (i < lth_m.size()) {
                lth_m.elementAt(i).set(0, Integer.toString(i + 1));
                lth_m.elementAt(i).set(8, Integer.toString(Integer.parseInt(lth_m.elementAt(i).elementAt(8)) + index));
                ++i;
            }
        }
        return lth_m;
    }

    public Vector<Vector<String>> check_lth_index(Vector<Vector<String>> lth_m) {
        int index = -1;
        int i = 0;
        boolean flag = false;
        while (i < lth_m.size() - 1) {
            if (Integer.parseInt(lth_m.elementAt(i).elementAt(0)) < Integer.parseInt(lth_m.elementAt(i + 1).elementAt(0)) && !flag) {
                ++i;
                continue;
            }
            if (lth_m.elementAt(i + 1).elementAt(0).equals("1")) {
                index = i + 1;
            }
            lth_m.elementAt(i + 1).set(0, Integer.toString(i + 2));
            lth_m.elementAt(i + 1).set(8, Integer.toString(Integer.parseInt(lth_m.elementAt(i + 1).elementAt(8)) + index));
            ++i;
        }
        return lth_m;
    }

    public void assign_lth_f(Vector<Vector<String>> lth_m) {
        int lookahead = 0;
        if (this.content.contains("p.m.")) {
            lth_m = this.fix(lth_m);
        }
        lth_m = this.check_lth_index(lth_m);
        int i = 0;
        while (i < lth_m.size()) {
            int E = this.content.length();
            int B = E - 1;
            ling_features f = new ling_features();
            f.words.word = lth_m.elementAt(i).elementAt(1);
            f.words.pos = lth_m.elementAt(i).elementAt(4);
            f.words.head = lth_m.elementAt(i).elementAt(8);
            f.words.DPRL = lth_m.elementAt(i).elementAt(9);
            f.words.SRL = build_RelDB.SRL(i, lth_m);
            f.words.lemma = lth_m.elementAt(i).elementAt(2);
            if (i != lth_m.size() - 1) {
                B = lookahead;
                while (B < this.content.length()) {
                    if (!Character.isWhitespace(this.content.charAt(B))) break;
                    ++B;
                }
                E = Math.min(this.content.length(), B + f.words.word.length());
                if (!this.content.startsWith(f.words.word, B)) {
                    if (f.words.word.equals("``") && this.content.startsWith("\"", B) || f.words.word.equals("''") && this.content.startsWith("\"", B) || f.words.word.equals("-LRB-") && this.content.startsWith("(", B) || f.words.word.equals("-RRB-") && this.content.startsWith(")", B) || f.words.word.equals("--") && this.content.startsWith("\u2013", B)) {
                        E = B + 1;
                    } else {
                        this.log(Level.WARNING, "[Error] Not matching content: " + f.words.word + " vs. " + this.content.substring(B, E));
                    }
                }
            }
            f.words.offset.set(B, E);
            this.sentence_feat.addElement(f);
            lookahead = E;
            ++i;
        }
    }

    public void assign_tree_f(TreeNode charniak, Vector<Vector<String>> lth_matrix) {
        Vector<TreeNode> Nodes_ = charniak.getAllNodesOfTree();
        Vector<TreeNode> Sentence = charniak.getLeafNodes();
        int wordNum = Sentence.size();
        int nodNum = charniak.getNumberOfNodesInTree();
        int[] Tree_indexes = new int[wordNum];
        Tree_indexes = build_RelDB.find_tree_indexes(Nodes_, lth_matrix);
        int w = 0;
        while (w < wordNum) {
            String wordsubcat = "";
            TreeNode tem = Nodes_.elementAt(Tree_indexes[w]).getParent();
            if (tem != null) {
                TreeNode[] childeren1 = tem.getChildren();
                int i1 = 0;
                while (i1 < childeren1.length) {
                    wordsubcat = String.valueOf(wordsubcat) + childeren1[i1].getLabel() + "_";
                    ++i1;
                }
            }
            this.sentence_feat.elementAt((int)w).words.subcategorization = wordsubcat;
            int w_2 = 0;
            while (w_2 < wordNum) {
                this.sentence_feat.elementAt((int)w).word_word.path.addElement(Nodes_.elementAt(Tree_indexes[w]).getPath(Nodes_.elementAt(Tree_indexes[w_2])));
                this.sentence_feat.elementAt((int)w).word_word.deppath.addElement(this.depPath(w, w_2));
                int distance = TreeNode.getPathDistance(Nodes_.elementAt(Tree_indexes[w_2]), Nodes_.elementAt(Tree_indexes[w]));
                this.sentence_feat.elementAt((int)w).word_word.distance.addElement(distance);
                if (distance != 0) {
                    distance = nodNum / distance;
                }
                ++w_2;
            }
            ++w;
        }
    }

    public String depPath(int w1, int w2) {
        String result = "";
        if (w1 == w2) {
            return result;
        }
        if (this.sentence_feat.elementAt((int)w1).words.head.equals("0") && !this.sentence_feat.elementAt((int)w2).words.head.equals("0")) {
            result = this.depPath(w2, w1);
        } else if (!this.sentence_feat.elementAt((int)w1).words.head.equals(Integer.toString(w2 + 1))) {
            result = this.depPath(Integer.parseInt(this.sentence_feat.elementAt((int)w1).words.head) - 1, w2);
        }
        result = String.valueOf(result) + "_" + this.sentence_feat.elementAt((int)w1).words.DPRL;
        return result;
    }

    public boolean tr_annotated(int i) {
        boolean flag = false;
        int r = 0;
        while (r < this.relations.size()) {
            if (this.relations.elementAt((int)r).wh_tr.head_index == i) {
                flag = true;
                break;
            }
            ++r;
        }
        return flag;
    }

    public boolean lm_annotated(int i) {
        boolean flag = false;
        int r = 0;
        while (r < this.relations.size()) {
            if (this.relations.elementAt((int)r).wh_lm.head_index == i) {
                flag = true;
                break;
            }
            ++r;
        }
        return flag;
    }

    public boolean sp_annotated(int i) {
        boolean flag = false;
        int r = 0;
        while (r < this.relations.size()) {
            if (this.relations.elementAt((int)r).wh_sp.ph != null && this.relations.elementAt((int)r).wh_sp.head_index == i) {
                flag = true;
                break;
            }
            ++r;
        }
        return flag;
    }

    public boolean SpTr_annotated(int i, int j) {
        boolean flag = false;
        int r = 0;
        while (r < this.relations.size()) {
            if (this.relations.elementAt((int)r).wh_sp.ph_head != null && this.relations.elementAt((int)r).wh_tr.ph_head != null && this.sp_candidates.contains(new Integer(this.relations.elementAt((int)r).wh_sp.head_index)) && this.tr_candidates.contains(new Integer(this.relations.elementAt((int)r).wh_tr.head_index))) {
                if (this.relations.elementAt((int)r).wh_sp.head_index == i && this.relations.elementAt((int)r).wh_tr.head_index == j) {
                    flag = true;
                    break;
                }
            } else {
                if (!(i != this.sentence_feat.size() || this.relations.elementAt((int)r).wh_sp.ph_head != null && this.sp_candidates.contains(new Integer(this.relations.elementAt((int)r).wh_sp.head_index)) || this.relations.elementAt((int)r).wh_tr.head_index != j)) {
                    flag = true;
                    break;
                }
                if (!(j != this.sentence_feat.size() || this.relations.elementAt((int)r).wh_sp.head_index != i || this.relations.elementAt((int)r).wh_tr.ph_head != null && this.tr_candidates.contains(this.relations.elementAt((int)r).wh_tr.head_index))) {
                    flag = true;
                    break;
                }
            }
            ++r;
        }
        return flag;
    }

    public boolean SpLm_annotated(int i, int j) {
        boolean flag = false;
        int r = 0;
        while (r < this.relations.size()) {
            if (this.relations.elementAt((int)r).wh_sp.ph_head != null && this.relations.elementAt((int)r).wh_lm.ph_head != null && this.sp_candidates.contains(new Integer(this.relations.elementAt((int)r).wh_sp.head_index)) && this.lm_candidates.contains(new Integer(this.relations.elementAt((int)r).wh_lm.head_index))) {
                if (this.relations.elementAt((int)r).wh_sp.head_index == i && this.relations.elementAt((int)r).wh_lm.head_index == j) {
                    flag = true;
                    break;
                }
            } else {
                if (!(i != this.sentence_feat.size() || this.relations.elementAt((int)r).wh_sp.ph_head != null && this.sp_candidates.contains(new Integer(this.relations.elementAt((int)r).wh_sp.head_index)) || this.relations.elementAt((int)r).wh_lm.head_index != j)) {
                    flag = true;
                    break;
                }
                if (!(j != this.sentence_feat.size() || this.relations.elementAt((int)r).wh_sp.head_index != i || this.relations.elementAt((int)r).wh_lm.ph_head != null && this.lm_candidates.contains(this.relations.elementAt((int)r).wh_lm.head_index))) {
                    flag = true;
                    break;
                }
            }
            ++r;
        }
        return flag;
    }

    public void build_nonTR_LM() {
        int w = 0;
        while (w < this.sentence_feat.size()) {
            boolean flag1 = false;
            boolean flag2 = false;
            int r = 0;
            while (r < this.relations.size()) {
                if (this.relations.elementAt((int)r).wh_tr.head_index == w) {
                    flag1 = true;
                }
                if (this.relations.elementAt((int)r).wh_lm.head_index == w) {
                    flag2 = true;
                }
                ++r;
            }
            if (this.sentence_feat.elementAt((int)w).words.pos.toLowerCase().contains("nn") || this.sentence_feat.elementAt((int)w).words.pos.toLowerCase().contains("nns") || this.sentence_feat.elementAt((int)w).words.pos.toLowerCase().contains("prp")) {
                if (!flag1) {
                    this.non_tr.add(w);
                }
                if (!flag2) {
                    this.non_lm.add(w);
                }
            }
            ++w;
        }
    }

    public void build_all_candidates(Set<String> addedSpLemmas, boolean collectNewLemmas) {
        int w = 0;
        while (w < this.sentence_feat.size()) {
            if (this.sentence_feat.elementAt((int)w).words.pos.toLowerCase().contains("nn") || this.sentence_feat.elementAt((int)w).words.pos.toLowerCase().contains("wrb") || this.sentence_feat.elementAt((int)w).words.pos.toLowerCase().contains("nns") || this.sentence_feat.elementAt((int)w).words.DPRL.toLowerCase().contains("sbj") || this.sentence_feat.elementAt((int)w).words.pos.toLowerCase().contains("prp")) {
                this.tr_candidates.add(w);
            } else if (this.tr_annotated(w)) {
                ++build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.missed_Tr;
            }
            if (this.sentence_feat.elementAt((int)w).words.pos.toLowerCase().contains("nn") || this.sentence_feat.elementAt((int)w).words.pos.toLowerCase().contains("nns") || this.sentence_feat.elementAt((int)w).words.pos.toLowerCase().contains("prp")) {
                this.lm_candidates.add(w);
            } else if (this.lm_annotated(w)) {
                ++build_RelDB_SbySForSVMstructSemanticWeb_Train_Test.statis.missed_Lm;
            }
            String spLemma = this.sentence_feat.elementAt((int)w).words.lemma;
            if (spLemma.isEmpty() || spLemma.equals("_")) {
                spLemma = this.sentence_feat.elementAt((int)w).words.word;
            }
            if (this.sentence_feat.elementAt((int)w).words.pos.toLowerCase().contains("in") || this.sentence_feat.elementAt((int)w).words.pos.toLowerCase().contains("on") || this.sentence_feat.elementAt((int)w).words.pos.toLowerCase().contains("to") || addedSpLemmas.contains(spLemma)) {
                this.sp_candidates.add(w);
            } else if (this.sp_annotated(w)) {
                if (collectNewLemmas) {
                    if (addedSpLemmas != null) {
                        addedSpLemmas.add(spLemma);
                    }
                    this.sp_candidates.add(w);
                } else {
                    this.logger.info("Missed spatial indicator: '" + spLemma + "'");
                }
            }
            ++w;
        }
        this.tr_candidates.add(this.sentence_feat.size());
        this.lm_candidates.add(this.sentence_feat.size());
        this.sp_candidates.add(this.sentence_feat.size());
    }

    public Vector<phrase> tpp_prepositions_index(String input) {
        String[] T = input.split(" ");
        Vector<phrase> a1 = new Vector<phrase>();
        int i = 0;
        while (i < T.length) {
            if (build_RelDB.find_(build_RelDB.Prepositions, T[i])) {
                if (!this.sp_annotated(i)) {
                    this.non_SP_tpps.add(i);
                }
                phrase t = new phrase();
                t.head_index = i;
                t.ph_head = T[i].toLowerCase();
                t.ph.addElement(T[i].toLowerCase());
                a1.add(t);
            }
            ++i;
        }
        return a1;
    }

    public void fetch_ling_features(BufferedReader lth_file, BufferedReader charniak_file) throws IOException {
        this.log(Level.FINE, this.content);
        this.content = this.content.trim();
        Vector<Vector<String>> lth_matrix = this.fetch_lth_matrix(lth_file);
        TreeNode char_tree = this.fetch_char(charniak_file);
        this.assign_lth_f(lth_matrix);
        this.assign_tree_f(char_tree, lth_matrix);
        lth_matrix = null;
        char_tree = null;
        System.gc();
    }

    public void fetch_spatial_pivots() {
        this.potential_pivots.tpp_prepositions = this.tpp_prepositions_index(this.content);
    }

    public String constant_correction(String input) {
        if (input != null) {
            input = input.replaceAll("\ufffd\ufffd", "x");
            input = input.replaceAll("\ufffd\ufffd", "0");
            input = input.replaceAll("-", "_");
            input = input.replaceAll(":", "_");
            input = input.replaceAll("[^a-zA-Z0-9\\s_]", "");
            input = input.replaceAll("[\\s][\\s]*", "");
            if ((input = input.toLowerCase().trim()).toUpperCase().contains("_LRB")) {
                System.out.print("Stop");
            }
            if (input.startsWith("_")) {
                input = input.replaceFirst("[_][_]*", "");
            }
            if (input.equals("_")) {
                input = "0";
            }
            if (input.equals("")) {
                input = "0";
            }
        }
        return input;
    }

    public void writeInput_features(PrintWriter p, int i) {
        int w = 0;
        while (w < this.sentence_feat.size()) {
            p.println("dprl(" + i + "," + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.DPRL) + ").");
            p.println("lemma(" + i + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.lemma) + ").");
            p.println("pos(" + i + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.pos) + ").");
            p.println("srl(" + i + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.SRL) + ").");
            p.println("subcategorization(" + i + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.subcategorization) + ").");
            p.println("word(" + i + "," + this.sentence_feat.elementAt((int)w).words.word + ").");
            int w_2 = 0;
            while (w_2 < this.sentence_feat.size()) {
                p.println("distance(" + i + "," + w + "," + w_2 + "," + this.sentence_feat.elementAt((int)w).word_word.distance.elementAt(w_2) + ").");
                p.println("path(" + i + "," + w + "," + w_2 + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).word_word.path.elementAt(w_2)) + ").");
                ++w_2;
            }
            ++w;
        }
    }

    public void writeInputRelations(PrintWriter p, int i) {
        int r = 0;
        while (r < this.relations.size()) {
            p.println("sentence(s" + i + "," + "r" + (i + r) + ").");
            p.println("sr(r" + (i + r) + "," + this.relations.elementAt((int)r).wh_sp.head_index + "," + this.relations.elementAt((int)r).wh_tr.head_index + "," + this.relations.elementAt((int)r).wh_lm.head_index + ").");
            p.println("motion(r" + (i + r) + "," + this.relations.elementAt((int)r).wh_motion.head_index + ").");
            p.println("rpath(r" + (i + r) + "," + this.relations.elementAt((int)r).path + ").");
            p.println("frRef(r" + (i + r) + "," + this.relations.elementAt((int)r).FrORe + ").");
            p.println("dynamic(r" + (i + r) + "," + this.relations.elementAt((int)r).dynamic + ").");
            ++r;
        }
    }

    public void writecalculi(PrintWriter p, int i) {
        int r = 0;
        while (r < this.relations.size()) {
            int t = 0;
            while (t < this.relations.elementAt((int)r).calc_type.general.size()) {
                p.println("gen_calc(r" + (i + r) + "," + "t" + t + "," + this.relations.elementAt((int)r).calc_type.general.elementAt(t) + ").");
                ++t;
            }
            t = 0;
            while (t < this.relations.elementAt((int)r).calc_type.sp_value.size()) {
                p.println("specific_calc(r" + (i + r) + "," + "t" + t + "," + this.relations.elementAt((int)r).calc_type.sp_value.elementAt(t) + ").");
                ++t;
            }
            t = 0;
            while (t < this.relations.elementAt((int)r).calc_type.sp_value.size()) {
                p.println("sp_value(r" + (i + r) + "," + "t" + t + "," + this.relations.elementAt((int)r).calc_type.sp_value.elementAt(t) + ").");
                ++t;
            }
            ++r;
        }
    }

    public boolean word_word_needed(int w1, int w2) {
        boolean flagw1 = false;
        boolean flagw2 = false;
        int r = 0;
        while (r < this.relations.size()) {
            if (this.relations.elementAt((int)r).wh_lm.head_index == w2 || this.relations.elementAt((int)r).wh_tr.head_index == w2) {
                flagw2 = true;
            }
            if (this.relations.elementAt((int)r).wh_sp.head_index == w1) {
                flagw1 = true;
            }
            ++r;
        }
        int nr = 0;
        while (nr < this.nonrelations.size()) {
            if (this.nonrelations.elementAt((int)nr).lm == w2 || this.nonrelations.elementAt((int)nr).tr == w2) {
                flagw2 = true;
            }
            if (this.nonrelations.elementAt((int)nr).sp == w1) {
                flagw1 = true;
            }
            ++nr;
        }
        return flagw1 && flagw2;
    }

    public void writeInp_featkLog(PrintWriter p, int i) {
        p.println("interpretation(i" + i + ", sentence(s" + i + ")).");
        int w = 0;
        while (w < this.sentence_feat.size()) {
            p.println("interpretation(i" + i + ", hasword(s" + i + ", w" + w + ")).");
            p.println("interpretation(i" + i + ", word(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.word) + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.pos) + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.DPRL) + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.SRL) + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.subcategorization) + ")).");
            int w_2 = 0;
            while (w_2 < this.sentence_feat.size()) {
                if (this.word_word_needed(w, w_2)) {
                    int position = 0;
                    if (w < w_2) {
                        position = 1;
                    }
                    p.println("interpretation(i" + i + ", word_word(w" + w + ", w" + w_2 + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).word_word.path.elementAt(w_2)) + "," + this.sentence_feat.elementAt((int)w).word_word.distance.elementAt(w_2) + "," + position + ")).");
                }
                ++w_2;
            }
            ++w;
        }
        p.println("interpretation(i" + i + ", hasword(s" + i + ", w" + this.sentence_feat.size() + ")).");
        p.println("interpretation(i" + i + ", word(w" + this.sentence_feat.size() + ", 0,0,0,0,0)).");
    }

    public void writeInput_featureskLog(PrintWriter p, int i) {
        if (i == 10) {
            System.out.print(i);
        }
        p.println("interpretation(i" + i + ", sentence(s" + i + ")).");
        int w = 0;
        while (w < this.sentence_feat.size()) {
            p.println("interpretation(i" + i + ", hasword(s" + i + ", w" + w + ")).");
            p.println("interpretation(i" + i + ", word(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.word) + ")).");
            p.println("interpretation(i" + i + ",pos(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.pos) + ")).");
            p.println("interpretation(i" + i + ",dprl(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.DPRL) + ")).");
            p.println("interpretation(i" + i + ",srl(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.SRL) + ")).");
            p.println("interpretation(i" + i + ",subcat(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.subcategorization) + ")).");
            int localindex = 0;
            while (localindex < this.potential_pivots.tpp_prepositions.size()) {
                if (this.potential_pivots.tpp_prepositions.elementAt((int)localindex).head_index == w) {
                    p.println("interpretation(i" + i + ",tpp(w" + w + ")).");
                }
                ++localindex;
            }
            int w_2 = 0;
            while (w_2 < this.sentence_feat.size()) {
                if (this.word_word_needed(w, w_2)) {
                    int position = 0;
                    if (w < w_2) {
                        position = 1;
                    }
                    p.println("interpretation(i" + i + ", word_word_path_ext(w" + w + ", w" + w_2 + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).word_word.path.elementAt(w_2)) + ")).");
                    p.println("interpretation(i" + i + ", word_word_dis_ext(w" + w + ", w" + w_2 + "," + this.sentence_feat.elementAt((int)w).word_word.distance.elementAt(w_2) + ")).");
                    p.println("interpretation(i" + i + ", word_word_befor_ext(w" + w + ", w" + w_2 + "," + position + ")).");
                }
                ++w_2;
            }
            ++w;
        }
        p.println("interpretation(i" + i + ", hasword(s" + i + ", w" + this.sentence_feat.size() + ")).");
        p.println("interpretation(i" + i + ", word(w" + this.sentence_feat.size() + ", undef0)).");
        p.println("interpretation(i" + i + ",pos(w" + this.sentence_feat.size() + ", 0)).");
        p.println("interpretation(i" + i + ",dprl(w" + this.sentence_feat.size() + ", 0)).");
        p.println("interpretation(i" + i + ",srl(w" + this.sentence_feat.size() + ", 0)).");
        p.println("interpretation(i" + i + ",subcat(w" + this.sentence_feat.size() + ", 0)).");
    }

    public void writeInputRelationskLog(PrintWriter p, int i) {
        int u = this.sentence_feat.size();
        int r = 0;
        while (r < this.relations.size()) {
            if (this.relations.elementAt((int)r).wh_sp.head_index == -1) {
                this.relations.elementAt((int)r).wh_sp.head_index = u;
            }
            if (this.relations.elementAt((int)r).wh_lm.head_index == -1) {
                this.relations.elementAt((int)r).wh_lm.head_index = u;
            }
            if (this.relations.elementAt((int)r).wh_tr.head_index == -1) {
                this.relations.elementAt((int)r).wh_tr.head_index = u;
            }
            p.println("interpretation(i" + i + ", rel(r" + r + ", w" + this.relations.elementAt((int)r).wh_sp.head_index + ", w" + this.relations.elementAt((int)r).wh_tr.head_index + ", w" + this.relations.elementAt((int)r).wh_lm.head_index + ")).");
            p.println("interpretation(i" + i + ", sprel(r" + r + ")).");
            p.println("interpretation(i" + i + ", goodsprel(r" + r + ")).");
            ++r;
        }
    }

    public void writeInputnonRelationskLog(PrintWriter p, int i, int ont, PrintWriter Np) {
        int nr = this.relations.size();
        int r = 0;
        while (r < this.nonrelations.size()) {
            if (r <= nr + 1) {
                p.println("interpretation(i" + i + ", rel(r" + (r + nr) + ", w" + this.nonrelations.elementAt((int)r).sp + ", w" + this.nonrelations.elementAt((int)r).tr + ", w" + this.nonrelations.elementAt((int)r).lm + ")).");
                p.println("interpretation(i" + i + ", sprel(r" + (r + nr) + ")).");
                if (ont == 1) {
                    p.println("interpretation(i" + i + ", ontoSeed" + ont + "(r" + (r + nr) + ")).");
                }
            } else {
                Np.println("interpretation(i" + i + ", rel(r" + (r + nr) + ", w" + this.nonrelations.elementAt((int)r).sp + ", w" + this.nonrelations.elementAt((int)r).tr + ", w" + this.nonrelations.elementAt((int)r).lm + ")).");
                Np.println("interpretation(i" + i + ", sprel(r" + (r + nr) + ")).");
                Np.println("interpretation(i" + i + ", spreltest(r" + (r + nr) + ")).");
            }
            ++r;
        }
    }

    public void writeInputnonRelationskLogSelectiveSam(PrintWriter p, int i, int ont, PrintWriter Np) {
        int nr = this.relations.size();
        int r = 0;
        while (r < this.nonrelations.size()) {
            if (r <= nr + 1) {
                p.println("interpretation(i" + i + ", selected_triplet" + "( w" + this.nonrelations.elementAt((int)r).sp + ", w" + this.nonrelations.elementAt((int)r).tr + ", w" + this.nonrelations.elementAt((int)r).lm + ")).");
            }
            if (ont == 1) {
                p.println("interpretation(i" + i + ", ontoSeed" + ont + "(w" + this.relations.elementAt((int)r).wh_sp.head_index + ", w" + this.relations.elementAt((int)r).wh_tr.head_index + ", w" + this.relations.elementAt((int)r).wh_lm.head_index + ")).");
            } else {
                Np.println("interpretation(i" + i + ", rel(r" + (r + nr) + ", w" + this.nonrelations.elementAt((int)r).sp + ", w" + this.nonrelations.elementAt((int)r).tr + ", w" + this.nonrelations.elementAt((int)r).lm + ")).");
                Np.println("interpretation(i" + i + ", sprel(r" + (r + nr) + ")).");
                Np.println("interpretation(i" + i + ", spreltest(r" + (r + nr) + ")).");
            }
            ++r;
        }
    }

    public void writeInputnonRelationskLogsimilaritySam(PrintWriter p, int i) {
        int j = 0;
        while (j < this.selectedNegatives.size()) {
            int r = this.selectedNegatives.elementAt(j);
            p.println("interpretation(i" + i + ", selected_triplet" + "( w" + this.allnonrel.elementAt((int)r).sp + ", w" + this.allnonrel.elementAt((int)r).tr + ", w" + this.allnonrel.elementAt((int)r).lm + ")).");
            ++j;
        }
    }

    public void writeInputnonRelkLogsimGradualSam(PrintWriter p, int i) {
        int j = 0;
        while (j < this.selectedNegatives.size()) {
            int r = this.selectedNegatives.elementAt(j);
            p.println("interpretation(i" + i + ", selected_triplet( w" + this.allnonrel.elementAt((int)r).sp + ", w" + this.allnonrel.elementAt((int)r).tr + ", w" + this.allnonrel.elementAt((int)r).lm + "," + j + ")).");
            ++j;
        }
    }

    public void write_G_calculikLog(PrintWriter p, int i) {
        int r = 0;
        while (r < this.relations.size()) {
            p.println("interpretation(i" + i + ", rel(r" + r + ", w" + this.relations.elementAt((int)r).wh_sp.head_index + ", w" + this.relations.elementAt((int)r).wh_tr.head_index + ", w" + this.relations.elementAt((int)r).wh_lm.head_index + ")).");
            p.println("interpretation(i" + i + ", sprel(r" + r + ")).");
            int t = 0;
            while (t < this.relations.elementAt((int)r).calc_type.general.size()) {
                String tg = this.relations.elementAt((int)r).calc_type.general.elementAt(t).toLowerCase();
                tg = tg.replaceAll(" ", "");
                tg = tg.replaceAll("\"", "");
                p.println("interpretation(i" + i + ", rel_g_type(r" + r + "," + tg + ")).");
                ++t;
            }
            ++r;
        }
    }

    public int index_Of(String[] s, String t) {
        int ind = -1;
        if (t.contains("pp")) {
            t = "pp";
        }
        int i = 0;
        while (i < s.length) {
            if (s[i].equals(t)) {
                ind = i;
                break;
            }
            ++i;
        }
        return ind;
    }

    public void flatten_sp(calculi x, int sp) {
        String[] labels = new String[]{"region", "direction", "distance", "eq", "dc", "ec", "po", "pp", "below", "left", "right", "behind", "front", "above"};
        int j = 1;
        x.flat_output[0] = sp;
        x.flat_output[1] = 1 - sp;
        int i = 0;
        while (i < x.general.size()) {
            if (i > 0) {
                System.out.print("Stop");
            }
            if ((j = this.index_Of(labels, x.general.elementAt(i).toLowerCase().trim())) != -1) {
                x.flat_output[j + 2] = 1;
            }
            if ((j = this.index_Of(labels, x.sp_value.elementAt(i).toLowerCase().trim())) != -1) {
                x.flat_output[j + 2] = 1;
            }
            ++i;
        }
    }

    public void writekHierarchyout(PrintWriter p, int i, int ontSeed) {
        int r = 0;
        while (r < this.relations.size()) {
            p.println("interpretation(i" + i + ", rel(r" + r + ", w" + this.relations.elementAt((int)r).wh_sp.head_index + ", w" + this.relations.elementAt((int)r).wh_tr.head_index + ", w" + this.relations.elementAt((int)r).wh_lm.head_index + ")).");
            p.println("interpretation(i" + i + ", sprel(r" + r + ")).");
            if (this.relations.elementAt((int)r).calc_type.flat_output[ontSeed] == 1) {
                p.println("interpretation(i" + i + ", ontoSeed" + ontSeed + "(r" + r + ")).");
            }
            ++r;
        }
    }

    public void writekHierarchyout_intensional(PrintWriter p, int i, int ontSeed) {
        int r = 0;
        while (r < this.relations.size()) {
            p.println("interpretation(i" + i + ", ontoSeed" + ontSeed + "(w" + this.relations.elementAt((int)r).wh_sp.head_index + ", w" + this.relations.elementAt((int)r).wh_tr.head_index + ", w" + this.relations.elementAt((int)r).wh_lm.head_index + ")).");
            ++r;
        }
    }

    void replacelm(int r) {
        String[] directions = new String[]{"left", "right", "front", "back", "center", "middle", "top", "down"};
        String find = null;
        int i = 0;
        while (i < directions.length) {
            if (this.relations.elementAt((int)r).wh_sp.ph.contains(directions[i])) {
                find = directions[i];
                break;
            }
            ++i;
        }
        int hind = -1;
        int dirind = -1;
        if (find != null) {
            int kk = 0;
            while (kk < this.relations.elementAt((int)r).wh_sp.ph.size()) {
                if (this.relations.elementAt((int)r).wh_sp.ph_head.replaceAll(" ", "").equalsIgnoreCase(this.relations.elementAt((int)r).wh_sp.ph.elementAt(kk))) {
                    hind = kk;
                }
                if (find.equalsIgnoreCase(this.relations.elementAt((int)r).wh_sp.ph.elementAt(kk))) {
                    dirind = kk;
                }
                ++kk;
            }
            this.relations.elementAt((int)r).wh_lm.ph_head = find;
            this.relations.elementAt((int)r).wh_lm.head_index = this.relations.elementAt((int)r).wh_sp.head_index + dirind - hind;
        }
    }

    public void write_intensional_changeLm(PrintWriter p, int i, int ontSeed) {
        int r = 0;
        while (r < this.relations.size()) {
            if (this.relations.elementAt((int)r).wh_lm.ph_head.equalsIgnoreCase("undefined")) {
                this.replacelm(r);
            }
            p.println("interpretation(i" + i + ", ontoSeed" + ontSeed + "(w" + this.relations.elementAt((int)r).wh_sp.head_index + ", w" + this.relations.elementAt((int)r).wh_tr.head_index + ", w" + this.relations.elementAt((int)r).wh_lm.head_index + ")).");
            ++r;
        }
    }

    public void dataStatistics(PrintWriter p, int i, int[] ar) {
        int n = this.relations.size();
        p.println(String.valueOf(i) + "\t\t" + n);
        int n2 = n;
        ar[n2] = ar[n2] + 1;
    }

    public void writecalculikLog(PrintWriter p, int i) {
        int r = 0;
        while (r < this.relations.size()) {
            p.println("interpretation(i" + i + ", rel(r" + r + ", w" + this.relations.elementAt((int)r).wh_sp.head_index + ", w" + this.relations.elementAt((int)r).wh_tr.head_index + ", w" + this.relations.elementAt((int)r).wh_lm.head_index + ")).");
            p.println("interpretation(i" + i + ", sprel(r" + r + ")).");
            if (this.relations.elementAt((int)r).calc_type.specific.elementAt(0).toLowerCase().contains("rcc")) {
                p.println("interpretation(i" + i + ", rccsprel(r" + r + ")).");
            }
            ++r;
        }
    }

    public void writekLogIndividualRoles(PrintWriter p, int i) {
        int r = 0;
        while (r < this.relations.size()) {
            p.println("interpretation(i" + i + ",trajector(w" + this.relations.elementAt((int)r).wh_tr.head_index + ")).");
            p.println("interpretation(i" + i + ",landmark(w" + this.relations.elementAt((int)r).wh_lm.head_index + ")).");
            p.println("interpretation(i" + i + ",indicator(w" + this.relations.elementAt((int)r).wh_sp.head_index + ")).");
            ++r;
        }
    }

    public Vector<Integer> gather_rels_of_a_seq(int x, int[] flag) {
        Vector<Integer> rs = new Vector<Integer>();
        int r = 0;
        while (r < this.relations.size()) {
            if (this.relations.elementAt((int)r).wh_sp.head_index == this.relations.elementAt((int)x).wh_sp.head_index) {
                flag[r] = 1;
                rs.addElement(r);
            }
            ++r;
        }
        return rs;
    }

    public String label_of_w(int w, Vector<Integer> rs) {
        String S = null;
        int r = 0;
        while (r < rs.size()) {
            if (this.relations.elementAt((int)rs.elementAt((int)r).intValue()).wh_lm.head_index == w) {
                S = " Landmark";
            }
            if (this.relations.elementAt((int)rs.elementAt((int)r).intValue()).wh_tr.head_index == w) {
                S = " Trajector";
            }
            if (this.relations.elementAt((int)rs.elementAt((int)r).intValue()).wh_sp.head_index == w) {
                S = " Indicator";
            }
            ++r;
        }
        if (S == null) {
            S = " None";
        }
        return S;
    }

    public String is_pivot(int w, int w2) {
        String S = null;
        S = w == w2 ? " pivot" : " none";
        return S;
    }

    public void writePositives_perSp(PrintWriter p, PrintWriter pgrmm, int i, Vector<Integer> rs) {
        int w2 = this.relations.elementAt((int)rs.elementAt((int)0).intValue()).wh_sp.head_index;
        boolean position = true;
        int w = 0;
        while (w < this.sentence_feat.size()) {
            String label = this.label_of_w(w, rs);
            String pivot = this.is_pivot(w, w2);
            if (w < w2) {
                position = false;
            }
            p.println(String.valueOf(this.sentence_feat.elementAt((int)w).words.word) + " " + this.sentence_feat.elementAt((int)w2).words.word + " " + this.sentence_feat.elementAt((int)w2).words.subcategorization + " " + this.sentence_feat.elementAt((int)w).words.pos + " " + this.sentence_feat.elementAt((int)w).words.DPRL + " " + this.sentence_feat.elementAt((int)w).words.SRL + " " + this.sentence_feat.elementAt((int)w).word_word.path.elementAt(w2) + " " + this.sentence_feat.elementAt((int)w).word_word.distance.elementAt(w2) + " " + " wordsubcat_" + this.sentence_feat.elementAt((int)w).words.subcategorization + " " + position + pivot + label);
            pgrmm.println(String.valueOf(label.trim()) + " ---- " + this.sentence_feat.elementAt((int)w).words.word + " Prep=" + this.sentence_feat.elementAt((int)w2).words.word + " Psub=" + this.sentence_feat.elementAt((int)w2).words.subcategorization + " " + this.sentence_feat.elementAt((int)w).words.pos + " " + this.sentence_feat.elementAt((int)w).words.DPRL + " " + this.sentence_feat.elementAt((int)w).words.SRL + " Pat=" + this.sentence_feat.elementAt((int)w).word_word.path.elementAt(w2) + " dis=" + this.sentence_feat.elementAt((int)w).word_word.distance.elementAt(w2) + " " + " wordsubcat_" + this.sentence_feat.elementAt((int)w).words.subcategorization + " pos=" + position + pivot);
            ++w;
        }
    }

    public void writekLogPositives_perSp(PrintWriter kLogSeqs, int i, Vector<Integer> rs) {
        int w2 = this.relations.elementAt((int)rs.elementAt((int)0).intValue()).wh_sp.head_index;
        boolean position = true;
        int w = 0;
        while (w < this.sentence_feat.size()) {
            String label = this.label_of_w(w, rs).toLowerCase();
            String pivot = this.is_pivot(w, w2);
            if (w < w2) {
                position = false;
            }
            kLogSeqs.println("interpretation(i" + i + ", word(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.word) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",pos(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.pos) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",dprl(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.DPRL) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",srl(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.SRL) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",subcat(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.subcategorization) + ")).");
            kLogSeqs.println("interpretation(i" + i + ", word_word_path_ext(w" + w + ", w" + w2 + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).word_word.path.elementAt(w2)) + ")).");
            kLogSeqs.println("interpretation(i" + i + ", word_word_dis_ext(w" + w + ", w" + w2 + "," + this.sentence_feat.elementAt((int)w).word_word.distance.elementAt(w2) + ")).");
            kLogSeqs.println("interpretation(i" + i + ", word_word_befor_ext(w" + w + ", w" + w2 + "," + position + ")).");
            kLogSeqs.println("interpretation(i" + i + ",role(w" + w + "," + label.trim() + ")).");
            ++w;
        }
        kLogSeqs.println("interpretation(i" + i + ",pivot(w" + w2 + "," + this.constant_correction(this.sentence_feat.elementAt((int)w2).words.word) + ")).");
    }

    public void writekLogNegatives_perSp_pivprop(PrintWriter kLogSeqs, int i, int w2) {
        boolean position = true;
        int w = 0;
        while (w < this.sentence_feat.size()) {
            String label = " none";
            String pivot = this.is_pivot(w, w2);
            if (w < w2) {
                position = false;
            }
            kLogSeqs.println("interpretation(i" + i + ", word(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.word) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",pos(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.pos) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",dprl(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.DPRL) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",srl(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.SRL) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",subcat(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.subcategorization) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",pivot(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w2).words.word) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",pivosubcat(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w2).words.subcategorization) + ")).");
            kLogSeqs.println("interpretation(i" + i + ", word_word_path_ext(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).word_word.path.elementAt(w2)) + ")).");
            kLogSeqs.println("interpretation(i" + i + ", word_word_dis_ext(w" + w + "," + this.sentence_feat.elementAt((int)w).word_word.distance.elementAt(w2) + ")).");
            kLogSeqs.println("interpretation(i" + i + ", word_word_befor_ext(w" + w + "," + position + ")).");
            kLogSeqs.println("interpretation(i" + i + ",role(w" + w + "," + "w" + w2 + "," + label.trim() + ")).");
            ++w;
        }
        kLogSeqs.println("interpretation(i" + i + ",pivotEntity(w" + w2 + ")).");
    }

    public void writekLogPositives_perSp_pivprop(PrintWriter kLogSeqs, int i, Vector<Integer> rs) {
        int w2 = this.relations.elementAt((int)rs.elementAt((int)0).intValue()).wh_sp.head_index;
        boolean position = true;
        int w = 0;
        while (w < this.sentence_feat.size()) {
            String label = this.label_of_w(w, rs).toLowerCase();
            String pivot = this.is_pivot(w, w2);
            if (w < w2) {
                position = false;
            }
            kLogSeqs.println("interpretation(i" + i + ", word(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.word) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",pos(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.pos) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",dprl(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.DPRL) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",srl(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.SRL) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",subcat(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.subcategorization) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",pivot(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w2).words.word) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",pivosubcat(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w2).words.subcategorization) + ")).");
            kLogSeqs.println("interpretation(i" + i + ", word_word_path_ext(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).word_word.path.elementAt(w2)) + ")).");
            kLogSeqs.println("interpretation(i" + i + ", word_word_dis_ext(w" + w + "," + this.sentence_feat.elementAt((int)w).word_word.distance.elementAt(w2) + ")).");
            kLogSeqs.println("interpretation(i" + i + ", word_word_befor_ext(w" + w + "," + position + ")).");
            kLogSeqs.println("interpretation(i" + i + ",role(w" + w + ",w" + w2 + "," + label.trim() + ")).");
            ++w;
        }
        kLogSeqs.println("interpretation(i" + i + ",pivotEntity(w" + w2 + ")).");
    }

    public void writekLogNegatives_perSp(PrintWriter kLogSeqs, int i, int w2) {
        boolean position = true;
        int w = 0;
        while (w < this.sentence_feat.size()) {
            String label = " none";
            String pivot = this.is_pivot(w, w2);
            if (w < w2) {
                position = false;
            }
            kLogSeqs.println("interpretation(i" + i + ", word(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.word) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",pos(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.pos) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",dprl(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.DPRL) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",srl(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.SRL) + ")).");
            kLogSeqs.println("interpretation(i" + i + ",subcat(w" + w + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.subcategorization) + ")).");
            kLogSeqs.println("interpretation(i" + i + ", word_word_path_ext(w" + w + ", w" + w2 + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).word_word.path.elementAt(w2)) + ")).");
            kLogSeqs.println("interpretation(i" + i + ", word_word_dis_ext(w" + w + ", w" + w2 + "," + this.sentence_feat.elementAt((int)w).word_word.distance.elementAt(w2) + ")).");
            kLogSeqs.println("interpretation(i" + i + ", word_word_befor_ext(w" + w + ", w" + w2 + "," + position + ")).");
            kLogSeqs.println("interpretation(i" + i + ",role(w" + w + "," + label.trim() + ")).");
            ++w;
        }
        kLogSeqs.println("interpretation(i" + i + ",pivot(w" + w2 + "," + this.constant_correction(this.sentence_feat.elementAt((int)w2).words.word) + ")).");
    }

    public void writeNegatives_perSp(PrintWriter p, PrintWriter pgrmm, int w2) {
        boolean position = true;
        int w = 0;
        while (w < this.sentence_feat.size()) {
            String label = " None";
            String pivot = this.is_pivot(w, w2);
            if (w < w2) {
                position = false;
            }
            p.println(String.valueOf(this.sentence_feat.elementAt((int)w).words.word) + " " + this.sentence_feat.elementAt((int)w2).words.word + " " + this.sentence_feat.elementAt((int)w2).words.subcategorization + " " + this.sentence_feat.elementAt((int)w).words.pos + " " + this.sentence_feat.elementAt((int)w).words.DPRL + " " + this.sentence_feat.elementAt((int)w).words.SRL + " " + this.sentence_feat.elementAt((int)w).word_word.path.elementAt(w2) + " " + this.sentence_feat.elementAt((int)w).word_word.distance.elementAt(w2) + " " + " wordsubcat_" + this.sentence_feat.elementAt((int)w).words.subcategorization + " " + position + pivot + label);
            pgrmm.println(String.valueOf(label.trim()) + " ---- " + this.sentence_feat.elementAt((int)w).words.word + " Prep=" + this.sentence_feat.elementAt((int)w2).words.word + " Psub=" + this.sentence_feat.elementAt((int)w2).words.subcategorization + " " + this.sentence_feat.elementAt((int)w).words.pos + " " + this.sentence_feat.elementAt((int)w).words.DPRL + " " + this.sentence_feat.elementAt((int)w).words.SRL + " Pat=" + this.sentence_feat.elementAt((int)w).word_word.path.elementAt(w2) + " dis=" + this.sentence_feat.elementAt((int)w).word_word.distance.elementAt(w2) + " " + " wordsubcat_" + this.sentence_feat.elementAt((int)w).words.subcategorization + " pos=" + position + pivot);
            ++w;
        }
    }

    public void writeMalletSeq(PrintWriter p, PrintWriter pgrmm, int i) {
        int[] flags = new int[this.relations.size()];
        int r = 0;
        while (r < this.relations.size()) {
            if (flags[r] != 1) {
                Vector<Integer> rs = this.gather_rels_of_a_seq(r, flags);
                this.writePositives_perSp(p, pgrmm, i, rs);
                p.println();
                pgrmm.println();
            }
            ++r;
        }
        r = 0;
        while (r < this.non_SP_tpps.size()) {
            this.writeNegatives_perSp(p, pgrmm, this.non_SP_tpps.elementAt(r));
            p.println();
            pgrmm.println();
            ++r;
        }
    }

    public void writeMalletSeq_modifUndefLm(PrintWriter p, PrintWriter pgrmm, int i) {
        int[] flags = new int[this.relations.size()];
        int r = 0;
        while (r < this.relations.size()) {
            this.replacelm(r);
            if (flags[r] != 1) {
                Vector<Integer> rs = this.gather_rels_of_a_seq(r, flags);
                this.writePositives_perSp(p, pgrmm, i, rs);
                p.println();
                pgrmm.println();
            }
            ++r;
        }
        r = 0;
        while (r < this.non_SP_tpps.size()) {
            this.writeNegatives_perSp(p, pgrmm, this.non_SP_tpps.elementAt(r));
            p.println();
            pgrmm.println();
            ++r;
        }
    }

    public void writekLogSequences(PrintWriter kLogSeqs) {
        int[] flags = new int[this.relations.size()];
        int r = 0;
        while (r < this.relations.size()) {
            this.replacelm(r);
            if (flags[r] != 1) {
                Vector<Integer> rs = this.gather_rels_of_a_seq(r, flags);
                this.writekLogPositives_perSp_pivprop(kLogSeqs, build_Sequences_SbyS.sequence_num, rs);
                kLogSeqs.println();
                ++build_Sequences_SbyS.sequence_num;
            }
            ++r;
        }
        r = 0;
        while (r < this.non_SP_tpps.size()) {
            this.writekLogNegatives_perSp_pivprop(kLogSeqs, build_Sequences_SbyS.sequence_num, this.non_SP_tpps.elementAt(r));
            kLogSeqs.println();
            ++build_Sequences_SbyS.sequence_num;
            ++r;
        }
    }

    public void write_roles_features(PrintWriter p, int i, Vector<String> values) {
        int r = 0;
        while (r < this.relations.size()) {
            if (this.sentence_feat.elementAt((int)this.relations.elementAt((int)r).wh_tr.head_index).words.pos.contains("VB")) {
                p.print(String.valueOf(this.sentence_feat.elementAt((int)this.relations.elementAt((int)r).wh_tr.head_index).words.word) + "*VB*" + i + ":");
            }
            if (this.sentence_feat.elementAt((int)this.relations.elementAt((int)r).wh_tr.head_index).words.pos.contains("PRP")) {
                p.print(String.valueOf(this.sentence_feat.elementAt((int)this.relations.elementAt((int)r).wh_tr.head_index).words.word) + "*PRP*" + i + ":");
            }
            if (this.sentence_feat.elementAt((int)this.relations.elementAt((int)r).wh_tr.head_index).words.pos.contains("CC")) {
                p.print(String.valueOf(this.sentence_feat.elementAt((int)this.relations.elementAt((int)r).wh_tr.head_index).words.word) + "*CC*");
            }
            if (this.sentence_feat.elementAt((int)this.relations.elementAt((int)r).wh_tr.head_index).words.pos.contains("JJ")) {
                p.print("JJ:" + i + ":");
                p.print(String.valueOf(this.sentence_feat.elementAt((int)this.relations.elementAt((int)r).wh_tr.head_index).words.word) + "**");
            }
            if (!values.contains(this.sentence_feat.elementAt((int)this.relations.elementAt((int)r).wh_tr.head_index).words.pos)) {
                values.addElement(this.sentence_feat.elementAt((int)this.relations.elementAt((int)r).wh_tr.head_index).words.pos);
            }
            ++r;
        }
    }

    public void collect_RelarffCandidates(Vector<String> arff, PrintWriter head1) {
        int r = 0;
        while (r < this.allPosRelCandids.size()) {
            int lm_index = this.allPosRelCandids.elementAt((int)r).lm;
            int tr_index = this.allPosRelCandids.elementAt((int)r).tr;
            int sp_index = this.allPosRelCandids.elementAt((int)r).sp;
            if (tr_index == this.sentence_feat.size()) {
                if (!arff.contains("tr_h_undefined")) {
                    arff.addElement("tr_h_undefined");
                }
            } else {
                if (!arff.contains("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word))) {
                    arff.addElement("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word));
                }
                if (!arff.contains("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL))) {
                    arff.addElement("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL));
                }
                if (!arff.contains("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos))) {
                    arff.addElement("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos));
                }
                if (!arff.contains("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL))) {
                    arff.addElement("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL));
                }
                if (!arff.contains("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization))) {
                    arff.addElement("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization));
                }
            }
            if (lm_index == this.sentence_feat.size()) {
                if (!arff.contains("lm_h_undefined")) {
                    arff.addElement("lm_h_undefined");
                }
            } else {
                if (!arff.contains("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word))) {
                    arff.addElement("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word));
                }
                if (!arff.contains("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL))) {
                    arff.addElement("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL));
                }
                if (!arff.contains("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos))) {
                    arff.addElement("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos));
                }
                if (!arff.contains("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL))) {
                    arff.addElement("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL));
                }
                if (!arff.contains("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization))) {
                    arff.addElement("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization));
                }
            }
            if (!arff.contains("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word))) {
                arff.addElement("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word));
            }
            if (!arff.contains("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization))) {
                arff.addElement("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization));
            }
            if (!arff.contains("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos))) {
                arff.addElement("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos));
            }
            if (!arff.contains("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL))) {
                arff.addElement("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL));
            }
            if (!arff.contains("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL))) {
                arff.addElement("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL));
            }
            int distt = -1;
            if (tr_index != this.sentence_feat.size()) {
                distt = this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(tr_index);
            }
            if (!arff.contains("d_sp_tr_" + distt)) {
                arff.addElement("d_sp_tr_" + distt);
            }
            int distl = -1;
            if (lm_index != this.sentence_feat.size()) {
                distl = this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(lm_index);
            }
            if (!arff.contains("d_sp_lm_" + distl)) {
                arff.addElement("d_sp_lm_" + distl);
            }
            int disttl = -1;
            if (distl != -1 & distt != -1) {
                disttl = this.sentence_feat.elementAt((int)tr_index).word_word.distance.elementAt(lm_index);
            }
            if (!arff.contains("d_tr_lm_" + disttl)) {
                arff.addElement("d_tr_lm_" + disttl);
            }
            ++r;
        }
        r = 0;
        while (r < this.allnonrel.size()) {
            int r1 = this.selectedNegatives.elementAt(r);
            int lm_index = this.allnonrel.elementAt((int)r1).lm;
            int tr_index = this.allnonrel.elementAt((int)r1).tr;
            int sp_index = this.allnonrel.elementAt((int)r1).sp;
            if (tr_index == this.sentence_feat.size()) {
                if (!arff.contains("tr_h_undefined")) {
                    arff.addElement("tr_h_undefined");
                }
            } else {
                if (!arff.contains("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word))) {
                    arff.addElement("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word));
                }
                if (!arff.contains("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL))) {
                    arff.addElement("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL));
                }
                if (!arff.contains("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos))) {
                    arff.addElement("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos));
                }
                if (!arff.contains("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL))) {
                    arff.addElement("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL));
                }
                if (!arff.contains("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization))) {
                    arff.addElement("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization));
                }
            }
            if (lm_index == this.sentence_feat.size()) {
                if (!arff.contains("lm_h_undefined")) {
                    arff.addElement("lm_h_undefined");
                }
            } else {
                if (!arff.contains("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word))) {
                    arff.addElement("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word));
                }
                if (!arff.contains("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL))) {
                    arff.addElement("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL));
                }
                if (!arff.contains("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos))) {
                    arff.addElement("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos));
                }
                if (!arff.contains("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL))) {
                    arff.addElement("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL));
                }
                if (!arff.contains("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization))) {
                    arff.addElement("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization));
                }
            }
            if (!arff.contains("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word))) {
                arff.addElement("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word));
            }
            if (!arff.contains("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization))) {
                arff.addElement("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization));
            }
            if (!arff.contains("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos))) {
                arff.addElement("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos));
            }
            if (!arff.contains("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL))) {
                arff.addElement("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL));
            }
            if (!arff.contains("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL))) {
                arff.addElement("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL));
            }
            int distt = -1;
            if (tr_index != this.sentence_feat.size()) {
                distt = this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(tr_index);
            }
            if (!arff.contains("d_sp_tr_" + distt)) {
                arff.addElement("d_sp_tr_" + distt);
            }
            int distl = -1;
            if (lm_index != this.sentence_feat.size()) {
                distl = this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(lm_index);
            }
            if (!arff.contains("d_sp_lm_" + distl)) {
                arff.addElement("d_sp_lm_" + distl);
            }
            int disttl = -1;
            if (distl != -1 & distt != -1) {
                disttl = this.sentence_feat.elementAt((int)tr_index).word_word.distance.elementAt(lm_index);
            }
            if (!arff.contains("d_tr_lm_" + disttl)) {
                arff.addElement("d_tr_lm_" + disttl);
            }
            ++r;
        }
    }

    public void collect_Relarff_att(Vector<String> arff, PrintWriter head1) {
        int sp_index;
        int tr_index;
        int lm_index;
        int r = 0;
        while (r < this.relations.size()) {
            lm_index = this.relations.elementAt((int)r).wh_lm.head_index;
            tr_index = this.relations.elementAt((int)r).wh_tr.head_index;
            sp_index = this.relations.elementAt((int)r).wh_sp.head_index;
            if (tr_index == this.sentence_feat.size()) {
                if (!arff.contains("tr_h_undefined")) {
                    arff.addElement("tr_h_undefined");
                }
            } else {
                if (!arff.contains("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word))) {
                    arff.addElement("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word));
                }
                if (!arff.contains("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL))) {
                    arff.addElement("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL));
                }
                if (!arff.contains("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos))) {
                    arff.addElement("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos));
                }
                if (!arff.contains("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL))) {
                    arff.addElement("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL));
                }
                if (!arff.contains("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization))) {
                    arff.addElement("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization));
                }
            }
            if (lm_index == this.sentence_feat.size()) {
                if (!arff.contains("lm_h_undefined")) {
                    arff.addElement("lm_h_undefined");
                }
            } else {
                if (!arff.contains("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word))) {
                    arff.addElement("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word));
                }
                if (!arff.contains("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL))) {
                    arff.addElement("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL));
                }
                if (!arff.contains("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos))) {
                    arff.addElement("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos));
                }
                if (!arff.contains("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL))) {
                    arff.addElement("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL));
                }
                if (!arff.contains("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization))) {
                    arff.addElement("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization));
                }
            }
            if (!arff.contains("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word))) {
                arff.addElement("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word));
            }
            if (!arff.contains("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization))) {
                arff.addElement("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization));
            }
            if (!arff.contains("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos))) {
                arff.addElement("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos));
            }
            if (!arff.contains("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL))) {
                arff.addElement("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL));
            }
            if (!arff.contains("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL))) {
                arff.addElement("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL));
            }
            int distt = -1;
            if (tr_index != this.sentence_feat.size()) {
                distt = this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(tr_index);
            }
            if (!arff.contains("d_sp_tr_" + distt)) {
                arff.addElement("d_sp_tr_" + distt);
            }
            int distl = -1;
            if (lm_index != this.sentence_feat.size()) {
                distl = this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(lm_index);
            }
            if (!arff.contains("d_sp_lm_" + distl)) {
                arff.addElement("d_sp_lm_" + distl);
            }
            int disttl = -1;
            if (distl != -1 & distt != -1) {
                disttl = this.sentence_feat.elementAt((int)tr_index).word_word.distance.elementAt(lm_index);
            }
            if (!arff.contains("d_tr_lm_" + disttl)) {
                arff.addElement("d_tr_lm_" + disttl);
            }
            ++r;
        }
        r = 0;
        while (r < this.nonrelations.size()) {
            lm_index = this.nonrelations.elementAt((int)r).lm;
            tr_index = this.nonrelations.elementAt((int)r).tr;
            sp_index = this.nonrelations.elementAt((int)r).sp;
            if (!arff.contains("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word))) {
                arff.addElement("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word));
            }
            if (!arff.contains("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL))) {
                arff.addElement("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL));
            }
            if (!arff.contains("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos))) {
                arff.addElement("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos));
            }
            if (!arff.contains("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL))) {
                arff.addElement("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL));
            }
            if (!arff.contains("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization))) {
                arff.addElement("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization));
            }
            if (!arff.contains("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word))) {
                arff.addElement("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word));
            }
            if (!arff.contains("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL))) {
                arff.addElement("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL));
            }
            if (!arff.contains("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos))) {
                arff.addElement("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos));
            }
            if (!arff.contains("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL))) {
                arff.addElement("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL));
            }
            if (!arff.contains("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization))) {
                arff.addElement("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization));
            }
            if (!arff.contains("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word))) {
                arff.addElement("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word));
            }
            if (!arff.contains("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization))) {
                arff.addElement("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization));
            }
            if (!arff.contains("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos))) {
                arff.addElement("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos));
            }
            if (!arff.contains("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL))) {
                arff.addElement("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL));
            }
            if (!arff.contains("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL))) {
                arff.addElement("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL));
            }
            ++r;
        }
    }

    public void collect_arff_att(Vector<String> arff, PrintWriter G_m) {
        int r = 0;
        while (r < this.relations.size()) {
            if (!arff.contains("tr_" + this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph_head))) {
                arff.addElement("tr_" + this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph_head));
            }
            if (!arff.contains("lm_" + this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph_head))) {
                arff.addElement("lm_" + this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph_head));
            }
            if (!arff.contains("sp_" + this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph_head))) {
                arff.addElement("sp_" + this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph_head));
            }
            if (!arff.contains("mo_" + this.constant_correction(this.relations.elementAt((int)r).wh_motion.ph_head))) {
                arff.addElement("mo_" + this.constant_correction(this.relations.elementAt((int)r).wh_motion.ph_head));
            }
            if (!arff.contains("for_" + this.constant_correction(this.relations.elementAt((int)r).FrORe))) {
                arff.addElement("for_" + this.constant_correction(this.relations.elementAt((int)r).FrORe));
            }
            if (!arff.contains("pa_" + this.constant_correction(this.relations.elementAt((int)r).path))) {
                arff.addElement("pa_" + this.constant_correction(this.relations.elementAt((int)r).path));
            }
            if (!arff.contains("dy_" + this.relations.elementAt((int)r).dynamic)) {
                arff.addElement("dy_" + this.relations.elementAt((int)r).dynamic);
            }
            if (!arff.contains("gum_" + this.constant_correction(this.relations.elementAt((int)r).GUM_mod))) {
                arff.addElement("gum_" + this.constant_correction(this.relations.elementAt((int)r).GUM_mod));
            }
            int r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_sp.ph.size()) {
                if (!this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph.elementAt(r1)).equals(this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph_head))) {
                    arff.addElement("sp1_" + this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph.elementAt(r1)));
                }
                ++r1;
            }
            r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_tr.ph.size()) {
                if (!this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph.elementAt(r1)).equals(this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph_head)) && !arff.contains("tr1_" + this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph.elementAt(r1)))) {
                    arff.addElement("tr1_" + this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph.elementAt(r1)));
                }
                ++r1;
            }
            r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_lm.ph.size()) {
                if (!this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph.elementAt(r1)).equals(this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph_head)) && !arff.contains("lm1_" + this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph.elementAt(r1)))) {
                    arff.addElement("lm1_" + this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph.elementAt(r1)));
                }
                ++r1;
            }
            ++r;
        }
    }

    public String hierachyindex(String s) {
        s = s.toLowerCase();
        s = s.replaceAll(" ", "");
        s = s.replaceAll("\"", "");
        String Hind = null;
        boolean flag = false;
        if (s.contains("pp")) {
            s = "pp";
        }
        String[] Rcc5 = new String[]{"pp", "ec", "eq", "dc", "po"};
        int i = 0;
        while (i < Rcc5.length && !flag) {
            if (Rcc5[i].contains(s.toLowerCase())) {
                Hind = "1/1/" + Integer.toString(i + 1);
                flag = true;
            }
            ++i;
        }
        String[] dir_Rvalue = new String[]{"below", "left", "right", "behind", "front", "above"};
        int i2 = 0;
        while (i2 < dir_Rvalue.length && !flag) {
            if (dir_Rvalue[i2].contains(s)) {
                Hind = "1/2/1/" + Integer.toString(i2 + 1);
                flag = true;
            }
            ++i2;
        }
        String[] dir_Avalue = new String[]{"west", "south", "east", "north", "sw", "nw", "se", "ne"};
        int i3 = 0;
        while (i3 < dir_Avalue.length && !flag) {
            if (dir_Avalue[i3].contains(s)) {
                Hind = "1/2/2/" + Integer.toString(i3 + 1);
                flag = true;
            }
            ++i3;
        }
        if (!flag) {
            Hind = "1/3";
        }
        if (Hind == null) {
            System.out.print("Error#404: spatial type is missing!!");
        }
        return Hind;
    }

    public void add_arff_data_LangCalHierarch(Vector<String> atts, PrintWriter p, PrintWriter pN) {
        int t1;
        int sp_index;
        int tr_index;
        int r = 0;
        while (r < this.relations.size()) {
            String TempyHierar = "";
            Vector<Integer> featList = new Vector<Integer>();
            int r_t1 = 0;
            while (r_t1 < 1) {
                if (r_t1 != 0) {
                    TempyHierar = String.valueOf(TempyHierar) + "@";
                }
                TempyHierar = String.valueOf(TempyHierar) + this.hierachyindex(this.relations.elementAt((int)r).calc_type.sp_value.elementAt(r_t1));
                ++r_t1;
            }
            int lm_index = this.relations.elementAt((int)r).wh_lm.head_index;
            int tr_index2 = this.relations.elementAt((int)r).wh_tr.head_index;
            int sp_index2 = this.relations.elementAt((int)r).wh_sp.head_index;
            if (tr_index2 == this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("tr_h_undefined"));
            } else {
                featList.addElement(atts.indexOf("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.word)));
                featList.addElement(atts.indexOf("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.DPRL)));
                featList.addElement(atts.indexOf("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.pos)));
                featList.addElement(atts.indexOf("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.SRL)));
                featList.addElement(atts.indexOf("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.subcategorization)));
            }
            if (lm_index == this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("lm_h_undefined"));
            } else {
                featList.addElement(atts.indexOf("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word)));
                featList.addElement(atts.indexOf("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL)));
                featList.addElement(atts.indexOf("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos)));
                featList.addElement(atts.indexOf("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL)));
                featList.addElement(atts.indexOf("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization)));
            }
            featList.addElement(atts.indexOf("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.word)));
            featList.addElement(atts.indexOf("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.DPRL)));
            featList.addElement(atts.indexOf("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.pos)));
            featList.addElement(atts.indexOf("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.SRL)));
            featList.addElement(atts.indexOf("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.subcategorization)));
            Collections.sort(featList);
            p.print("{");
            int t12 = 0;
            while (t12 < featList.size()) {
                if ((Integer)featList.elementAt(t12) != -1) {
                    p.print(String.valueOf((Integer)featList.elementAt(t12) + 1) + " 1,");
                }
                ++t12;
            }
            p.println("2907 " + TempyHierar + "}");
            ++r;
        }
        r = 0;
        while (r < Math.min(this.nonrelations.size(), this.relations.size() + 1)) {
            Vector<Integer> featList = new Vector<Integer>();
            int lm_index = this.nonrelations.elementAt((int)r).lm;
            tr_index = this.nonrelations.elementAt((int)r).tr;
            sp_index = this.nonrelations.elementAt((int)r).sp;
            featList.addElement(atts.indexOf("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word)));
            featList.addElement(atts.indexOf("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL)));
            featList.addElement(atts.indexOf("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos)));
            featList.addElement(atts.indexOf("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL)));
            featList.addElement(atts.indexOf("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization)));
            featList.addElement(atts.indexOf("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word)));
            featList.addElement(atts.indexOf("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL)));
            featList.addElement(atts.indexOf("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos)));
            featList.addElement(atts.indexOf("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL)));
            featList.addElement(atts.indexOf("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization)));
            featList.addElement(atts.indexOf("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word)));
            featList.addElement(atts.indexOf("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL)));
            featList.addElement(atts.indexOf("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos)));
            featList.addElement(atts.indexOf("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL)));
            featList.addElement(atts.indexOf("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization)));
            featList.addElement(atts.indexOf("d_sp_tr_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(tr_index)));
            featList.addElement(atts.indexOf("d_sp_lm_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(lm_index)));
            featList.addElement(atts.indexOf("d_tr_lm_" + this.sentence_feat.elementAt((int)tr_index).word_word.distance.elementAt(lm_index)));
            Collections.sort(featList);
            p.print("{");
            t1 = 0;
            while (t1 < featList.size()) {
                if ((Integer)featList.elementAt(t1) != -1) {
                    p.print(String.valueOf((Integer)featList.elementAt(t1) + 1) + " 1,");
                }
                ++t1;
            }
            p.println("2907 2}");
            ++r;
        }
        r = Math.min(this.nonrelations.size(), this.relations.size() + 1);
        while (r < this.nonrelations.size()) {
            Vector<Integer> featListNeg = new Vector<Integer>();
            int lm_index = this.nonrelations.elementAt((int)r).lm;
            tr_index = this.nonrelations.elementAt((int)r).tr;
            sp_index = this.nonrelations.elementAt((int)r).sp;
            featListNeg.addElement(atts.indexOf("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word)));
            featListNeg.addElement(atts.indexOf("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL)));
            featListNeg.addElement(atts.indexOf("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos)));
            featListNeg.addElement(atts.indexOf("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL)));
            featListNeg.addElement(atts.indexOf("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization)));
            featListNeg.addElement(atts.indexOf("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word)));
            featListNeg.addElement(atts.indexOf("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL)));
            featListNeg.addElement(atts.indexOf("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos)));
            featListNeg.addElement(atts.indexOf("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL)));
            featListNeg.addElement(atts.indexOf("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization)));
            featListNeg.addElement(atts.indexOf("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word)));
            featListNeg.addElement(atts.indexOf("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL)));
            featListNeg.addElement(atts.indexOf("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos)));
            featListNeg.addElement(atts.indexOf("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL)));
            featListNeg.addElement(atts.indexOf("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization)));
            featListNeg.addElement(atts.indexOf("d_sp_tr_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(tr_index)));
            featListNeg.addElement(atts.indexOf("d_sp_lm_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(lm_index)));
            featListNeg.addElement(atts.indexOf("d_tr_lm_" + this.sentence_feat.elementAt((int)tr_index).word_word.distance.elementAt(lm_index)));
            Collections.sort(featListNeg);
            pN.print("{");
            t1 = 0;
            while (t1 < featListNeg.size()) {
                if ((Integer)featListNeg.elementAt(t1) != -1) {
                    pN.print(String.valueOf((Integer)featListNeg.elementAt(t1) + 1) + " 1,");
                }
                ++t1;
            }
            pN.println("2907 2}");
            ++r;
        }
    }

    public void add_arff_data_LangCal(Vector<String> atts, PrintWriter p, PrintWriter pN) {
        int t1;
        int sp_index;
        int tr_index;
        Vector<Integer> featList;
        String labels = "TTP EC EQ DC TPPI PO NTPP NTPPI";
        int r = 0;
        while (r < this.relations.size()) {
            featList = new Vector<Integer>();
            String temty = this.relations.elementAt((int)r).calc_type.sp_value.elementAt(0).replaceAll("\"", "").trim().toUpperCase();
            if (!labels.contains(temty)) {
                temty = "NONE";
            }
            if (temty.contains("TPP")) {
                temty = "PP";
            }
            int lm_index = this.relations.elementAt((int)r).wh_lm.head_index;
            int tr_index2 = this.relations.elementAt((int)r).wh_tr.head_index;
            int sp_index2 = this.relations.elementAt((int)r).wh_sp.head_index;
            if (tr_index2 == this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("tr_h_undefined"));
            } else {
                featList.addElement(atts.indexOf("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.word)));
                featList.addElement(atts.indexOf("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.DPRL)));
                featList.addElement(atts.indexOf("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.pos)));
                featList.addElement(atts.indexOf("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.SRL)));
                featList.addElement(atts.indexOf("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.subcategorization)));
            }
            if (lm_index == this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("lm_h_undefined"));
            } else {
                featList.addElement(atts.indexOf("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word)));
                featList.addElement(atts.indexOf("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL)));
                featList.addElement(atts.indexOf("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos)));
                featList.addElement(atts.indexOf("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL)));
                featList.addElement(atts.indexOf("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization)));
            }
            featList.addElement(atts.indexOf("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.word)));
            featList.addElement(atts.indexOf("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.DPRL)));
            featList.addElement(atts.indexOf("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.pos)));
            featList.addElement(atts.indexOf("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.SRL)));
            featList.addElement(atts.indexOf("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.subcategorization)));
            Collections.sort(featList);
            p.print("{");
            int t12 = 0;
            while (t12 < featList.size()) {
                if ((Integer)featList.elementAt(t12) != -1) {
                    p.print(featList.elementAt(t12) + " 1,");
                }
                ++t12;
            }
            p.println("2802 " + temty + "}");
            ++r;
        }
        r = 0;
        while (r < Math.min(this.nonrelations.size(), this.relations.size() + 1)) {
            featList = new Vector();
            int lm_index = this.nonrelations.elementAt((int)r).lm;
            tr_index = this.nonrelations.elementAt((int)r).tr;
            sp_index = this.nonrelations.elementAt((int)r).sp;
            featList.addElement(atts.indexOf("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word)));
            featList.addElement(atts.indexOf("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL)));
            featList.addElement(atts.indexOf("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos)));
            featList.addElement(atts.indexOf("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL)));
            featList.addElement(atts.indexOf("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization)));
            featList.addElement(atts.indexOf("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word)));
            featList.addElement(atts.indexOf("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL)));
            featList.addElement(atts.indexOf("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos)));
            featList.addElement(atts.indexOf("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL)));
            featList.addElement(atts.indexOf("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization)));
            featList.addElement(atts.indexOf("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word)));
            featList.addElement(atts.indexOf("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL)));
            featList.addElement(atts.indexOf("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos)));
            featList.addElement(atts.indexOf("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL)));
            featList.addElement(atts.indexOf("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization)));
            featList.addElement(atts.indexOf("d_sp_tr_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(tr_index)));
            featList.addElement(atts.indexOf("d_sp_lm_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(lm_index)));
            featList.addElement(atts.indexOf("d_tr_lm_" + this.sentence_feat.elementAt((int)tr_index).word_word.distance.elementAt(lm_index)));
            Collections.sort(featList);
            p.print("{");
            t1 = 0;
            while (t1 < featList.size()) {
                if ((Integer)featList.elementAt(t1) != -1) {
                    p.print(featList.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            p.println("2802 NONE}");
            ++r;
        }
        r = Math.min(this.nonrelations.size(), this.relations.size() + 1);
        while (r < this.nonrelations.size()) {
            Vector<Integer> featListNeg = new Vector<Integer>();
            int lm_index = this.nonrelations.elementAt((int)r).lm;
            tr_index = this.nonrelations.elementAt((int)r).tr;
            sp_index = this.nonrelations.elementAt((int)r).sp;
            featListNeg.addElement(atts.indexOf("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word)));
            featListNeg.addElement(atts.indexOf("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL)));
            featListNeg.addElement(atts.indexOf("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos)));
            featListNeg.addElement(atts.indexOf("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL)));
            featListNeg.addElement(atts.indexOf("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization)));
            featListNeg.addElement(atts.indexOf("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word)));
            featListNeg.addElement(atts.indexOf("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL)));
            featListNeg.addElement(atts.indexOf("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos)));
            featListNeg.addElement(atts.indexOf("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL)));
            featListNeg.addElement(atts.indexOf("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization)));
            featListNeg.addElement(atts.indexOf("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word)));
            featListNeg.addElement(atts.indexOf("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL)));
            featListNeg.addElement(atts.indexOf("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos)));
            featListNeg.addElement(atts.indexOf("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL)));
            featListNeg.addElement(atts.indexOf("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization)));
            featListNeg.addElement(atts.indexOf("d_sp_tr_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(tr_index)));
            featListNeg.addElement(atts.indexOf("d_sp_lm_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(lm_index)));
            featListNeg.addElement(atts.indexOf("d_tr_lm_" + this.sentence_feat.elementAt((int)tr_index).word_word.distance.elementAt(lm_index)));
            Collections.sort(featListNeg);
            pN.print("{");
            t1 = 0;
            while (t1 < featListNeg.size()) {
                if ((Integer)featListNeg.elementAt(t1) != -1) {
                    pN.print(featListNeg.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            pN.println("2802 NONE}");
            ++r;
        }
    }

    public void writeSVMontology(PrintWriter p) {
        int r = 0;
        while (r < this.relations.size()) {
            int i = 0;
            i = 0;
            while (i < this.relations.elementAt((int)r).calc_type.flat_output.length - 1) {
                p.print(String.valueOf(this.relations.elementAt((int)r).calc_type.flat_output[i]) + ",");
                ++i;
            }
            p.println(this.relations.elementAt((int)r).calc_type.flat_output[i]);
            ++r;
        }
    }

    public void add_arff_data_LangMULTIcal(Vector<String> atts, PrintWriter p, PrintWriter pN) {
        int t1;
        int sp_index;
        int tr_index;
        Vector<Integer> featList;
        String labels = "ttp ec eq dc tppi po ntpp ntppi below left right behind front above west south east north sw nw se ne";
        int r = 0;
        while (r < this.relations.size()) {
            featList = new Vector<Integer>();
            String temty = this.relations.elementAt((int)r).calc_type.sp_value.elementAt(0).replaceAll("\"", "").trim().toLowerCase();
            if (!labels.contains(temty)) {
                temty = "dis";
            }
            if (temty.contains("tpp")) {
                temty = "pp";
            }
            int lm_index = this.relations.elementAt((int)r).wh_lm.head_index;
            int tr_index2 = this.relations.elementAt((int)r).wh_tr.head_index;
            int sp_index2 = this.relations.elementAt((int)r).wh_sp.head_index;
            if (tr_index2 == this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("tr_h_undefined"));
            } else {
                featList.addElement(atts.indexOf("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.word)));
                featList.addElement(atts.indexOf("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.DPRL)));
                featList.addElement(atts.indexOf("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.pos)));
                featList.addElement(atts.indexOf("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.SRL)));
                featList.addElement(atts.indexOf("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.subcategorization)));
            }
            if (lm_index == this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("lm_h_undefined"));
            } else {
                featList.addElement(atts.indexOf("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word)));
                featList.addElement(atts.indexOf("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL)));
                featList.addElement(atts.indexOf("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos)));
                featList.addElement(atts.indexOf("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL)));
                featList.addElement(atts.indexOf("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization)));
            }
            featList.addElement(atts.indexOf("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.word)));
            featList.addElement(atts.indexOf("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.DPRL)));
            featList.addElement(atts.indexOf("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.pos)));
            featList.addElement(atts.indexOf("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.SRL)));
            featList.addElement(atts.indexOf("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.subcategorization)));
            Collections.sort(featList);
            p.print("{");
            int t12 = 0;
            while (t12 < featList.size()) {
                if ((Integer)featList.elementAt(t12) != -1) {
                    p.print(featList.elementAt(t12) + " 1,");
                }
                ++t12;
            }
            p.println("2906 " + temty + "}");
            ++r;
        }
        r = 0;
        while (r < Math.min(this.nonrelations.size(), this.relations.size() + 1)) {
            featList = new Vector();
            int lm_index = this.nonrelations.elementAt((int)r).lm;
            tr_index = this.nonrelations.elementAt((int)r).tr;
            sp_index = this.nonrelations.elementAt((int)r).sp;
            featList.addElement(atts.indexOf("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word)));
            featList.addElement(atts.indexOf("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL)));
            featList.addElement(atts.indexOf("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos)));
            featList.addElement(atts.indexOf("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL)));
            featList.addElement(atts.indexOf("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization)));
            featList.addElement(atts.indexOf("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word)));
            featList.addElement(atts.indexOf("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL)));
            featList.addElement(atts.indexOf("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos)));
            featList.addElement(atts.indexOf("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL)));
            featList.addElement(atts.indexOf("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization)));
            featList.addElement(atts.indexOf("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word)));
            featList.addElement(atts.indexOf("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL)));
            featList.addElement(atts.indexOf("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos)));
            featList.addElement(atts.indexOf("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL)));
            featList.addElement(atts.indexOf("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization)));
            featList.addElement(atts.indexOf("d_sp_tr_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(tr_index)));
            featList.addElement(atts.indexOf("d_sp_lm_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(lm_index)));
            featList.addElement(atts.indexOf("d_tr_lm_" + this.sentence_feat.elementAt((int)tr_index).word_word.distance.elementAt(lm_index)));
            Collections.sort(featList);
            p.print("{");
            t1 = 0;
            while (t1 < featList.size()) {
                if ((Integer)featList.elementAt(t1) != -1) {
                    p.print(featList.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            p.println("2906 NONE}");
            ++r;
        }
        r = Math.min(this.nonrelations.size(), this.relations.size() + 1);
        while (r < this.nonrelations.size()) {
            Vector<Integer> featListNeg = new Vector<Integer>();
            int lm_index = this.nonrelations.elementAt((int)r).lm;
            tr_index = this.nonrelations.elementAt((int)r).tr;
            sp_index = this.nonrelations.elementAt((int)r).sp;
            featListNeg.addElement(atts.indexOf("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word)));
            featListNeg.addElement(atts.indexOf("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL)));
            featListNeg.addElement(atts.indexOf("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos)));
            featListNeg.addElement(atts.indexOf("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL)));
            featListNeg.addElement(atts.indexOf("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization)));
            featListNeg.addElement(atts.indexOf("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word)));
            featListNeg.addElement(atts.indexOf("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL)));
            featListNeg.addElement(atts.indexOf("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos)));
            featListNeg.addElement(atts.indexOf("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL)));
            featListNeg.addElement(atts.indexOf("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization)));
            featListNeg.addElement(atts.indexOf("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word)));
            featListNeg.addElement(atts.indexOf("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL)));
            featListNeg.addElement(atts.indexOf("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos)));
            featListNeg.addElement(atts.indexOf("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL)));
            featListNeg.addElement(atts.indexOf("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization)));
            featListNeg.addElement(atts.indexOf("d_sp_tr_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(tr_index)));
            featListNeg.addElement(atts.indexOf("d_sp_lm_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(lm_index)));
            featListNeg.addElement(atts.indexOf("d_tr_lm_" + this.sentence_feat.elementAt((int)tr_index).word_word.distance.elementAt(lm_index)));
            Collections.sort(featListNeg);
            pN.print("{");
            t1 = 0;
            while (t1 < featListNeg.size()) {
                if ((Integer)featListNeg.elementAt(t1) != -1) {
                    pN.print(featListNeg.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            pN.println("2906 NONE}");
            ++r;
        }
    }

    public void add_arff_data(Vector<String> atts, PrintWriter p) {
        String labels = "TTP EC EQ DC TPPI PO NTPP NTPPI";
        int r = 0;
        while (r < this.relations.size()) {
            Vector<Integer> featList = new Vector<Integer>();
            String temty = this.relations.elementAt((int)r).calc_type.sp_value.elementAt(0).replaceAll("\"", "").trim().toUpperCase();
            if (!labels.contains(temty)) {
                temty = "NONE";
            }
            featList.addElement(atts.indexOf("tr_" + this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph_head)));
            int r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_tr.ph.size()) {
                if (!this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph.elementAt(r1)).equals(this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph_head))) {
                    featList.addElement(atts.indexOf("tr1_" + this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph.elementAt(r1))));
                }
                ++r1;
            }
            featList.addElement(atts.indexOf("lm_" + this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph_head)));
            r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_lm.ph.size()) {
                if (!this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph.elementAt(r1)).equals(this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph_head))) {
                    featList.addElement(atts.indexOf("lm1_" + this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph.elementAt(r1))));
                }
                ++r1;
            }
            featList.addElement(atts.indexOf("sp_" + this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph_head)));
            r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_sp.ph.size()) {
                if (!this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph.elementAt(r1)).equals(this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph_head))) {
                    featList.addElement(atts.indexOf("sp1_" + this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph.elementAt(r1))));
                }
                ++r1;
            }
            featList.addElement(atts.indexOf("mo_" + this.constant_correction(this.relations.elementAt((int)r).wh_motion.ph_head)));
            featList.addElement(atts.indexOf("for_" + this.constant_correction(this.relations.elementAt((int)r).FrORe)));
            featList.addElement(atts.indexOf("pa_" + this.constant_correction(this.relations.elementAt((int)r).path)));
            featList.addElement(atts.indexOf("dy_" + this.relations.elementAt((int)r).dynamic));
            featList.addElement(atts.indexOf("gum_" + this.constant_correction(this.relations.elementAt((int)r).GUM_mod)));
            Collections.sort(featList);
            p.print("{");
            int t1 = 0;
            while (t1 < featList.size()) {
                if ((Integer)featList.elementAt(t1) != -1) {
                    p.print(featList.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            p.println("1098 " + temty + "}");
            ++r;
        }
    }

    public void add_arff_ReldataCandidates(Vector<String> atts, PrintWriter p, PrintWriter pN) {
        int t1;
        int sp_index;
        int tr_index;
        int lm_index;
        int r = 0;
        while (r < this.allPosRelCandids.size()) {
            Vector<Integer> featList = new Vector<Integer>();
            int lm_index2 = this.allPosRelCandids.elementAt((int)r).lm;
            int tr_index2 = this.allPosRelCandids.elementAt((int)r).tr;
            int sp_index2 = this.allPosRelCandids.elementAt((int)r).sp;
            if (tr_index2 == this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("tr_h_undefined"));
            } else {
                featList.addElement(atts.indexOf("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.word)));
                featList.addElement(atts.indexOf("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.DPRL)));
                featList.addElement(atts.indexOf("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.pos)));
                featList.addElement(atts.indexOf("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.SRL)));
                featList.addElement(atts.indexOf("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index2).words.subcategorization)));
            }
            if (lm_index2 == this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("lm_h_undefined"));
            } else {
                featList.addElement(atts.indexOf("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index2).words.word)));
                featList.addElement(atts.indexOf("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index2).words.DPRL)));
                featList.addElement(atts.indexOf("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index2).words.pos)));
                featList.addElement(atts.indexOf("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index2).words.SRL)));
                featList.addElement(atts.indexOf("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index2).words.subcategorization)));
            }
            featList.addElement(atts.indexOf("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.word)));
            featList.addElement(atts.indexOf("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.DPRL)));
            featList.addElement(atts.indexOf("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.pos)));
            featList.addElement(atts.indexOf("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.SRL)));
            featList.addElement(atts.indexOf("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index2).words.subcategorization)));
            if (tr_index2 != this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("d_sp_tr_" + this.sentence_feat.elementAt((int)sp_index2).word_word.distance.elementAt(tr_index2)));
            }
            if (lm_index2 != this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("d_sp_lm_" + this.sentence_feat.elementAt((int)sp_index2).word_word.distance.elementAt(lm_index2)));
            }
            if (tr_index2 != this.sentence_feat.size() & lm_index2 != this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("d_tr_lm_" + this.sentence_feat.elementAt((int)tr_index2).word_word.distance.elementAt(lm_index2)));
            }
            Collections.sort(featList);
            p.print("{");
            int t12 = 0;
            while (t12 < featList.size()) {
                if ((Integer)featList.elementAt(t12) != -1) {
                    p.print(featList.elementAt(t12) + " 1,");
                }
                ++t12;
            }
            p.println("212 SR}");
            ++r;
        }
        int neg = 0;
        int r2 = 0;
        while (r2 < this.allnonrel.size()) {
            Vector<Integer> featList = new Vector<Integer>();
            int r1 = this.selectedNegatives.elementAt(r2);
            lm_index = this.allnonrel.elementAt((int)r1).lm;
            tr_index = this.allnonrel.elementAt((int)r1).tr;
            sp_index = this.allnonrel.elementAt((int)r1).sp;
            if (tr_index == this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("tr_h_undefined"));
            } else {
                featList.addElement(atts.indexOf("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word)));
                featList.addElement(atts.indexOf("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL)));
                featList.addElement(atts.indexOf("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos)));
                featList.addElement(atts.indexOf("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL)));
                featList.addElement(atts.indexOf("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization)));
            }
            if (lm_index == this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("lm_h_undefined"));
            } else {
                featList.addElement(atts.indexOf("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word)));
                featList.addElement(atts.indexOf("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL)));
                featList.addElement(atts.indexOf("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos)));
                featList.addElement(atts.indexOf("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL)));
                featList.addElement(atts.indexOf("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization)));
            }
            featList.addElement(atts.indexOf("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word)));
            featList.addElement(atts.indexOf("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL)));
            featList.addElement(atts.indexOf("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos)));
            featList.addElement(atts.indexOf("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL)));
            featList.addElement(atts.indexOf("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization)));
            if (tr_index != this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("d_sp_tr_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(tr_index)));
            }
            if (lm_index != this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("d_sp_lm_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(lm_index)));
            }
            if (tr_index != this.sentence_feat.size() & lm_index != this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("d_tr_lm_" + this.sentence_feat.elementAt((int)tr_index).word_word.distance.elementAt(lm_index)));
            }
            Collections.sort(featList);
            p.print("{");
            t1 = 0;
            while (t1 < featList.size()) {
                if ((Integer)featList.elementAt(t1) != -1) {
                    p.print(featList.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            p.println("212 NSR}");
            neg = r2++;
        }
        r2 = neg + 1;
        while (r2 < this.allnonrel.size()) {
            int r1 = this.selectedNegatives.elementAt(r2);
            Vector<Integer> featList = new Vector<Integer>();
            lm_index = this.allnonrel.elementAt((int)r1).lm;
            tr_index = this.allnonrel.elementAt((int)r1).tr;
            sp_index = this.allnonrel.elementAt((int)r1).sp;
            if (tr_index == this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("tr_h_undefined"));
            } else {
                featList.addElement(atts.indexOf("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word)));
                featList.addElement(atts.indexOf("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL)));
                featList.addElement(atts.indexOf("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos)));
                featList.addElement(atts.indexOf("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL)));
                featList.addElement(atts.indexOf("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization)));
            }
            if (lm_index == this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("lm_h_undefined"));
            } else {
                featList.addElement(atts.indexOf("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word)));
                featList.addElement(atts.indexOf("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL)));
                featList.addElement(atts.indexOf("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos)));
                featList.addElement(atts.indexOf("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL)));
                featList.addElement(atts.indexOf("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization)));
            }
            featList.addElement(atts.indexOf("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word)));
            featList.addElement(atts.indexOf("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL)));
            featList.addElement(atts.indexOf("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos)));
            featList.addElement(atts.indexOf("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL)));
            featList.addElement(atts.indexOf("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization)));
            if (tr_index != this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("d_sp_tr_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(tr_index)));
            }
            if (lm_index != this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("d_sp_lm_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(lm_index)));
            }
            if (tr_index != this.sentence_feat.size() & lm_index != this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("d_tr_lm_" + this.sentence_feat.elementAt((int)tr_index).word_word.distance.elementAt(lm_index)));
            }
            Collections.sort(featList);
            pN.print("{");
            t1 = 0;
            while (t1 < featList.size()) {
                if ((Integer)featList.elementAt(t1) != -1) {
                    pN.print(featList.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            pN.println("2817 NSR}");
            ++r2;
        }
    }

    public void add_arff_Reldata(Vector<String> atts, PrintWriter p, PrintWriter pN) {
        int t1;
        int sp_index;
        int tr_index;
        int lm_index;
        Vector<Integer> featList;
        int r = 0;
        while (r < this.relations.size()) {
            featList = new Vector<Integer>();
            lm_index = this.relations.elementAt((int)r).wh_lm.head_index;
            tr_index = this.relations.elementAt((int)r).wh_tr.head_index;
            sp_index = this.relations.elementAt((int)r).wh_sp.head_index;
            if (tr_index == this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("tr_h_undefined"));
            } else {
                featList.addElement(atts.indexOf("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word)));
                featList.addElement(atts.indexOf("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL)));
                featList.addElement(atts.indexOf("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos)));
                featList.addElement(atts.indexOf("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL)));
                featList.addElement(atts.indexOf("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization)));
            }
            if (lm_index == this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("lm_h_undefined"));
            } else {
                featList.addElement(atts.indexOf("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word)));
                featList.addElement(atts.indexOf("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL)));
                featList.addElement(atts.indexOf("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos)));
                featList.addElement(atts.indexOf("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL)));
                featList.addElement(atts.indexOf("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization)));
            }
            featList.addElement(atts.indexOf("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word)));
            featList.addElement(atts.indexOf("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL)));
            featList.addElement(atts.indexOf("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos)));
            featList.addElement(atts.indexOf("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL)));
            featList.addElement(atts.indexOf("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization)));
            Collections.sort(featList);
            p.print("{");
            t1 = 0;
            while (t1 < featList.size()) {
                if ((Integer)featList.elementAt(t1) != -1) {
                    p.print(featList.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            p.println("2802 SR}");
            ++r;
        }
        r = 0;
        while (r < Math.min(this.nonrelations.size(), this.relations.size() + 1)) {
            featList = new Vector();
            lm_index = this.nonrelations.elementAt((int)r).lm;
            tr_index = this.nonrelations.elementAt((int)r).tr;
            sp_index = this.nonrelations.elementAt((int)r).sp;
            featList.addElement(atts.indexOf("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word)));
            featList.addElement(atts.indexOf("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL)));
            featList.addElement(atts.indexOf("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos)));
            featList.addElement(atts.indexOf("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL)));
            featList.addElement(atts.indexOf("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization)));
            featList.addElement(atts.indexOf("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word)));
            featList.addElement(atts.indexOf("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL)));
            featList.addElement(atts.indexOf("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos)));
            featList.addElement(atts.indexOf("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL)));
            featList.addElement(atts.indexOf("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization)));
            featList.addElement(atts.indexOf("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word)));
            featList.addElement(atts.indexOf("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL)));
            featList.addElement(atts.indexOf("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos)));
            featList.addElement(atts.indexOf("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL)));
            featList.addElement(atts.indexOf("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization)));
            featList.addElement(atts.indexOf("d_sp_tr_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(tr_index)));
            featList.addElement(atts.indexOf("d_sp_lm_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(lm_index)));
            featList.addElement(atts.indexOf("d_tr_lm_" + this.sentence_feat.elementAt((int)tr_index).word_word.distance.elementAt(lm_index)));
            Collections.sort(featList);
            p.print("{");
            t1 = 0;
            while (t1 < featList.size()) {
                if ((Integer)featList.elementAt(t1) != -1) {
                    p.print(featList.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            p.println("2802 NSR}");
            ++r;
        }
        r = Math.min(this.nonrelations.size(), this.relations.size() + 1);
        while (r < this.nonrelations.size()) {
            Vector<Integer> featListNeg = new Vector<Integer>();
            lm_index = this.nonrelations.elementAt((int)r).lm;
            tr_index = this.nonrelations.elementAt((int)r).tr;
            sp_index = this.nonrelations.elementAt((int)r).sp;
            featListNeg.addElement(atts.indexOf("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word)));
            featListNeg.addElement(atts.indexOf("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL)));
            featListNeg.addElement(atts.indexOf("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos)));
            featListNeg.addElement(atts.indexOf("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL)));
            featListNeg.addElement(atts.indexOf("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization)));
            featListNeg.addElement(atts.indexOf("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word)));
            featListNeg.addElement(atts.indexOf("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL)));
            featListNeg.addElement(atts.indexOf("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos)));
            featListNeg.addElement(atts.indexOf("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL)));
            featListNeg.addElement(atts.indexOf("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization)));
            featListNeg.addElement(atts.indexOf("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word)));
            featListNeg.addElement(atts.indexOf("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL)));
            featListNeg.addElement(atts.indexOf("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos)));
            featListNeg.addElement(atts.indexOf("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL)));
            featListNeg.addElement(atts.indexOf("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization)));
            featListNeg.addElement(atts.indexOf("d_sp_tr_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(tr_index)));
            featListNeg.addElement(atts.indexOf("d_sp_lm_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(lm_index)));
            featListNeg.addElement(atts.indexOf("d_tr_lm_" + this.sentence_feat.elementAt((int)tr_index).word_word.distance.elementAt(lm_index)));
            Collections.sort(featListNeg);
            pN.print("{");
            t1 = 0;
            while (t1 < featListNeg.size()) {
                if ((Integer)featListNeg.elementAt(t1) != -1) {
                    pN.print(featListNeg.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            pN.println("2802 NSR}");
            ++r;
        }
    }

    public void addAllCandid_arff_Reldata(Vector<String> atts, PrintWriter p, PrintWriter pN) {
        int t1;
        int sp_index;
        int tr_index;
        int lm_index;
        Vector<Integer> featList;
        int r = 0;
        while (r < this.relations.size()) {
            featList = new Vector<Integer>();
            lm_index = this.relations.elementAt((int)r).wh_lm.head_index;
            tr_index = this.relations.elementAt((int)r).wh_tr.head_index;
            sp_index = this.relations.elementAt((int)r).wh_sp.head_index;
            if (tr_index == this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("tr_h_undefined"));
            } else {
                featList.addElement(atts.indexOf("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word)));
                featList.addElement(atts.indexOf("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL)));
                featList.addElement(atts.indexOf("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos)));
                featList.addElement(atts.indexOf("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL)));
                featList.addElement(atts.indexOf("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization)));
            }
            if (lm_index == this.sentence_feat.size()) {
                featList.addElement(atts.indexOf("lm_h_undefined"));
            } else {
                featList.addElement(atts.indexOf("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word)));
                featList.addElement(atts.indexOf("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL)));
                featList.addElement(atts.indexOf("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos)));
                featList.addElement(atts.indexOf("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL)));
                featList.addElement(atts.indexOf("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization)));
            }
            featList.addElement(atts.indexOf("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word)));
            featList.addElement(atts.indexOf("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL)));
            featList.addElement(atts.indexOf("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos)));
            featList.addElement(atts.indexOf("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL)));
            featList.addElement(atts.indexOf("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization)));
            Collections.sort(featList);
            p.print("{");
            t1 = 0;
            while (t1 < featList.size()) {
                if ((Integer)featList.elementAt(t1) != -1) {
                    p.print(featList.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            p.println("2802 SR}");
            ++r;
        }
        r = 0;
        while (r < Math.min(this.nonrelations.size(), this.relations.size() + 1)) {
            featList = new Vector();
            lm_index = this.nonrelations.elementAt((int)r).lm;
            tr_index = this.nonrelations.elementAt((int)r).tr;
            sp_index = this.nonrelations.elementAt((int)r).sp;
            featList.addElement(atts.indexOf("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word)));
            featList.addElement(atts.indexOf("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL)));
            featList.addElement(atts.indexOf("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos)));
            featList.addElement(atts.indexOf("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL)));
            featList.addElement(atts.indexOf("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization)));
            featList.addElement(atts.indexOf("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word)));
            featList.addElement(atts.indexOf("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL)));
            featList.addElement(atts.indexOf("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos)));
            featList.addElement(atts.indexOf("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL)));
            featList.addElement(atts.indexOf("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization)));
            featList.addElement(atts.indexOf("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word)));
            featList.addElement(atts.indexOf("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL)));
            featList.addElement(atts.indexOf("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos)));
            featList.addElement(atts.indexOf("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL)));
            featList.addElement(atts.indexOf("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization)));
            featList.addElement(atts.indexOf("d_sp_tr_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(tr_index)));
            featList.addElement(atts.indexOf("d_sp_lm_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(lm_index)));
            featList.addElement(atts.indexOf("d_tr_lm_" + this.sentence_feat.elementAt((int)tr_index).word_word.distance.elementAt(lm_index)));
            Collections.sort(featList);
            p.print("{");
            t1 = 0;
            while (t1 < featList.size()) {
                if ((Integer)featList.elementAt(t1) != -1) {
                    p.print(featList.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            p.println("2802 NSR}");
            ++r;
        }
        r = Math.min(this.nonrelations.size(), this.relations.size() + 1);
        while (r < this.nonrelations.size()) {
            Vector<Integer> featListNeg = new Vector<Integer>();
            lm_index = this.nonrelations.elementAt((int)r).lm;
            tr_index = this.nonrelations.elementAt((int)r).tr;
            sp_index = this.nonrelations.elementAt((int)r).sp;
            featListNeg.addElement(atts.indexOf("tr_h_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.word)));
            featListNeg.addElement(atts.indexOf("tr_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.DPRL)));
            featListNeg.addElement(atts.indexOf("tr_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.pos)));
            featListNeg.addElement(atts.indexOf("tr_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.SRL)));
            featListNeg.addElement(atts.indexOf("tr_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)tr_index).words.subcategorization)));
            featListNeg.addElement(atts.indexOf("lm_h_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.word)));
            featListNeg.addElement(atts.indexOf("lm_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.DPRL)));
            featListNeg.addElement(atts.indexOf("lm_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.pos)));
            featListNeg.addElement(atts.indexOf("lm_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.SRL)));
            featListNeg.addElement(atts.indexOf("lm_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)lm_index).words.subcategorization)));
            featListNeg.addElement(atts.indexOf("sp_h_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.word)));
            featListNeg.addElement(atts.indexOf("sp_dp_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.DPRL)));
            featListNeg.addElement(atts.indexOf("sp_pos_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.pos)));
            featListNeg.addElement(atts.indexOf("sp_SRL_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.SRL)));
            featListNeg.addElement(atts.indexOf("sp_sub_" + this.constant_correction(this.sentence_feat.elementAt((int)sp_index).words.subcategorization)));
            featListNeg.addElement(atts.indexOf("d_sp_tr_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(tr_index)));
            featListNeg.addElement(atts.indexOf("d_sp_lm_" + this.sentence_feat.elementAt((int)sp_index).word_word.distance.elementAt(lm_index)));
            featListNeg.addElement(atts.indexOf("d_tr_lm_" + this.sentence_feat.elementAt((int)tr_index).word_word.distance.elementAt(lm_index)));
            Collections.sort(featListNeg);
            pN.print("{");
            t1 = 0;
            while (t1 < featListNeg.size()) {
                if ((Integer)featListNeg.elementAt(t1) != -1) {
                    pN.print(featListNeg.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            pN.println("2802 NSR}");
            ++r;
        }
    }

    public void add_maptask_arff_data(Vector<String> atts, PrintWriter p) {
        String labels = "TTP EC EQ DC TPPI PO NTPP NTPPI";
        int r = 0;
        while (r < this.relations.size()) {
            Vector<Integer> featList = new Vector<Integer>();
            String temty = this.relations.elementAt((int)r).calc_type.sp_value.elementAt(0).replaceAll("\"", "").trim().toUpperCase();
            if (!labels.contains(temty)) {
                temty = "NONE";
            }
            int r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_tr.ph.size()) {
                featList.addElement(atts.indexOf("tr_" + this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph.elementAt(r1))));
                ++r1;
            }
            r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_lm.ph.size()) {
                featList.addElement(atts.indexOf("lm_" + this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph.elementAt(r1))));
                ++r1;
            }
            r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_sp.ph.size()) {
                featList.addElement(atts.indexOf("sp_" + this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph.elementAt(r1))));
                ++r1;
            }
            r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_motion.ph.size()) {
                featList.addElement(atts.indexOf("mo_" + this.constant_correction(this.relations.elementAt((int)r).wh_motion.ph.elementAt(r1))));
                ++r1;
            }
            featList.addElement(atts.indexOf("for_" + this.constant_correction(this.relations.elementAt((int)r).FrORe)));
            featList.addElement(atts.indexOf("pa_" + this.constant_correction(this.relations.elementAt((int)r).path)));
            featList.addElement(atts.indexOf("dy_" + this.relations.elementAt((int)r).dynamic));
            featList.addElement(atts.indexOf("gum_" + this.constant_correction(this.relations.elementAt((int)r).GUM_mod)));
            Collections.sort(featList);
            p.print("{");
            int t1 = 0;
            while (t1 < featList.size()) {
                if ((Integer)featList.elementAt(t1) != -1) {
                    p.print(featList.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            p.println("1098 " + temty + "}");
            ++r;
        }
    }

    public void add_Room_arff_data(Vector<String> atts, PrintWriter p) {
        String labels = "TTP EC EQ DC TPPI PO NTPP NTPPI";
        int r = 0;
        while (r < this.relations.size()) {
            Vector<Integer> featList = new Vector<Integer>();
            String temty = this.relations.elementAt((int)r).calc_type.sp_value.elementAt(0).replaceAll("\"", "").trim().toUpperCase();
            if (!labels.contains(temty)) {
                temty = "NONE";
            }
            int r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_tr.ph.size()) {
                if (!featList.contains(atts.indexOf("tr_" + this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph.elementAt(r1))))) {
                    featList.addElement(atts.indexOf("tr_" + this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph.elementAt(r1))));
                }
                ++r1;
            }
            r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_lm.ph.size()) {
                if (!featList.contains(atts.indexOf("lm_" + this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph.elementAt(r1))))) {
                    featList.addElement(atts.indexOf("lm_" + this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph.elementAt(r1))));
                }
                ++r1;
            }
            r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_sp.ph.size()) {
                if (!featList.contains(atts.indexOf("sp_" + this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph.elementAt(r1))))) {
                    featList.addElement(atts.indexOf("sp_" + this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph.elementAt(r1))));
                }
                ++r1;
            }
            featList.addElement(atts.indexOf("gum_" + this.constant_correction(this.relations.elementAt((int)r).GUM_mod)));
            Collections.sort(featList);
            p.print("{");
            int t1 = 0;
            while (t1 < featList.size()) {
                if ((Integer)featList.elementAt(t1) != -1) {
                    p.print(featList.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            p.println("1098 " + temty + "}");
            ++r;
        }
    }

    public void writeAlchemyOutputs(PrintWriter p, int wordcount) {
        Vector t = new Vector();
        Vector l = new Vector();
        Vector sp = new Vector();
        int r = 0;
        while (r < this.relations.size()) {
            p.println("sr(" + (this.relations.elementAt((int)r).wh_tr.head_index + wordcount) + "," + (this.relations.elementAt((int)r).wh_lm.head_index + wordcount) + "," + (this.relations.elementAt((int)r).wh_sp.head_index + wordcount) + ")");
            ++r;
        }
    }

    public void writeAlchemyInputs(PrintWriter p, int wordcount) {
        int len = this.sentence_feat.size();
        int w = 0;
        while (w < this.sentence_feat.size()) {
            p.println("dprl(" + (wordcount + w) + ",Dp_" + this.constant_correction(this.sentence_feat.elementAt((int)w).words.DPRL).toUpperCase() + ")");
            p.println("pos(" + (wordcount + w) + ",Pos_" + this.constant_correction(this.sentence_feat.elementAt((int)w).words.pos).toUpperCase() + ")");
            p.println("srl(" + (wordcount + w) + "," + this.constant_correction(this.sentence_feat.elementAt((int)w).words.SRL).toUpperCase() + ")");
            p.println("subcat(" + (wordcount + w) + ",Sub_" + this.constant_correction(this.sentence_feat.elementAt((int)w).words.subcategorization).toUpperCase() + ")");
            p.println("word(" + (wordcount + w) + ", \"" + this.sentence_feat.elementAt((int)w).words.word.toUpperCase() + "\")");
            int w_2 = 0;
            while (w_2 < this.sentence_feat.size()) {
                ++w_2;
            }
            ++w;
        }
        p.println("dprl(" + (wordcount + len) + ",Dp_0" + ")");
        p.println("pos(" + (wordcount + len) + ",Pos_0" + ")");
        p.println("srl(" + (wordcount + len) + ",0" + ")");
        p.println("subcat(" + (wordcount + len) + ",Sub_0" + ")");
        p.println("word(" + (wordcount + len) + ", \"undef\")");
    }

    public void fetch_Maptask_rel(Vector<Vector<String>> Rows, int i) {
        if (Rows.elementAt(i).size() < 15) {
            this.log(Level.WARNING, "warning: this row" + i + " does not contain a full sentence!!");
        } else {
            this.content = Rows.elementAt(i).elementAt(2);
            this.content = this.content.trim();
            this.content = this.content.replace(",", " , ");
            this.content = this.content.replace("(", " ( ");
            this.content = this.content.replace(")", " ) ");
            this.content = this.content.replaceAll("[\\s][\\s]*", " ");
            this.content = this.content.replaceAll("\"", "");
            do {
                relation r = new relation();
                if (Rows.elementAt(i).size() == 14) {
                    Rows.elementAt(i).add(0, " ");
                }
                r.read_rel_map(Rows.elementAt(i));
                this.relations.addElement(r);
            } while (!build_RelDB_SbySEdition4arff_Maptask_test.isInteger(Rows.elementAt(++i).elementAt(1)) && !Rows.elementAt(i).elementAt(0).contains("*"));
        }
    }

    public void fetch_Room_rel(Vector<Vector<String>> Rows, int i) {
        if (Rows.elementAt(i).elementAt(1).contains("+") || Rows.elementAt(i).elementAt(0).contains("*")) {
            this.log(Level.WARNING, "warning: this row" + i + " does not contain a full sentence!!");
        } else {
            this.content = Rows.elementAt(i).elementAt(0);
            this.content = this.content.trim();
            this.content = this.content.replace(",", " , ");
            this.content = this.content.replace("(", " ( ");
            this.content = this.content.replace(")", " ) ");
            this.content = this.content.replaceAll("[\\s][\\s]*", " ");
            this.content = this.content.replaceAll("\"", "");
            relation r = new relation();
            r.read_rel_Room(Rows.elementAt(i));
            this.relations.addElement(r);
            ++i;
        }
    }

    public void add_arff_dataRcc5(Vector<String> atts, PrintWriter p) {
        String labels = "TTP EC EQ DC TPPI PO NTPP NTPPI";
        int r = 0;
        while (r < this.relations.size()) {
            Vector<Integer> featList = new Vector<Integer>();
            String temty = this.relations.elementAt((int)r).calc_type.sp_value.elementAt(0).replaceAll("\"", "").trim().toUpperCase();
            if (!labels.contains(temty)) {
                temty = "NONE";
            }
            if (temty.contains("TPP")) {
                temty = "PP";
            }
            featList.addElement(atts.indexOf("tr_" + this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph_head)));
            int r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_tr.ph.size()) {
                if (!this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph.elementAt(r1)).equals(this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph_head))) {
                    featList.addElement(atts.indexOf("tr1_" + this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph.elementAt(r1))));
                }
                ++r1;
            }
            featList.addElement(atts.indexOf("lm_" + this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph_head)));
            r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_lm.ph.size()) {
                if (!this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph.elementAt(r1)).equals(this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph_head))) {
                    featList.addElement(atts.indexOf("lm1_" + this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph.elementAt(r1))));
                }
                ++r1;
            }
            featList.addElement(atts.indexOf("sp_" + this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph_head)));
            r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_sp.ph.size()) {
                if (!this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph.elementAt(r1)).equals(this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph_head))) {
                    featList.addElement(atts.indexOf("sp1_" + this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph.elementAt(r1))));
                }
                ++r1;
            }
            featList.addElement(atts.indexOf("mo_" + this.constant_correction(this.relations.elementAt((int)r).wh_motion.ph_head)));
            featList.addElement(atts.indexOf("for_" + this.constant_correction(this.relations.elementAt((int)r).FrORe)));
            featList.addElement(atts.indexOf("pa_" + this.constant_correction(this.relations.elementAt((int)r).path)));
            featList.addElement(atts.indexOf("dy_" + this.relations.elementAt((int)r).dynamic));
            featList.addElement(atts.indexOf("gum_" + this.constant_correction(this.relations.elementAt((int)r).GUM_mod)));
            Collections.sort(featList);
            p.print("{");
            int t1 = 0;
            while (t1 < featList.size()) {
                if ((Integer)featList.elementAt(t1) != -1) {
                    p.print(featList.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            p.println("1098 " + temty + "}");
            ++r;
        }
    }

    public void add_arff_GeneralSP_data(Vector<String> atts, PrintWriter p) {
        String labels = "REGION DIRECTION DISTANCE";
        int r = 0;
        while (r < this.relations.size()) {
            Vector<Integer> featList = new Vector<Integer>();
            String temty = this.relations.elementAt((int)r).calc_type.general.elementAt(0).replaceAll("\"", "").trim().toUpperCase();
            if (!labels.contains(temty)) {
                temty = "NONE";
            }
            featList.addElement(atts.indexOf("tr_" + this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph_head)));
            int r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_tr.ph.size()) {
                if (!this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph.elementAt(r1)).equals(this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph_head))) {
                    featList.addElement(atts.indexOf("tr1_" + this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph.elementAt(r1))));
                }
                ++r1;
            }
            featList.addElement(atts.indexOf("lm_" + this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph_head)));
            r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_lm.ph.size()) {
                if (!this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph.elementAt(r1)).equals(this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph_head))) {
                    featList.addElement(atts.indexOf("lm1_" + this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph.elementAt(r1))));
                }
                ++r1;
            }
            featList.addElement(atts.indexOf("sp_" + this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph_head)));
            r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_sp.ph.size()) {
                if (!this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph.elementAt(r1)).equals(this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph_head))) {
                    featList.addElement(atts.indexOf("sp1_" + this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph.elementAt(r1))));
                }
                ++r1;
            }
            featList.addElement(atts.indexOf("mo_" + this.constant_correction(this.relations.elementAt((int)r).wh_motion.ph_head)));
            featList.addElement(atts.indexOf("for_" + this.constant_correction(this.relations.elementAt((int)r).FrORe)));
            featList.addElement(atts.indexOf("pa_" + this.constant_correction(this.relations.elementAt((int)r).path)));
            featList.addElement(atts.indexOf("dy_" + this.relations.elementAt((int)r).dynamic));
            featList.addElement(atts.indexOf("gum_" + this.constant_correction(this.relations.elementAt((int)r).GUM_mod)));
            Collections.sort(featList);
            p.print("{");
            int t1 = 0;
            while (t1 < featList.size()) {
                if ((Integer)featList.elementAt(t1) != -1) {
                    p.print(featList.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            p.println("1098 " + temty + "}");
            ++r;
        }
    }

    public void add_arff_GUM_data(Vector<String> atts, PrintWriter p) {
        String labels = "REGION DIRECTION DISTANCE";
        int r = 0;
        while (r < this.relations.size()) {
            Vector<Integer> featList = new Vector<Integer>();
            String temty = this.relations.elementAt((int)r).calc_type.general.elementAt(0).replaceAll("\"", "").trim().toUpperCase();
            if (!labels.contains(temty)) {
                temty = "NONE";
            }
            featList.addElement(atts.indexOf("tr_" + this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph_head)));
            int r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_tr.ph.size()) {
                if (!this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph.elementAt(r1)).equals(this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph_head))) {
                    featList.addElement(atts.indexOf("tr1_" + this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph.elementAt(r1))));
                }
                ++r1;
            }
            featList.addElement(atts.indexOf("lm_" + this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph_head)));
            r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_lm.ph.size()) {
                if (!this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph.elementAt(r1)).equals(this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph_head))) {
                    featList.addElement(atts.indexOf("lm1_" + this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph.elementAt(r1))));
                }
                ++r1;
            }
            featList.addElement(atts.indexOf("sp_" + this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph_head)));
            r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_sp.ph.size()) {
                if (!this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph.elementAt(r1)).equals(this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph_head))) {
                    featList.addElement(atts.indexOf("sp1_" + this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph.elementAt(r1))));
                }
                ++r1;
            }
            featList.addElement(atts.indexOf("mo_" + this.constant_correction(this.relations.elementAt((int)r).wh_motion.ph_head)));
            featList.addElement(atts.indexOf("for_" + this.constant_correction(this.relations.elementAt((int)r).FrORe)));
            featList.addElement(atts.indexOf("pa_" + this.constant_correction(this.relations.elementAt((int)r).path)));
            featList.addElement(atts.indexOf("dy_" + this.relations.elementAt((int)r).dynamic));
            Collections.sort(featList);
            p.print("{");
            int t1 = 0;
            while (t1 < featList.size()) {
                if ((Integer)featList.elementAt(t1) != -1) {
                    p.print(featList.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            p.println("1059 " + this.constant_correction(this.relations.elementAt((int)r).GUM_mod) + "}");
            ++r;
        }
    }

    public void add_arff_dataRcc5standard(Vector<String> atts, PrintWriter p) {
        String labels = "TTP EC EQ DC TPPI PO NTPP NTPPI";
        int r = 0;
        while (r < this.relations.size()) {
            Vector<Integer> featList = new Vector<Integer>();
            String temty = this.relations.elementAt((int)r).calc_type.sp_value.elementAt(0).replaceAll("\"", "").trim().toUpperCase();
            if (!labels.contains(temty)) {
                temty = "NONE";
            }
            if (temty.endsWith("TPP")) {
                temty = "PP";
            }
            if (temty.endsWith("TPPI")) {
                temty = "PPI";
            }
            if (temty.contains("EC")) {
                temty = "DC";
            }
            if (temty.contains("DC")) {
                temty = "DR";
            }
            featList.addElement(atts.indexOf("tr_" + this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph_head)));
            int r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_tr.ph.size()) {
                if (!this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph.elementAt(r1)).equals(this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph_head))) {
                    featList.addElement(atts.indexOf("tr1_" + this.constant_correction(this.relations.elementAt((int)r).wh_tr.ph.elementAt(r1))));
                }
                ++r1;
            }
            featList.addElement(atts.indexOf("lm_" + this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph_head)));
            r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_lm.ph.size()) {
                if (!this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph.elementAt(r1)).equals(this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph_head))) {
                    featList.addElement(atts.indexOf("lm1_" + this.constant_correction(this.relations.elementAt((int)r).wh_lm.ph.elementAt(r1))));
                }
                ++r1;
            }
            featList.addElement(atts.indexOf("sp_" + this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph_head)));
            r1 = 0;
            while (r1 < this.relations.elementAt((int)r).wh_sp.ph.size()) {
                if (!this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph.elementAt(r1)).equals(this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph_head))) {
                    featList.addElement(atts.indexOf("sp1_" + this.constant_correction(this.relations.elementAt((int)r).wh_sp.ph.elementAt(r1))));
                }
                ++r1;
            }
            featList.addElement(atts.indexOf("mo_" + this.constant_correction(this.relations.elementAt((int)r).wh_motion.ph_head)));
            featList.addElement(atts.indexOf("for_" + this.constant_correction(this.relations.elementAt((int)r).FrORe)));
            featList.addElement(atts.indexOf("pa_" + this.constant_correction(this.relations.elementAt((int)r).path)));
            featList.addElement(atts.indexOf("dy_" + this.relations.elementAt((int)r).dynamic));
            featList.addElement(atts.indexOf("gum_" + this.constant_correction(this.relations.elementAt((int)r).GUM_mod)));
            Collections.sort(featList);
            p.print("{");
            int t1 = 0;
            while (t1 < featList.size()) {
                if ((Integer)featList.elementAt(t1) != -1) {
                    p.print(featList.elementAt(t1) + " 1,");
                }
                ++t1;
            }
            p.println("1098 " + temty + "}");
            ++r;
        }
    }

    public void writeXMLtest(PrintWriter spxml, int sentence_num) {
        spxml.println("<SENTENCE id='s" + sentence_num + "'>");
        spxml.print("<CONTENT>");
        spxml.print(this.content);
        spxml.println("</CONTENT>");
        spxml.println("</SENTENCE>");
        spxml.println();
    }

    public void writeXML(PrintWriter spxml, int sentence_num) {
        Vector<Integer> tr = new Vector<Integer>();
        Vector<Integer> lm = new Vector<Integer>();
        Vector<Integer> sp = new Vector<Integer>();
        spxml.println("<SENTENCE id='s" + sentence_num + "'>");
        spxml.print("<CONTENT>");
        spxml.print(this.content);
        spxml.println("</CONTENT>");
        int i = 0;
        while (i < this.relations.size()) {
            relation t = this.relations.elementAt(i);
            if (!tr.contains(t.wh_tr.head_index)) {
                tr.addElement(t.wh_tr.head_index);
                spxml.println("<TRAJECTOR id='tw" + t.wh_tr.head_index + "'>" + t.wh_tr.ph_head + "</TRAJECTOR>");
            }
            if (!lm.contains(t.wh_lm.head_index)) {
                lm.addElement(t.wh_lm.head_index);
                spxml.println("<LANDMARK id='lw" + t.wh_lm.head_index + "'>" + t.wh_lm.ph_head + "</LANDMARK>");
            }
            if (!sp.contains(t.wh_sp.head_index)) {
                sp.addElement(t.wh_sp.head_index);
                spxml.print("<SPATIAL_INDICATOR id='sw" + t.wh_sp.head_index + "'>");
                int j = 0;
                while (j < t.wh_sp.ph.size()) {
                    spxml.print(String.valueOf(t.wh_sp.ph.elementAt(j)) + " ");
                    ++j;
                }
                spxml.println("</SPATIAL_INDICATOR>");
            }
            String tempg = t.calc_type.general.elementAt(0).toLowerCase();
            tempg = tempg.replaceAll("\"", "");
            tempg = tempg.trim();
            spxml.println("<RELATION id='r" + i + "'\tsp='sw" + t.wh_sp.head_index + "'\ttr='tw" + t.wh_tr.head_index + "'\tlm='lw" + t.wh_lm.head_index + "'" + "\tgeneral_type='" + tempg + "'/>");
            ++i;
        }
        spxml.println("</SENTENCE>");
        spxml.println();
    }

    public void writeXMLphrase(PrintWriter spxml, int sentence_num) {
        Vector<Integer> tr = new Vector<Integer>();
        Vector<Integer> lm = new Vector<Integer>();
        Vector<Integer> sp = new Vector<Integer>();
        spxml.println("<SENTENCE id='s" + sentence_num + "'>");
        spxml.print("<CONTENT>");
        spxml.print(this.content);
        spxml.println("</CONTENT>");
        int i = 0;
        while (i < this.relations.size()) {
            int j;
            relation t = this.relations.elementAt(i);
            if (!tr.contains(t.wh_tr.head_index)) {
                tr.addElement(t.wh_tr.head_index);
                spxml.println("<TRAJECTOR id='tw" + t.wh_tr.head_index + "'>");
                j = 0;
                while (j < t.wh_tr.ph.size()) {
                    spxml.print(String.valueOf(t.wh_tr.ph.elementAt(j)) + " ");
                    ++j;
                }
                spxml.println("</TRAJECTOR>");
            }
            if (!lm.contains(t.wh_lm.head_index)) {
                lm.addElement(t.wh_lm.head_index);
                spxml.println("<LANDMARK id='lw" + t.wh_lm.head_index + "'>");
                j = 0;
                while (j < t.wh_lm.ph.size()) {
                    spxml.print(String.valueOf(t.wh_lm.ph.elementAt(j)) + " ");
                    ++j;
                }
                spxml.println("</LANDMARK>");
            }
            if (!sp.contains(t.wh_sp.head_index)) {
                sp.addElement(t.wh_sp.head_index);
                spxml.print("<SPATIAL_INDICATOR id='sw" + t.wh_sp.head_index + "'>");
                j = 0;
                while (j < t.wh_sp.ph.size()) {
                    spxml.print(String.valueOf(t.wh_sp.ph.elementAt(j)) + " ");
                    ++j;
                }
                spxml.println("</SPATIAL_INDICATOR>");
            }
            String tempg = t.calc_type.general.elementAt(0).toLowerCase();
            tempg = tempg.replaceAll("\"", "");
            tempg = tempg.trim();
            spxml.println("<RELATION id='r" + i + "'\tsp='sw" + t.wh_sp.head_index + "'\ttr='tw" + t.wh_tr.head_index + "'\tlm='lw" + t.wh_lm.head_index + "'" + "\tgeneral_type='" + tempg + "'/>");
            ++i;
        }
        spxml.println("</SENTENCE>");
        spxml.println();
    }

    public int svm_struct_output(int w) {
        int S = -1;
        int r = 0;
        while (r < this.relations.size()) {
            if (this.relations.elementAt((int)r).wh_lm.head_index == w) {
                S = 1;
            }
            if (this.relations.elementAt((int)r).wh_tr.head_index == w) {
                S = 2;
            }
            if (this.relations.elementAt((int)r).wh_sp.head_index == w) {
                S = 3;
            }
            ++r;
        }
        if (S == -1) {
            S = 0;
        }
        return S;
    }

    public void writeRelationalFeatureSvmStruct(Vector<Vector<String>> atts, PrintWriter pw, PrintWriter pwPredicates) {
        int w = 0;
        while (w < this.sentence_feat.size()) {
            Vector<Integer> featList = new Vector<Integer>();
            String s = "";
            s = this.constant_correction(this.sentence_feat.elementAt((int)w).words.word);
            featList.addElement(atts.elementAt(0).indexOf(s));
            pwPredicates.print("word(" + (w + 1) + "," + s + ").");
            s = this.constant_correction(this.sentence_feat.elementAt((int)w).words.pos);
            featList.addElement(atts.elementAt(1).indexOf(s));
            pwPredicates.print("pos(" + (w + 1) + "," + s + ").");
            s = this.constant_correction(this.sentence_feat.elementAt((int)w).words.subcategorization);
            featList.addElement(atts.elementAt(2).indexOf(s));
            pwPredicates.print("subcat(" + (w + 1) + "," + s + ").");
            s = this.constant_correction(this.sentence_feat.elementAt((int)w).words.DPRL);
            featList.addElement(atts.elementAt(3).indexOf(s));
            pwPredicates.print("dprl(" + (w + 1) + "," + s + ").");
            s = this.constant_correction(this.sentence_feat.elementAt((int)w).words.SRL);
            featList.addElement(atts.elementAt(4).indexOf(s));
            pwPredicates.println("srl(" + (w + 1) + "," + s + ").");
            featList.addElement(this.svm_struct_output(w));
            int t1 = 0;
            while (t1 < featList.size() - 1) {
                pw.print(featList.elementAt(t1) + ", ");
                ++t1;
            }
            pw.println(featList.elementAt(featList.size() - 1));
            ++w;
        }
        pw.println();
    }

    public void writeRelationalFeatureSvmStructSemanticWeb(Vector<Vector<String>> atts, PrintParameters pw) {
        int S_counter = 0;
        int T_counter = 0;
        int L_counter = 0;
        int RS_counter = 0;
        boolean TS_counter = false;
        boolean LS_counter = false;
        int w = 0;
        while (w <= this.sentence_feat.size()) {
            Vector<Integer> featList = new Vector<Integer>();
            Vector<Integer> RfeatList = new Vector<Integer>();
            int hashindex = -1;
            String s = "";
            if (this.sp_candidates.contains(w)) {
                hashindex = 1;
            }
            if (this.lm_candidates.contains(w) || this.tr_candidates.contains(w)) {
                hashindex = 0;
                int ind = 0;
                while (ind < this.sp_candidates.size()) {
                    int sp_index = this.sp_candidates.elementAt(ind);
                    if (w < this.sentence_feat.size()) {
                        if (!this.sentence_feat.elementAt((int)w).word_word.distance.isEmpty() && sp_index != this.sentence_feat.size()) {
                            s = this.constant_correction("dis_" + this.sentence_feat.elementAt((int)w).word_word.distance.elementAt(sp_index));
                        }
                        if (atts.elementAt(1).indexOf(s) >= 0) {
                            RfeatList.addElement(atts.elementAt(1).indexOf(s) + 1);
                        }
                        pw.inputpredicates.print("pair(" + (sp_index + 1) + "," + (w + 1) + "," + s + ").");
                        if (!this.sentence_feat.elementAt((int)w).word_word.distance.isEmpty() && sp_index != this.sentence_feat.size()) {
                            s = this.constant_correction("diseq_" + Math.abs(w - sp_index));
                        }
                        if (atts.elementAt(1).indexOf(s) >= 0) {
                            RfeatList.addElement(atts.elementAt(1).indexOf(s) + 1);
                        }
                        pw.inputpredicates.print("pair(" + (sp_index + 1) + "," + (w + 1) + "," + s + ").");
                        if (!this.sentence_feat.elementAt((int)w).word_word.deppath.isEmpty() && sp_index != this.sentence_feat.size()) {
                            s = "dpath_" + this.constant_correction(this.sentence_feat.elementAt((int)w).word_word.deppath.elementAt(sp_index));
                        }
                        if (atts.elementAt(1).indexOf(s) >= 0) {
                            RfeatList.addElement(atts.elementAt(1).indexOf(s) + 1);
                        }
                        pw.inputpredicates.print("pair(" + (sp_index + 1) + "," + (w + 1) + "," + s + ").");
                        s = w < sp_index ? "before_0" : "before_1";
                        if (atts.elementAt(1).indexOf(s) >= 0) {
                            RfeatList.addElement(atts.elementAt(1).indexOf(s) + 1);
                        }
                        pw.inputpredicates.print("pair(" + (sp_index + 1) + "," + (w + 1) + "," + s + ").");
                        if (sp_index == this.sentence_feat.size()) {
                            int before_1_index = atts.elementAt(1).indexOf("before_1");
                            if (before_1_index >= 0) {
                                RfeatList.addElement(before_1_index + 1);
                            }
                            pw.inputpredicates.print("pair(" + (sp_index + 1) + "," + (w + 1) + "," + "before_1" + ").");
                        }
                    } else {
                        s = "undef";
                        pw.inputpredicates.print("pair(" + (sp_index + 1) + "," + (w + 1) + "," + s + ").");
                        RfeatList.addElement(atts.elementAt(1).indexOf(s) + 1);
                    }
                    int f = 0;
                    while (f < RfeatList.size()) {
                        if (this.lm_candidates.contains(w) || this.tr_candidates.contains(w)) {
                            pw.pairFeatures.println(String.valueOf(RS_counter + 1) + "\t" + RfeatList.elementAt(f) + "\t" + "1");
                        }
                        ++f;
                    }
                    if (this.tr_candidates.contains(w)) {
                        if (this.SpTr_annotated(sp_index, w)) {
                            pw.relationLabelsTr_Sp.println(String.valueOf(RS_counter + 1) + "\t1" + "\t" + (sp_index + 1) + "\t" + (w + 1));
                        } else {
                            pw.relationLabelsTr_Sp.println(String.valueOf(RS_counter + 1) + "\t0" + "\t" + (sp_index + 1) + "\t" + (w + 1));
                        }
                    }
                    if (this.lm_candidates.contains(w)) {
                        if (this.SpLm_annotated(sp_index, w)) {
                            pw.relationLabelsLm_Sp.println(String.valueOf(RS_counter + 1) + "\t1" + "\t" + (sp_index + 1) + "\t" + (w + 1));
                        } else {
                            pw.relationLabelsLm_Sp.println(String.valueOf(RS_counter + 1) + "\t0" + "\t" + (sp_index + 1) + "\t" + (w + 1));
                        }
                    }
                    ++RS_counter;
                    ++ind;
                }
            }
            if (hashindex == 0 || hashindex == 1) {
                if (w < this.sentence_feat.size()) {
                    s = this.constant_correction("txt_" + this.sentence_feat.elementAt((int)w).words.word);
                    if (atts.elementAt(0).indexOf(s) >= 0) {
                        featList.addElement(atts.elementAt(0).indexOf(s) + 1);
                    }
                    pw.inputpredicates.print("word(" + (w + 1) + "," + s + ").");
                    s = this.constant_correction("pos_" + this.sentence_feat.elementAt((int)w).words.pos);
                    if (atts.elementAt(0).indexOf(s) >= 0) {
                        featList.addElement(atts.elementAt(0).indexOf(s) + 1);
                    }
                    pw.inputpredicates.print("pos(" + (w + 1) + "," + s + ").");
                    s = this.constant_correction("sub_" + this.sentence_feat.elementAt((int)w).words.subcategorization);
                    if (atts.elementAt(0).indexOf(s) >= 0) {
                        featList.addElement(atts.elementAt(0).indexOf(s) + 1);
                    }
                    pw.inputpredicates.print("subcat(" + (w + 1) + "," + s + ").");
                    s = this.constant_correction("dprl_" + this.sentence_feat.elementAt((int)w).words.DPRL);
                    if (atts.elementAt(0).indexOf(s) >= 0) {
                        featList.addElement(atts.elementAt(0).indexOf(s) + 1);
                    }
                    pw.inputpredicates.print("dprl(" + (w + 1) + "," + s + ").");
                    s = this.constant_correction("srl_" + this.sentence_feat.elementAt((int)w).words.SRL);
                    if (atts.elementAt(0).indexOf(s) >= 0) {
                        featList.addElement(atts.elementAt(0).indexOf(s) + 1);
                    }
                    pw.inputpredicates.println("srl(" + (w + 1) + "," + s + ").");
                } else {
                    s = "undef";
                    featList.addElement(atts.elementAt(0).indexOf(s) + 1);
                }
                int t1 = 0;
                while (t1 < featList.size() - 1) {
                    if (hashindex == 0 || hashindex == 1) {
                        pw.roleFeatures.println(String.valueOf(w + 1) + "\t" + featList.elementAt(t1) + "\t" + "1");
                    }
                    ++t1;
                }
                if (this.tr_candidates.contains(w)) {
                    if (this.tr_annotated(w)) {
                        pw.TrLabels.println(String.valueOf(w + 1) + "\t1\t" + (T_counter + 1));
                    } else {
                        pw.TrLabels.println(String.valueOf(w + 1) + "\t0\t" + (T_counter + 1));
                    }
                    ++T_counter;
                }
                if (this.lm_candidates.contains(w)) {
                    if (this.lm_annotated(w)) {
                        pw.LmLabels.println(String.valueOf(w + 1) + "\t1\t" + (L_counter + 1));
                    } else {
                        pw.LmLabels.println(String.valueOf(w + 1) + "\t0\t" + (L_counter + 1));
                    }
                    ++L_counter;
                }
                if (hashindex == 1 || w == this.sentence_feat.size()) {
                    if (this.sp_annotated(w)) {
                        pw.SpLabels.println(String.valueOf(w + 1) + "\t1\t" + (S_counter + 1));
                    } else {
                        pw.SpLabels.println(String.valueOf(w + 1) + "\t0\t" + (S_counter + 1));
                    }
                    ++S_counter;
                }
            }
            ++w;
        }
        int i = 0;
        while (i < this.relations.size()) {
            if (this.relations.elementAt((int)i).wh_sp.head_index == -1 || this.relations.elementAt((int)i).wh_sp.ph_head == null || !this.sp_candidates.contains(new Integer(this.relations.elementAt((int)i).wh_sp.head_index))) {
                pw.relations.print(String.valueOf(this.sentence_feat.size() + 1) + ",");
            } else {
                pw.relations.print(String.valueOf(this.relations.elementAt((int)i).wh_sp.head_index + 1) + ",");
            }
            if (this.relations.elementAt((int)i).wh_tr.head_index == -1 || this.relations.elementAt((int)i).wh_tr.ph_head == null || !this.tr_candidates.contains(new Integer(this.relations.elementAt((int)i).wh_tr.head_index))) {
                pw.relations.print(String.valueOf(this.sentence_feat.size() + 1) + ",");
            } else {
                pw.relations.print(String.valueOf(this.relations.elementAt((int)i).wh_tr.head_index + 1) + ",");
            }
            if (this.relations.elementAt((int)i).wh_lm.head_index == -1 || this.relations.elementAt((int)i).wh_lm.ph_head == null || !this.lm_candidates.contains(this.relations.elementAt((int)i).wh_lm.head_index)) {
                pw.relations.println(String.valueOf(this.sentence_feat.size() + 1) + ",");
            } else {
                pw.relations.println(this.relations.elementAt((int)i).wh_lm.head_index + 1);
            }
            pw.outputpredicates.print("sr(" + this.relations.elementAt((int)i).wh_sp.ph_head + ",");
            pw.outputpredicates.print(String.valueOf(this.relations.elementAt((int)i).wh_tr.ph_head) + ",");
            pw.outputpredicates.println(String.valueOf(this.relations.elementAt((int)i).wh_lm.ph_head) + ")");
            int o = 0;
            o = 0;
            while (o < this.relations.elementAt((int)i).calc_type.flat_output.length - 1) {
                pw.ontologyLables.print(String.valueOf(this.relations.elementAt((int)i).calc_type.flat_output[o]) + ",");
                ++o;
            }
            pw.ontologyLables.println(this.relations.elementAt((int)i).calc_type.flat_output[o]);
            ++i;
        }
        pw.relations.println();
        pw.outputpredicates.println();
    }

    public void writeRelationalOutputSvmStructSemanticWeb(PrintWriter pw, PrintWriter pwPredicates) {
        int i = 0;
        while (i < this.relations.size()) {
            pw.print(String.valueOf(this.relations.elementAt((int)i).wh_sp.head_index + 1) + ",");
            pw.print(String.valueOf(this.relations.elementAt((int)i).wh_tr.head_index + 1) + ",");
            pw.println(this.relations.elementAt((int)i).wh_lm.head_index + 1);
            pwPredicates.print(String.valueOf(this.relations.elementAt((int)i).wh_sp.ph_head) + ",");
            pwPredicates.print(String.valueOf(this.relations.elementAt((int)i).wh_tr.ph_head) + ",");
            pwPredicates.println(String.valueOf(this.relations.elementAt((int)i).wh_lm.ph_head) + ",");
            ++i;
        }
        pw.println();
        pwPredicates.println();
    }

    public void writeRelationalOutputSvmStruct(PrintWriter pw, PrintWriter pwPredicates, int[] num) {
        int j = 0;
        int i = 0;
        while (i < this.relations.size()) {
            pw.print(String.valueOf(this.relations.elementAt((int)i).wh_sp.head_index + 1) + ",");
            j = this.relations.elementAt((int)i).wh_sp.head_index - this.relations.elementAt((int)i).wh_tr.head_index;
            if (j < 0) {
                j *= -1;
            }
            if (j < 32) {
                int n = j;
                num[n] = num[n] + 1;
            }
            pw.print(String.valueOf(this.relations.elementAt((int)i).wh_tr.head_index + 1) + ",");
            j = this.relations.elementAt((int)i).wh_tr.head_index - this.relations.elementAt((int)i).wh_lm.head_index;
            if (j < 0) {
                j *= -1;
            }
            if (j < 32) {
                int n = j;
                num[n] = num[n] + 1;
            }
            pw.println(this.relations.elementAt((int)i).wh_lm.head_index + 1);
            j = this.relations.elementAt((int)i).wh_sp.head_index - this.relations.elementAt((int)i).wh_lm.head_index;
            if (j < 0) {
                j *= -1;
            }
            if (j < 32) {
                int n = j;
                num[n] = num[n] + 1;
            }
            pwPredicates.print(String.valueOf(this.relations.elementAt((int)i).wh_sp.ph_head) + ",");
            pwPredicates.print(String.valueOf(this.relations.elementAt((int)i).wh_tr.ph_head) + ",");
            pwPredicates.println(String.valueOf(this.relations.elementAt((int)i).wh_lm.ph_head) + ",");
            ++i;
        }
        pw.println();
        pwPredicates.println();
    }

    public int distance(int i, int j) {
        int dis = 0;
        if (i > j) {
            int t = j;
            j = i;
            i = t;
        }
        if (j >= this.sentence_feat.size()) {
            dis = 33;
            return dis;
        }
        int iter = i;
        while (iter <= j) {
            String S = this.sentence_feat.elementAt((int)iter).words.pos.toLowerCase();
            if (S.contains("nn") || S.contains("nns") || S.contains("prp") || S.contains("in") || S.contains("on") || S.contains("to")) {
                ++dis;
            }
            ++iter;
        }
        return dis;
    }

    public void writeRelationalOutputSvmStruct_Statistics(PrintWriter pw, PrintWriter pwPredicates, int[] num, int[] numdis, int[] numneg, int[] numnegdis) {
        int d1 = 0;
        int d2 = 0;
        int d3 = 0;
        int dideal = 0;
        int j = 0;
        int i = 0;
        while (i < this.relations.size()) {
            d1 = this.relations.elementAt((int)i).wh_sp.head_index - this.relations.elementAt((int)i).wh_tr.head_index;
            if (d1 < 0) {
                d1 *= -1;
            }
            if ((d2 = this.relations.elementAt((int)i).wh_tr.head_index - this.relations.elementAt((int)i).wh_lm.head_index) < 0) {
                d2 *= -1;
            }
            if ((d3 = this.relations.elementAt((int)i).wh_sp.head_index - this.relations.elementAt((int)i).wh_lm.head_index) < 0) {
                d3 *= -1;
            }
            if (d3 > (dideal = d1 > d2 ? d1 : d2)) {
                dideal = d3;
            }
            if (dideal < 0) {
                dideal *= -1;
            }
            if (dideal < 32) {
                int n = dideal;
                num[n] = num[n] + 1;
            }
            if (dideal >= 9) {
                pw.print(String.valueOf(this.relations.elementAt((int)i).wh_sp.head_index + 1) + ",");
                pw.print(String.valueOf(this.relations.elementAt((int)i).wh_tr.head_index + 1) + ",");
                pw.println(this.relations.elementAt((int)i).wh_lm.head_index + 1);
                pw.println(String.valueOf(this.content) + "\t" + dideal);
            }
            if ((j = this.distance(this.relations.elementAt((int)i).wh_sp.head_index, this.relations.elementAt((int)i).wh_tr.head_index)) < 0) {
                j *= -1;
            }
            if (j < 32) {
                int n = j;
                numdis[n] = numdis[n] + 1;
            }
            if ((j = this.distance(this.relations.elementAt((int)i).wh_tr.head_index, this.relations.elementAt((int)i).wh_lm.head_index)) < 0) {
                j *= -1;
            }
            if (j < 32) {
                int n = j;
                numdis[n] = numdis[n] + 1;
            }
            if ((j = this.distance(this.relations.elementAt((int)i).wh_sp.head_index, this.relations.elementAt((int)i).wh_lm.head_index)) < 0) {
                j *= -1;
            }
            if (j < 32) {
                int n = j;
                numdis[n] = numdis[n] + 1;
            }
            pwPredicates.print(String.valueOf(this.relations.elementAt((int)i).wh_sp.ph_head) + ",");
            pwPredicates.print(String.valueOf(this.relations.elementAt((int)i).wh_tr.ph_head) + ",");
            pwPredicates.println(String.valueOf(this.relations.elementAt((int)i).wh_lm.ph_head) + ",");
            ++i;
        }
        pw.println();
        pwPredicates.println();
        i = 0;
        while (i < this.allnonrel.size()) {
            d1 = this.allnonrel.elementAt((int)i).sp - this.allnonrel.elementAt((int)i).tr;
            if (d1 < 0) {
                d1 *= -1;
            }
            if ((d2 = this.allnonrel.elementAt((int)i).tr - this.allnonrel.elementAt((int)i).lm) < 0) {
                d2 *= -1;
            }
            d3 = this.allnonrel.elementAt((int)i).sp - this.allnonrel.elementAt((int)i).lm;
            if (j < 0) {
                d3 *= -1;
            }
            if (d3 > (dideal = d1 > d2 ? d1 : d2)) {
                dideal = d3;
            }
            if (dideal < 0) {
                dideal *= -1;
            }
            if (dideal < 32) {
                int n = dideal;
                numneg[n] = numneg[n] + 1;
            }
            if ((j = this.distance(this.allnonrel.elementAt((int)i).sp, this.allnonrel.elementAt((int)i).tr)) < 0) {
                j *= -1;
            }
            if (j < 32) {
                int n = j;
                numnegdis[n] = numnegdis[n] + 1;
            }
            if ((j = this.distance(this.allnonrel.elementAt((int)i).tr, this.allnonrel.elementAt((int)i).lm)) < 0) {
                j *= -1;
            }
            if (j < 32) {
                int n = j;
                numnegdis[n] = numnegdis[n] + 1;
            }
            if ((j = this.distance(this.allnonrel.elementAt((int)i).sp, this.allnonrel.elementAt((int)i).lm)) < 0) {
                j *= -1;
            }
            if (j < 32) {
                int n = j;
                numnegdis[n] = numnegdis[n] + 1;
            }
            ++i;
        }
    }

    public void writeComplexRelationalFSvmStruct(Vector<String> atts, PrintWriter p) {
        int w = 0;
        while (w < this.sentence_feat.size()) {
            ++w;
        }
    }

    public void collect_RelCandidatesForSvmSemanticWeb(Vector<Vector<String>> arff) {
        arff.elementAt(1).addElement("before_0");
        arff.elementAt(1).addElement("before_1");
        arff.elementAt(1).addElement("undef");
        arff.elementAt(1).addElement("undef");
        int w = 0;
        while (w < this.sentence_feat.size()) {
            if (!arff.elementAt(0).contains("txt_" + this.constant_correction(this.sentence_feat.elementAt((int)w).words.word))) {
                arff.elementAt(0).addElement("txt_" + this.constant_correction(this.sentence_feat.elementAt((int)w).words.word));
            }
            if (!arff.elementAt(0).contains("pos_" + this.constant_correction(this.sentence_feat.elementAt((int)w).words.pos))) {
                arff.elementAt(0).addElement("pos_" + this.constant_correction(this.sentence_feat.elementAt((int)w).words.pos));
            }
            if (!arff.elementAt(0).contains("sub_" + this.constant_correction(this.sentence_feat.elementAt((int)w).words.subcategorization))) {
                arff.elementAt(0).addElement("sub_" + this.constant_correction(this.sentence_feat.elementAt((int)w).words.subcategorization));
            }
            if (!arff.elementAt(0).contains("dprl_" + this.constant_correction(this.sentence_feat.elementAt((int)w).words.DPRL))) {
                arff.elementAt(0).addElement("dprl_" + this.constant_correction(this.sentence_feat.elementAt((int)w).words.DPRL));
            }
            if (!arff.elementAt(0).contains("srl_" + this.constant_correction(this.sentence_feat.elementAt((int)w).words.SRL))) {
                arff.elementAt(0).addElement("srl_" + this.constant_correction(this.sentence_feat.elementAt((int)w).words.SRL));
            }
            if (this.lm_candidates.contains(w) || this.tr_candidates.contains(w)) {
                int sp_pair = 0;
                while (sp_pair < this.sp_candidates.size()) {
                    int sp_index = this.sp_candidates.elementAt(sp_pair);
                    int distr = -1;
                    int distSeq = 0;
                    String path = "";
                    String Dpath = "";
                    if (w != this.sentence_feat.size() && !this.sentence_feat.elementAt((int)w).word_word.distance.isEmpty() && sp_index != this.sentence_feat.size()) {
                        distr = this.sentence_feat.elementAt((int)w).word_word.distance.elementAt(sp_index);
                        path = this.constant_correction(this.sentence_feat.elementAt((int)w).word_word.path.elementAt(sp_index));
                        Dpath = this.constant_correction(this.sentence_feat.elementAt((int)w).word_word.deppath.elementAt(sp_index));
                        distSeq = Math.abs(sp_index - w);
                    }
                    if (!arff.elementAt(1).contains("dis_" + distr)) {
                        arff.elementAt(1).addElement("dis_" + distr);
                    }
                    if (!arff.elementAt(1).contains("diseq_" + distSeq)) {
                        arff.elementAt(1).addElement("diseq_" + distSeq);
                    }
                    if (!arff.elementAt(1).contains("dpath_" + Dpath)) {
                        arff.elementAt(1).addElement("dpath_" + Dpath);
                    }
                    ++sp_pair;
                }
            }
            ++w;
        }
    }

    public void collect_RelCandidatesForSvm(Vector<Vector<String>> arff) {
        int w = 0;
        while (w < this.sentence_feat.size()) {
            if (!arff.elementAt(0).contains(this.constant_correction(this.sentence_feat.elementAt((int)w).words.word))) {
                arff.elementAt(0).addElement(this.constant_correction(this.sentence_feat.elementAt((int)w).words.word));
            }
            if (!arff.elementAt(1).contains(this.constant_correction(this.sentence_feat.elementAt((int)w).words.pos))) {
                arff.elementAt(1).addElement(this.constant_correction(this.sentence_feat.elementAt((int)w).words.pos));
            }
            if (!arff.elementAt(2).contains(this.constant_correction(this.sentence_feat.elementAt((int)w).words.subcategorization))) {
                arff.elementAt(2).addElement(this.constant_correction(this.sentence_feat.elementAt((int)w).words.subcategorization));
            }
            if (!arff.elementAt(3).contains(this.constant_correction(this.sentence_feat.elementAt((int)w).words.DPRL))) {
                arff.elementAt(3).addElement(this.constant_correction(this.sentence_feat.elementAt((int)w).words.DPRL));
            }
            if (!arff.elementAt(4).contains(this.constant_correction(this.sentence_feat.elementAt((int)w).words.SRL))) {
                arff.elementAt(4).addElement(this.constant_correction(this.sentence_feat.elementAt((int)w).words.SRL));
            }
            ++w;
        }
    }

    public offsets txtIndex(Document doc, String sen) throws FileNotFoundException {
        String text = "";
        offsets ind = new offsets();
        ind.set(0, 0);
        try {
            NodeList listOfsentences = doc.getElementsByTagName("TEXT");
            int totalEntries = listOfsentences.getLength();
            if (totalEntries > 1) {
                System.out.print("Error, more than one TXT tag!");
                System.exit(1);
            }
            int s = 0;
            while (s < listOfsentences.getLength()) {
                Node firstSentenceNode = listOfsentences.item(s);
                this.log(Level.FINE, listOfsentences.item(s).getNodeName());
                if (firstSentenceNode.getNodeType() == 1) {
                    Element firstSentenceElement = (Element)firstSentenceNode;
                    NodeList textTxTList = firstSentenceElement.getChildNodes();
                    text = textTxTList.item(0).getNodeValue().trim();
                }
                ++s;
            }
            String temText1 = text.replaceAll("[^a-zA-Z0-9]", "_");
            String temText2 = text.replaceAll(" ", "").replaceAll("[^a-zA-Z0-9]", "_");
            if (temText2.contains(sen.replaceAll(" ", "").replaceAll("[^a-zA-Z0-9]", "_"))) {
                ind.set(temText1.indexOf(sen.replaceAll("[^a-zA-Z0-9]", "_")), temText1.indexOf(sen.replaceAll("[^a-zA-Z0-9]", "_")) + sen.length());
                if (temText1.indexOf(sen.replaceAll("[^a-zA-Z0-9]", "_")) == -1) {
                    int redun = sen.indexOf("'");
                    sen = this.content = this.content.replaceFirst("' ", "'");
                    ind.set(temText1.indexOf(sen.replaceAll("[^a-zA-Z0-9]", "_").substring(0, redun)), temText1.indexOf(sen.replaceAll("[^a-zA-Z0-9]", "_").substring(0, sen.indexOf("'"))) + sen.length());
                }
            } else {
                this.log(Level.WARNING, "Wrong sentence");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return ind;
    }

    public class calculi {
        Vector<String> general = new Vector();
        Vector<String> specific = new Vector();
        Vector<String> sp_value = new Vector();
        int[] flat_output = new int[16];

        public void set_calc(String g, String s, String v) {
            this.general = sentence.type_tok(g, "/");
            this.specific = sentence.type_tok(s, "/");
            this.sp_value = sentence.type_tok(v, "/");
        }
    }

    public class ling_features {
        public word_features words = new word_features();
        rel_word_features word_word = new rel_word_features();

        public class rel_word_features {
            Vector<String> path = new Vector();
            Vector<Integer> distance = new Vector();
            Vector<String> deppath = new Vector();
        }

        public class word_features {
            String word = null;
            public String head = null;
            String subcategorization = null;
            String pos = null;
            String DPRL = null;
            String SRL = null;
            String lemma = null;
            offsets offset = new offsets();
        }
    }

    public class nonrelation {
        int tr = 0;
        int lm = 0;
        int sp = 0;
    }

    public class phrase {
        Vector<String> ph = new Vector();
        String ph_head = null;
        int head_index = 0;

        public int index_tune(int wrongindex, String input) {
            int offset = 0;
            String temp = input.trim();
            Vector<String> t = sentence.type_tok(temp, " ");
            if (this.ph.elementAt(0).trim().toLowerCase().equals("others")) {
                System.out.print("stop");
            }
            int wt = 0;
            while (wt <= wrongindex + offset) {
                if (t.elementAt(wt).contains(",") || t.elementAt(wt).contains("?") || t.elementAt(wt).contains("(") || t.elementAt(wt).contains(")")) {
                    ++offset;
                }
                ++wt;
            }
            if (!t.elementAt(wrongindex + offset).trim().toLowerCase().equals(this.ph_head.trim().toLowerCase())) {
                System.out.print(this.ph);
            }
            return wrongindex + offset;
        }

        public void set_ph(String p, String h) {
            if ((h = h.replaceAll("\"", "")).replaceAll(" ", "").equals("_")) {
                this.ph_head = "undefined";
                this.head_index = -1;
            } else {
                this.ph_head = h;
                p = p.trim();
                p = p.replaceAll("[\\s][\\s]*", " ");
                p = p.replaceAll("\"", "");
                this.ph = sentence.type_tok(p, " ");
                String ind = "";
                if (h.contains("_")) {
                    this.ph_head = h.substring(0, h.indexOf("_"));
                    ind = h.substring(h.indexOf("_") + 1);
                }
                if (build_RelDB.isInteger(ind = ind.replaceAll("[^\\d]", ""))) {
                    this.head_index = Integer.parseInt(ind) - 1;
                    this.head_index = this.index_tune(this.head_index, sentence.this.content);
                } else {
                    sentence.this.log(Level.WARNING, "warning: no index determined");
                }
            }
        }

        public void set_ph_Xml(String p) {
            this.ph = sentence.type_tok(p, " ");
        }
    }

    public class potential_pivots_class {
        Vector<phrase> tpp_prepositions = new Vector();
        Vector<phrase> non_tpp_prepositions = new Vector();
        Vector<phrase> motion_verbs = new Vector();
        Vector<phrase> spatial_nouns = new Vector();
    }

    public class relation {
        phrase wh_tr;
        phrase wh_lm;
        phrase wh_sp;
        phrase wh_motion;
        boolean dynamic;
        String path;
        String FrORe;
        calculi calc_type;
        String GUM_mod;

        public relation() {
            this.wh_tr = new phrase();
            this.wh_lm = new phrase();
            this.wh_sp = new phrase();
            this.wh_motion = new phrase();
            this.dynamic = false;
            this.path = null;
            this.FrORe = null;
            this.calc_type = new calculi();
            this.GUM_mod = null;
        }

        public void read_rel_map(Vector<String> row) {
            this.wh_tr.set_ph(row.elementAt(7), row.elementAt(7));
            this.wh_lm.set_ph(row.elementAt(17), row.elementAt(17));
            this.wh_sp.set_ph(row.elementAt(15), row.elementAt(15));
            this.wh_motion.set_ph(row.elementAt(9), row.elementAt(9));
            this.calc_type.set_calc("_", "_", row.elementAt(0));
            this.GUM_mod = row.elementAt(14);
        }

        public void read_rel(Vector<String> row) {
            this.wh_tr.set_ph(row.elementAt(1), row.elementAt(5));
            this.wh_lm.set_ph(row.elementAt(2), row.elementAt(6));
            this.wh_sp.set_ph(row.elementAt(3), row.elementAt(7));
            this.wh_motion.set_ph(row.elementAt(4), row.elementAt(8));
            this.calc_type.set_calc(row.elementAt(9), row.elementAt(10), row.elementAt(11));
            sentence.this.flatten_sp(this.calc_type, 1);
            this.dynamic = !row.elementAt(12).toLowerCase().contains("static");
            this.path = row.elementAt(13);
            this.FrORe = row.elementAt(14);
            this.GUM_mod = row.elementAt(15);
        }

        public void read_rel_Room(Vector<String> row) {
            this.wh_tr.set_ph(row.elementAt(3), row.elementAt(3));
            this.wh_lm.set_ph(row.elementAt(6), row.elementAt(6));
            this.wh_sp.set_ph(row.elementAt(5), row.elementAt(5));
            this.calc_type.set_calc("_", "_", row.elementAt(2));
            this.GUM_mod = row.elementAt(4);
        }
    }
}

