/*
 * Decompiled with CFR 0.152.
 */
package RLpackage;

import RLpackage.TreeNode;
import java.util.Vector;

public class TreeRepresentation {
    private static boolean redoSpecialCharacters;

    public static TreeNode readTree(String tree) {
        if (tree.charAt(0) != '(') {
            throw new IllegalArgumentException("Malformed parse tree : " + tree);
        }
        int endOfLabel = tree.indexOf(32);
        String label = tree.substring(1, endOfLabel);
        int end = TreeRepresentation.getPosOfClosingBracket(tree);
        String remainder = tree.substring(endOfLabel + 1, end);
        if (remainder.charAt(0) == '(') {
            boolean finished = false;
            Vector<TreeNode> children = new Vector<TreeNode>();
            while (!finished) {
                int end2 = TreeRepresentation.getPosOfClosingBracket(remainder);
                String child = remainder.substring(0, end2 + 1);
                children.add(TreeRepresentation.readTree(child));
                if (end2 < remainder.length() - 1) {
                    remainder = remainder.substring(end2 + 2);
                    continue;
                }
                finished = true;
            }
            TreeNode[] childs = new TreeNode[children.size()];
            children.toArray(childs);
            return new TreeNode(label, childs);
        }
        String word = remainder;
        if (redoSpecialCharacters) {
            word = TreeRepresentation.replaceSpecialCharacters(word);
        }
        return new TreeNode(label, word);
    }

    private static String replaceSpecialCharacters(String word) {
        String lrb = new String("(");
        String rrb = new String(")");
        String quot = new String("\"");
        if (word.equalsIgnoreCase("-lrb-")) {
            return lrb;
        }
        if (word.equalsIgnoreCase("-rrb-")) {
            return rrb;
        }
        if (word.equals("``")) {
            return quot;
        }
        if (word.equals("''")) {
            return quot;
        }
        return word;
    }

    private static String putSpecialCharacters(String word) {
        String lrb = new String("-lrb-");
        String rrb = new String("-rrb-");
        String quot = new String("``");
        if (word.equalsIgnoreCase("(")) {
            return lrb;
        }
        if (word.equalsIgnoreCase(")")) {
            return rrb;
        }
        if (word.equals("\"")) {
            return quot;
        }
        return word;
    }

    private static int getPosOfClosingBracket(String input) {
        int pos = 0;
        int numOfBrackets = 0;
        while (pos < input.length()) {
            char curr = input.charAt(pos);
            if (curr == '(') {
                ++numOfBrackets;
            } else if (curr == ')') {
                --numOfBrackets;
            }
            if (numOfBrackets == 0) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public static String transformToText(TreeNode node) {
        if (node.hasWord()) {
            return "(" + node.getLabel() + " " + TreeRepresentation.putSpecialCharacters(node.getWord()) + ")";
        }
        String result = "(" + node.getLabel() + " ";
        int i = 0;
        while (i < node.getChildren().length) {
            result = String.valueOf(result) + TreeRepresentation.transformToText(node.getChildren()[i]);
            if (i != node.getChildren().length - 1) {
                result = String.valueOf(result) + " ";
            }
            ++i;
        }
        result = String.valueOf(result) + ")";
        return result;
    }
}

