/*
 * Decompiled with CFR 0.152.
 */
package kul.cs.liir.spatial.impl;

import SemEval2013.build_RelDB_SbySForSVMstructSemanticWeb;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kul.cs.liir.spatial.api.ISemEval2013SpatialRoleLabelling;
import kul.cs.liir.spatial.api.ITextPreprocessingProvider;
import kul.cs.liir.spatial.api.SentencePreprocessingResult;
import kul.cs.liir.spatial.api.SpatialRoleLabellingException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SemEval2013SpatialRoleLabellingImpl
implements ISemEval2013SpatialRoleLabelling {
    DocumentBuilderFactory docBuilderFactory;
    DocumentBuilder docBuilder;

    public SemEval2013SpatialRoleLabellingImpl() {
        try {
            this.docBuilderFactory = DocumentBuilderFactory.newInstance();
            this.docBuilder = this.docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new SpatialRoleLabellingException("Could not create parser", ex);
        }
    }

    @Override
    public void extractFeaturesAndResults(File inputXmlDir, File preprocessOutputDir, File outputDir, File featureVectorsDir, boolean testing) {
        try {
            build_RelDB_SbySForSVMstructSemanticWeb builder = new build_RelDB_SbySForSVMstructSemanticWeb(preprocessOutputDir, outputDir);
            builder.extractFeaturesAndTrainingData(inputXmlDir, featureVectorsDir, testing);
        }
        catch (Exception ex) {
            throw new SpatialRoleLabellingException("Error during feature extraction.", ex);
        }
    }

    @Override
    public void extractFeaturesForPrediction(File preprocessOutputDir, File outputDir, File featureVectorsDir) {
        try {
            build_RelDB_SbySForSVMstructSemanticWeb builder = new build_RelDB_SbySForSVMstructSemanticWeb(preprocessOutputDir, outputDir);
            builder.extractFeatures(featureVectorsDir);
        }
        catch (SAXException ex) {
            throw new SpatialRoleLabellingException("Error during feature extraction.", ex);
        }
        catch (IOException ex) {
            throw new SpatialRoleLabellingException("Error during feature extraction.", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new SpatialRoleLabellingException("Error during feature extraction.", ex);
        }
    }

    @Override
    public void preprocessXmlFiles(File inputXmlDir, File preprocessOutputDir, ITextPreprocessingProvider preprocessingProvider) {
        try {
            FilenameFilter xmlFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String lowercaseName = name.toLowerCase();
                    return lowercaseName.endsWith(".xml");
                }
            };
            File[] xmlfiles = inputXmlDir.listFiles(xmlFilter);
            File sentenceSplitDir = new File(preprocessOutputDir, "sentence_split");
            sentenceSplitDir.mkdirs();
            File lthDir = new File(preprocessOutputDir, "lth_files");
            lthDir.mkdirs();
            File charniakDir = new File(preprocessOutputDir, "charniak");
            charniakDir.mkdirs();
            File[] fileArray = xmlfiles;
            int n = xmlfiles.length;
            int n2 = 0;
            while (n2 < n) {
                File xmlFile = fileArray[n2];
                String text = this.getTextFromXmlFile(xmlFile);
                this.preprocessFile(preprocessingProvider, sentenceSplitDir, lthDir, charniakDir, xmlFile, text);
                ++n2;
            }
        }
        catch (Exception ex) {
            throw new SpatialRoleLabellingException("Error during preprocessing.", ex);
        }
    }

    private void preprocessFile(ITextPreprocessingProvider preprocessingProvider, File sentenceSplitDir, File lthDir, File charniakDir, File fileName, String fileText) throws IOException {
        List<SentencePreprocessingResult> preprocessingResultList = preprocessingProvider.preprocessText(fileText);
        String xmlBaseName = FilenameUtils.getBaseName((String)fileName.getName());
        int i = 0;
        while (i < preprocessingResultList.size()) {
            SentencePreprocessingResult preprocessingResult = preprocessingResultList.get(i);
            String baseName = String.valueOf(xmlBaseName) + "-" + (i + 1);
            File sentenceFile = new File(sentenceSplitDir, String.valueOf(baseName) + ".data");
            FileUtils.write((File)sentenceFile, (CharSequence)preprocessingResult.getSentenceText());
            File charniakFile = new File(charniakDir, String.valueOf(baseName) + ".char");
            String charniakParseTree = preprocessingResult.getCharniakParseTree().replaceAll("\\s+", " ");
            FileUtils.write((File)charniakFile, (CharSequence)charniakParseTree);
            File lthFile = new File(lthDir, String.valueOf(baseName) + ".lth");
            FileUtils.write((File)lthFile, (CharSequence)preprocessingResult.getConll2008srlOutput());
            ++i;
        }
    }

    private String getTextFromXmlFile(File xmlFile) throws SAXException, IOException {
        Document doc = this.docBuilder.parse(xmlFile);
        doc.getDocumentElement().normalize();
        NodeList listOfsentences = doc.getElementsByTagName("TEXT");
        int totalEntries = listOfsentences.getLength();
        if (totalEntries != 1) {
            throw new SpatialRoleLabellingException("Expected exactly 1 <TEXT> element in an input file");
        }
        Node firstSentenceNode = listOfsentences.item(0);
        if (firstSentenceNode.getNodeType() != 1) {
            throw new SpatialRoleLabellingException("Unexpected node type: " + firstSentenceNode);
        }
        Element firstSentenceElement = (Element)firstSentenceNode;
        NodeList textTxTList = firstSentenceElement.getChildNodes();
        return firstSentenceElement.getTextContent();
    }
}

