package cz.cuni.amis.utils.rewrite.rewriter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;

@XStreamAlias(value = "substitution")
public class Substitution {
	
	@XStreamAlias(value = "match")
	private String reMatch;
	
	@XStreamAlias(value = "replace")
	private String reSubst;
	
	@XStreamAlias(value = "caseSensitive")
	private Boolean caseSensitive;

	@XStreamOmitField
	private transient Pattern pattern;
	
	public Substitution() {		
	}
	
	public Substitution(String reMatch, String reSubst, boolean caseSensitive) {
		this.reMatch = reMatch;
		this.reSubst = reSubst;
		this.caseSensitive = caseSensitive;
	}
	
	private Substitution readResolve() {
		if (caseSensitive == null) caseSensitive = true;
		return this;
	}

	public String getReMatch() {
		return reMatch;
	}

	public void setReMatch(String reMatch) {		
		this.reMatch = reMatch;
		this.pattern = null;
	}

	public String getReSubst() {
		return reSubst;
	}

	public void setReSubst(String reSubst) {
		this.reSubst = reSubst;
	}
	
	public Pattern getPattern() {
		if (pattern == null) {
			pattern = Pattern.compile(reMatch, caseSensitive ? 0 : Pattern.CASE_INSENSITIVE);
		}
		return pattern;
	}
	
	public Matcher getMatcher(String str) {
		return getPattern().matcher(str);
	}
	
	public String substitute(String str) {
		return getMatcher(str).replaceAll(reSubst);
	}
	
	@Override
	public String toString() {
		return "Substitution[" + (caseSensitive ? "case-sensitive" : "case-INsensitive") + ", " + reMatch + " --> " + reSubst + "]";
	}

}
