/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.simple_logging;

import cz.cuni.amis.utils.simple_logging.SimpleLogHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class SimpleLogging {
    public static void initLogging() {
        for (Logger log = Logger.getAnonymousLogger(); log != null; log = log.getParent()) {
            for (Handler handler : log.getHandlers()) {
                log.removeHandler(handler);
            }
            if (log.getParent() != null) continue;
            log.addHandler(new SimpleLogHandler());
        }
    }

    public static void addFileLogging(String pathToFile) {
        try {
            final PrintWriter writer = new PrintWriter(new FileWriter(new File(pathToFile)));
            for (Logger log = Logger.getAnonymousLogger(); log != null; log = log.getParent()) {
                if (log.getParent() != null) continue;
                log.addHandler(new Handler(){

                    @Override
                    public void close() throws SecurityException {
                        writer.close();
                    }

                    @Override
                    public void flush() {
                        writer.flush();
                    }

                    @Override
                    public void publish(LogRecord record) {
                        writer.println("[" + record.getLevel() + "] " + record.getMessage());
                    }
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open file " + new File(pathToFile).getAbsolutePath() + " for logging!", e);
        }
    }
}

