/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.resolvers;

import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.AbstractResolveMojo;
import org.apache.maven.plugin.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugin.dependency.utils.filters.ResolveFileFilter;
import org.apache.maven.plugin.dependency.utils.markers.SourcesFileMarkerHandler;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;

@Mojo(name="sources", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class ResolveDependencySourcesMojo
extends AbstractResolveMojo {
    private static final String SOURCE_TYPE = "java-source";
    private static final String SOURCE_CLASSIFIER = "sources";
    DependencyStatusSets results;

    public void execute() throws MojoExecutionException {
        this.classifier = SOURCE_CLASSIFIER;
        this.type = SOURCE_TYPE;
        this.results = this.getDependencySets(false);
        SourcesFileMarkerHandler handler = new SourcesFileMarkerHandler(this.markersDirectory);
        handler.setResolved(true);
        for (Artifact artifact : this.results.getResolvedDependencies()) {
            handler.setArtifact(artifact);
            handler.setMarker();
        }
        handler.setResolved(false);
        for (Artifact artifact : this.results.getUnResolvedDependencies()) {
            handler.setArtifact(artifact);
            handler.setMarker();
        }
        String output = this.results.getOutput(this.outputAbsoluteArtifactFilename, false);
        try {
            if (this.outputFile == null) {
                DependencyUtil.log(output, this.getLog());
            } else {
                DependencyUtil.write(output, this.outputFile, this.appendOutput, this.getLog());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new ResolveFileFilter(new SourcesFileMarkerHandler(this.markersDirectory));
    }
}

