/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.help.AbstractEffectiveMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class EffectivePomMojo
extends AbstractEffectiveMojo {
    private MavenProject project;
    private List projects;

    public void execute() throws MojoExecutionException {
        String effectivePom;
        StringWriter w = new StringWriter();
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, StringUtils.repeat((String)" ", (int)2), this.project.getModel().getModelEncoding(), null);
        EffectivePomMojo.writeHeader((XMLWriter)writer);
        if (this.projects.get(0).equals(this.project) && this.projects.size() > 1) {
            writer.startElement("projects");
            Iterator it = this.projects.iterator();
            while (it.hasNext()) {
                MavenProject subProject = (MavenProject)it.next();
                EffectivePomMojo.writeEffectivePom(subProject, (XMLWriter)writer);
            }
            writer.endElement();
            effectivePom = w.toString();
            effectivePom = EffectivePomMojo.prettyFormat(effectivePom);
        } else {
            EffectivePomMojo.writeEffectivePom(this.project, (XMLWriter)writer);
            effectivePom = w.toString();
        }
        if (this.output != null) {
            try {
                EffectivePomMojo.writeXmlFile(this.output, effectivePom, this.project.getModel().getModelEncoding());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write effective-POM to output: " + this.output, (Exception)e);
            }
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Effective-POM written to: " + this.output));
            }
        } else {
            StringBuffer message = new StringBuffer();
            message.append("\nEffective POMs, after inheritance, interpolation, and profiles are applied:\n\n");
            message.append(effectivePom);
            message.append("\n");
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)message.toString());
            }
        }
    }

    private static void writeEffectivePom(MavenProject project, XMLWriter writer) throws MojoExecutionException {
        Model pom = project.getModel();
        EffectivePomMojo.cleanModel(pom);
        StringWriter sWriter = new StringWriter();
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        try {
            pomWriter.write((Writer)sWriter, pom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot serialize POM to XML.", (Exception)e);
        }
        String effectivePom = EffectivePomMojo.addMavenNamespace(sWriter.toString(), true);
        EffectivePomMojo.writeComment(writer, "Effective POM for project '" + project.getId() + "'");
        writer.writeMarkup(effectivePom);
    }

    private static void cleanModel(Model pom) {
        AbstractEffectiveMojo.SortedProperties properties = new AbstractEffectiveMojo.SortedProperties();
        properties.putAll((Map<?, ?>)pom.getProperties());
        pom.setProperties((Properties)properties);
    }

    private static String prettyFormat(String effectivePom) {
        SAXBuilder builder = new SAXBuilder();
        try {
            Document effectiveDocument = builder.build((Reader)new StringReader(effectivePom));
            StringWriter w = new StringWriter();
            Format format = Format.getPrettyFormat();
            XMLOutputter out = new XMLOutputter(format);
            out.output(effectiveDocument, (Writer)w);
            return w.toString();
        }
        catch (JDOMException e) {
            return effectivePom;
        }
        catch (IOException e) {
            return effectivePom;
        }
    }
}

