/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Notifier;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public class CimReport
extends AbstractProjectInfoReport {
    public String getName(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.cim.name");
    }

    public String getDescription(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.cim.description");
    }

    public void executeReport(Locale locale) {
        CimRenderer r = new CimRenderer(this.getSink(), this.getProject().getModel(), this.i18n, locale);
        r.render();
    }

    public String getOutputName() {
        return "integration";
    }

    private static class CimRenderer
    extends AbstractMavenReportRenderer {
        private Model model;
        private I18N i18n;
        private Locale locale;

        CimRenderer(Sink sink, Model model, I18N i18n, Locale locale) {
            super(sink);
            this.model = model;
            this.i18n = i18n;
            this.locale = locale;
        }

        public String getTitle() {
            return this.i18n.getString("project-info-report", this.locale, "report.cim.title");
        }

        public void renderBody() {
            CiManagement cim = this.model.getCiManagement();
            if (cim == null) {
                this.startSection(this.getTitle());
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.cim.nocim"));
                this.endSection();
                return;
            }
            String system = cim.getSystem();
            String url = cim.getUrl();
            List notifiers = cim.getNotifiers();
            this.startSection(this.i18n.getString("project-info-report", this.locale, "report.cim.overview.title"));
            if (this.isCimSystem(system, "continuum")) {
                this.linkPatternedText(this.i18n.getString("project-info-report", this.locale, "report.cim.continuum.intro"));
            } else if (this.isCimSystem(system, "bugzilla")) {
                this.linkPatternedText(this.i18n.getString("project-info-report", this.locale, "report.cim.bugzilla.intro"));
            } else {
                this.linkPatternedText(this.i18n.getString("project-info-report", this.locale, "report.cim.general.intro"));
            }
            this.endSection();
            this.startSection(this.i18n.getString("project-info-report", this.locale, "report.cim.access"));
            if (!StringUtils.isEmpty((String)url)) {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.cim.url"));
                this.verbatimLink(url, url);
            } else {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.cim.nourl"));
            }
            this.endSection();
            this.startSection(this.i18n.getString("project-info-report", this.locale, "report.cim.notifiers.title"));
            if (notifiers == null || notifiers.isEmpty()) {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.cim.notifiers.nolist"));
            } else {
                this.startTable();
                this.tableCaption(this.i18n.getString("project-info-report", this.locale, "report.cim.notifiers.intro"));
                String type = this.i18n.getString("project-info-report", this.locale, "report.cim.notifiers.column.type");
                String address = this.i18n.getString("project-info-report", this.locale, "report.cim.notifiers.column.address");
                String configuration = this.i18n.getString("project-info-report", this.locale, "report.cim.notifiers.column.configuration");
                this.tableHeader(new String[]{type, address, configuration});
                Iterator i = notifiers.iterator();
                while (i.hasNext()) {
                    Notifier notifier = (Notifier)i.next();
                    this.tableRow(new String[]{notifier.getType(), CimRenderer.createLinkPatternedText((String)notifier.getAddress(), (String)notifier.getAddress()), CimRenderer.propertiesToString((Properties)notifier.getConfiguration())});
                }
                this.endTable();
            }
            this.endSection();
        }

        private boolean isCimSystem(String connection, String cim) {
            if (StringUtils.isEmpty((String)connection)) {
                return false;
            }
            if (StringUtils.isEmpty((String)cim)) {
                return false;
            }
            return connection.toLowerCase().startsWith(cim.toLowerCase());
        }
    }
}

