/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.report.projectinfo.ReportResolutionListener;
import org.apache.maven.reporting.AbstractMavenReportRenderer;

public class DependenciesReport
extends AbstractProjectInfoReport {
    private MavenProjectBuilder mavenProjectBuilder;
    protected ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector collector;

    public String getName(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.dependencies.name");
    }

    public String getDescription(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.dependencies.description");
    }

    public void executeReport(Locale locale) {
        ReportResolutionListener listener = this.resolveProject();
        DependenciesRenderer r = new DependenciesRenderer(this.getSink(), locale, listener);
        r.render();
    }

    private ReportResolutionListener resolveProject() {
        Map managedVersions = null;
        try {
            managedVersions = this.createManagedVersionMap(this.project.getId(), this.project.getDependencyManagement());
        }
        catch (ProjectBuildingException e) {
            this.getLog().error((CharSequence)"An error occurred while resolving project dependencies.", (Throwable)e);
        }
        ReportResolutionListener listener = new ReportResolutionListener();
        try {
            this.collector.collect(this.project.getDependencyArtifacts(), this.project.getArtifact(), managedVersions, this.localRepository, this.project.getRemoteArtifactRepositories(), this.artifactMetadataSource, null, Collections.singletonList(listener));
        }
        catch (ArtifactResolutionException e) {
            this.getLog().error((CharSequence)"An error occurred while resolving project dependencies.", (Throwable)e);
        }
        return listener;
    }

    private Map createManagedVersionMap(String projectId, DependencyManagement dependencyManagement) throws ProjectBuildingException {
        HashMap<String, Artifact> map;
        if (dependencyManagement != null && dependencyManagement.getDependencies() != null) {
            map = new HashMap<String, Artifact>();
            Iterator i = dependencyManagement.getDependencies().iterator();
            while (i.hasNext()) {
                Dependency d = (Dependency)i.next();
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                    Artifact artifact = this.factory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope());
                    map.put(d.getManagementKey(), artifact);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new ProjectBuildingException(projectId, "Unable to parse version '" + d.getVersion() + "' for dependency '" + d.getManagementKey() + "': " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    public String getOutputName() {
        return "dependencies";
    }

    private class DependenciesRenderer
    extends AbstractMavenReportRenderer {
        private final Locale locale;
        private final ReportResolutionListener listener;

        DependenciesRenderer(Sink sink, Locale locale, ReportResolutionListener listener) {
            super(sink);
            this.locale = locale;
            this.listener = listener;
        }

        public String getTitle() {
            return this.getReportString("report.dependencies.title");
        }

        public void renderBody() {
            List dependencies = this.listener.getRootNode().getChildren();
            if (dependencies.isEmpty()) {
                this.startSection(this.getTitle());
                this.paragraph(this.getReportString("report.dependencies.nolist"));
                this.endSection();
                return;
            }
            this.startSection(this.getTitle());
            String groupId = this.getReportString("report.dependencies.column.groupId");
            String artifactId = this.getReportString("report.dependencies.column.artifactId");
            String version = this.getReportString("report.dependencies.column.version");
            String classifier = this.getReportString("report.dependencies.column.classifier");
            String type = this.getReportString("report.dependencies.column.type");
            String optional = this.getReportString("report.dependencies.column.optional");
            String[] tableHeader = new String[]{groupId, artifactId, version, classifier, type, optional};
            Map dependenciesByScope = this.getDependenciesByScope(dependencies);
            this.renderDependenciesForScope("compile", (List)dependenciesByScope.get("compile"), tableHeader);
            this.renderDependenciesForScope("runtime", (List)dependenciesByScope.get("runtime"), tableHeader);
            this.renderDependenciesForScope("test", (List)dependenciesByScope.get("test"), tableHeader);
            this.renderDependenciesForScope("provided", (List)dependenciesByScope.get("provided"), tableHeader);
            this.renderDependenciesForScope("system", (List)dependenciesByScope.get("system"), tableHeader);
            this.endSection();
            ArrayList artifacts = new ArrayList(this.listener.getArtifacts());
            artifacts.removeAll(dependencies);
            this.startSection(this.getReportString("report.transitivedependencies.title"));
            if (artifacts.isEmpty()) {
                this.paragraph(this.getReportString("report.transitivedependencies.nolist"));
            } else {
                this.paragraph(this.getReportString("report.transitivedependencies.intro"));
                dependenciesByScope = this.getDependenciesByScope(artifacts);
                this.renderDependenciesForScope("compile", (List)dependenciesByScope.get("compile"), tableHeader);
                this.renderDependenciesForScope("runtime", (List)dependenciesByScope.get("runtime"), tableHeader);
                this.renderDependenciesForScope("test", (List)dependenciesByScope.get("test"), tableHeader);
                this.renderDependenciesForScope("provided", (List)dependenciesByScope.get("provided"), tableHeader);
                this.renderDependenciesForScope("system", (List)dependenciesByScope.get("system"), tableHeader);
            }
            this.endSection();
            this.startSection(this.getReportString("report.dependencies.graph.title"));
            this.startSection(this.getReportString("report.dependencies.graph.tree.title"));
            this.sink.paragraph();
            this.sink.list();
            this.printDependencyListing(this.listener.getRootNode());
            this.sink.list_();
            this.sink.paragraph_();
            this.endSection();
            this.startSection(this.getReportString("report.dependencies.graph.tables.title"));
            this.printDescriptionsAndURLs(this.listener.getRootNode());
            this.endSection();
            this.endSection();
        }

        private Map getDependenciesByScope(List dependencies) {
            HashMap<String, ArrayList<Artifact>> dependenciesByScope = new HashMap<String, ArrayList<Artifact>>();
            Iterator i = dependencies.iterator();
            while (i.hasNext()) {
                ReportResolutionListener.Node node = (ReportResolutionListener.Node)i.next();
                Artifact artifact = node.getArtifact();
                ArrayList<Artifact> multiValue = (ArrayList<Artifact>)dependenciesByScope.get(artifact.getScope());
                if (multiValue == null) {
                    multiValue = new ArrayList<Artifact>();
                }
                multiValue.add(artifact);
                dependenciesByScope.put(artifact.getScope(), multiValue);
            }
            return dependenciesByScope;
        }

        private void renderDependenciesForScope(String scope, List artifacts, String[] tableHeader) {
            if (artifacts != null) {
                Collections.sort(artifacts, this.getArtifactComparator());
                this.startSection(scope);
                this.paragraph(this.getReportString("report.dependencies.intro." + scope));
                this.startTable();
                this.tableHeader(tableHeader);
                Iterator iterator = artifacts.iterator();
                while (iterator.hasNext()) {
                    Artifact artifact = (Artifact)iterator.next();
                    this.tableRow(this.getArtifactRow(artifact));
                }
                this.endTable();
                this.endSection();
            }
        }

        private Comparator getArtifactComparator() {
            return new Comparator(){

                public int compare(Object o1, Object o2) {
                    Artifact a1 = (Artifact)o1;
                    Artifact a2 = (Artifact)o2;
                    if (a1.isOptional() && !a2.isOptional()) {
                        return 1;
                    }
                    if (!a1.isOptional() && a2.isOptional()) {
                        return -1;
                    }
                    return a1.compareTo((Object)a2);
                }
            };
        }

        private String[] getArtifactRow(Artifact artifact) {
            return new String[]{artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getClassifier(), artifact.getType(), artifact.isOptional() ? "(optional)" : " "};
        }

        private void printDependencyListing(ReportResolutionListener.Node node) {
            Artifact artifact = node.getArtifact();
            String id = artifact.getDependencyConflictId();
            this.sink.listItem();
            this.sink.paragraph();
            this.sink.link("#" + id);
            this.sink.text(id);
            this.sink.link_();
            if (!node.getChildren().isEmpty()) {
                this.sink.list();
                Iterator deps = node.getChildren().iterator();
                while (deps.hasNext()) {
                    ReportResolutionListener.Node dep = (ReportResolutionListener.Node)deps.next();
                    this.printDependencyListing(dep);
                }
                this.sink.list_();
            }
            this.sink.paragraph_();
            this.sink.listItem_();
        }

        private void printDescriptionsAndURLs(ReportResolutionListener.Node node) {
            Artifact artifact = node.getArtifact();
            String id = artifact.getDependencyConflictId();
            if (!"system".equals(artifact.getScope())) {
                try {
                    MavenProject artifactProject = this.getMavenProjectFromRepository(artifact, DependenciesReport.this.localRepository);
                    String artifactDescription = artifactProject.getDescription();
                    String artifactUrl = artifactProject.getUrl();
                    String artifactName = artifactProject.getName();
                    this.sink.paragraph();
                    this.sink.anchor(id);
                    this.sink.bold();
                    this.sink.text(artifactName);
                    this.sink.bold_();
                    this.sink.anchor_();
                    this.sink.paragraph_();
                    if (artifactDescription != null) {
                        this.sink.paragraph();
                        this.sink.text(artifactDescription);
                        this.sink.paragraph_();
                    }
                    if (artifactUrl != null) {
                        this.sink.paragraph();
                        this.sink.link(artifactUrl);
                        this.sink.text(artifactUrl);
                        this.sink.link_();
                        this.sink.paragraph_();
                    }
                }
                catch (ProjectBuildingException e) {
                    DependenciesReport.this.getLog().debug((Throwable)e);
                }
                Iterator deps = node.getChildren().iterator();
                while (deps.hasNext()) {
                    ReportResolutionListener.Node dep = (ReportResolutionListener.Node)deps.next();
                    this.printDescriptionsAndURLs(dep);
                }
            } else {
                this.sink.paragraph();
                this.sink.anchor(id);
                this.sink.bold();
                this.sink.text(id);
                this.sink.bold_();
                this.sink.anchor_();
                this.sink.paragraph_();
                this.sink.paragraph();
                this.sink.text(artifact.getFile().toString());
                this.sink.paragraph_();
            }
        }

        private MavenProject getMavenProjectFromRepository(Artifact artifact, ArtifactRepository localRepository) throws ProjectBuildingException {
            Artifact projectArtifact = artifact;
            boolean allowStubModel = false;
            if (!"pom".equals(artifact.getType())) {
                projectArtifact = DependenciesReport.this.factory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope());
                allowStubModel = true;
            }
            return DependenciesReport.this.mavenProjectBuilder.buildFromRepository(projectArtifact, DependenciesReport.this.project.getRemoteArtifactRepositories(), localRepository, allowStubModel);
        }

        private String getReportString(String key) {
            return DependenciesReport.this.i18n.getString("project-info-report", this.locale, key);
        }
    }
}

