/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;

public class ProjectIndexPageReport
extends AbstractProjectInfoReport {
    private List reports;

    public String getName(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.index.title");
    }

    public String getDescription(Locale locale) {
        String desc = this.project.getDescription() != null ? this.project.getDescription() : this.i18n.getString("project-info-report", locale, "report.index.nodescription");
        return desc;
    }

    public void executeReport(Locale locale) {
        ProjectIndexRenderer r = new ProjectIndexRenderer(this.getName(locale), this.project.getName(), this.getDescription(locale), this.getSink());
        r.render();
    }

    public String getOutputName() {
        return "index";
    }

    private static class ProjectIndexRenderer
    extends AbstractMavenReportRenderer {
        private final String title;
        private final String description;
        private final String name;

        ProjectIndexRenderer(String title, String name, String description, Sink sink) {
            super(sink);
            this.title = title;
            this.description = description;
            this.name = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void renderBody() {
            this.startSection(this.title.trim() + " " + this.name);
            this.paragraph(this.description);
            this.endSection();
        }
    }
}

