/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.report.projectinfo.dependencies.Dependencies;
import org.apache.maven.report.projectinfo.dependencies.DependenciesReportConfiguration;
import org.apache.maven.report.projectinfo.dependencies.RepositoryUtils;
import org.apache.maven.report.projectinfo.dependencies.renderer.DependenciesRenderer;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.jar.classes.JarClassesAnalysis;
import org.codehaus.plexus.util.IOUtil;

public class DependenciesReport
extends AbstractProjectInfoReport {
    private static final String RESOURCES_DIR = "org/apache/maven/report/projectinfo/resources";
    private MavenProjectBuilder mavenProjectBuilder;
    protected ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector collector;
    private WagonManager wagonManager;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private JarClassesAnalysis classesAnalyzer;
    private RepositoryMetadataManager repositoryMetadataManager;
    private ArtifactFactory artifactFactory;
    private boolean dependencyDetailsEnabled;
    private boolean dependencyLocationsEnabled;

    public void executeReport(Locale locale) {
        if (this.settings.isOffline() && this.dependencyLocationsEnabled) {
            this.getLog().warn((CharSequence)"The parameter 'dependencyLocationsEnabled' is ignored in offline mode.");
            this.dependencyLocationsEnabled = false;
        }
        try {
            this.copyResources(new File(this.getOutputDirectory()));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Cannot copy ressources", (Throwable)e);
        }
        RepositoryUtils repoUtils = new RepositoryUtils(this.getLog(), this.wagonManager, this.settings, this.mavenProjectBuilder, this.factory, this.resolver, this.project.getRemoteArtifactRepositories(), this.project.getPluginArtifactRepositories(), this.localRepository, this.repositoryMetadataManager);
        DependencyNode dependencyTreeNode = this.resolveProject();
        Dependencies dependencies = new Dependencies(this.project, dependencyTreeNode, this.classesAnalyzer);
        DependenciesReportConfiguration config = new DependenciesReportConfiguration(this.dependencyDetailsEnabled, this.dependencyLocationsEnabled);
        DependenciesRenderer r = new DependenciesRenderer(this.getSink(), locale, this.getI18N(locale), this.getLog(), this.settings, dependencies, dependencyTreeNode, config, repoUtils, this.artifactFactory, this.mavenProjectBuilder, this.remoteRepositories, this.localRepository);
        r.render();
    }

    public String getOutputName() {
        return "dependencies";
    }

    protected String getI18Nsection() {
        return "dependencies";
    }

    private DependencyNode resolveProject() {
        try {
            ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("test");
            return this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepository, this.factory, this.artifactMetadataSource, (ArtifactFilter)artifactFilter, this.collector);
        }
        catch (DependencyTreeBuilderException e) {
            this.getLog().error((CharSequence)"Unable to build dependency tree.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResources(File outputDirectory) throws IOException {
        LineNumberReader reader;
        InputStream resourceList;
        block8: {
            resourceList = null;
            reader = null;
            try {
                resourceList = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/maven/report/projectinfo/resources/resources.txt");
                if (resourceList == null) break block8;
                reader = new LineNumberReader(new InputStreamReader(resourceList, "US-ASCII"));
                String line = reader.readLine();
                while (line != null) {
                    InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/maven/report/projectinfo/resources/" + line);
                    if (is == null) {
                        throw new IOException("The resource " + line + " doesn't exist.");
                    }
                    File outputFile = new File(outputDirectory, line);
                    if (!outputFile.getParentFile().exists()) {
                        outputFile.getParentFile().mkdirs();
                    }
                    FileOutputStream w = null;
                    try {
                        w = new FileOutputStream(outputFile);
                        IOUtil.copy((InputStream)is, (OutputStream)w);
                    }
                    finally {
                        IOUtil.close((InputStream)is);
                        IOUtil.close((OutputStream)w);
                    }
                    line = reader.readLine();
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(resourceList);
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)resourceList);
        IOUtil.close(reader);
    }
}

