/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.FileUtils;

public class CheckoutMojo
extends AbstractScmMojo {
    private File checkoutDirectory;
    private boolean skipCheckoutIfExists = false;
    private String scmVersionType;
    private String scmVersion;
    private CheckOutScmResult checkoutResult;

    public void execute() throws MojoExecutionException {
        super.execute();
        this.checkoutResult = null;
        if (!this.getCheckoutDirectory().isDirectory() || !this.skipCheckoutIfExists) {
            this.checkoutResult = this.checkout();
        }
    }

    protected File getCheckoutDirectory() {
        return this.checkoutDirectory;
    }

    public void setCheckoutDirectory(File checkoutDirectory) {
        this.checkoutDirectory = checkoutDirectory;
    }

    protected CheckOutScmResult checkout() throws MojoExecutionException {
        try {
            ScmRepository repository = this.getScmRepository();
            try {
                this.getLog().info((CharSequence)("Removing " + this.getCheckoutDirectory()));
                FileUtils.deleteDirectory((File)this.getCheckoutDirectory());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot remove " + this.getCheckoutDirectory());
            }
            if (!this.getCheckoutDirectory().mkdirs()) {
                throw new MojoExecutionException("Cannot create " + this.getCheckoutDirectory());
            }
            CheckOutScmResult result = this.getScmManager().checkOut(repository, new ScmFileSet(this.getCheckoutDirectory().getAbsoluteFile()), this.getScmVersion(this.scmVersionType, this.scmVersion));
            this.checkResult((ScmResult)result);
            return result;
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Cannot run checkout command : ", (Exception)((Object)e));
        }
    }

    protected CheckOutScmResult getCheckoutResult() {
        return this.checkoutResult;
    }
}

