/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.tag;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.tag.PerforceTagConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceTagCommand
extends AbstractTagCommand
implements PerforceCommand {
    private static final String NEWLINE = "\r\n";

    protected ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet files, String tag) throws ScmException {
        PerforceTagConsumer consumer = new PerforceTagConsumer();
        this.createLabel(repo, files, tag, consumer);
        if (consumer.isSuccess()) {
            this.syncLabel(repo, files, tag, consumer);
        }
        if (consumer.isSuccess()) {
            return new TagScmResult("p4 label -i", consumer.getTagged());
        }
        return new TagScmResult("p4 label -i", "Tag failed", consumer.getOutput(), false);
    }

    private void syncLabel(ScmProviderRepository repo, ScmFileSet files, String tag, PerforceTagConsumer consumer) {
        Commandline cl = PerforceTagCommand.createLabelsyncCommandLine((PerforceScmProviderRepository)repo, files.getBasedir(), files, tag);
        try {
            this.getLogger().debug(PerforceScmProvider.clean("Executing: " + cl.toString()));
            Process proc = cl.execute();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                this.getLogger().debug("Consuming: " + line);
                consumer.consumeLine(line);
            }
        }
        catch (CommandLineException e) {
            this.getLogger().error((Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error((Throwable)e);
        }
    }

    private void createLabel(ScmProviderRepository repo, ScmFileSet files, String tag, PerforceTagConsumer consumer) {
        Commandline cl = PerforceTagCommand.createLabelCommandLine((PerforceScmProviderRepository)repo, files.getBasedir(), files, tag);
        try {
            this.getLogger().debug(PerforceScmProvider.clean("Executing: " + cl.toString()));
            Process proc = cl.execute();
            OutputStream out = proc.getOutputStream();
            DataOutputStream dos = new DataOutputStream(out);
            String label = PerforceTagCommand.createLabelSpecification((PerforceScmProviderRepository)repo, files, tag);
            dos.write(label.getBytes());
            dos.close();
            out.close();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                this.getLogger().debug("Consuming: " + line);
                consumer.consumeLine(line);
            }
        }
        catch (CommandLineException e) {
            this.getLogger().error((Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error((Throwable)e);
        }
    }

    public static Commandline createLabelCommandLine(PerforceScmProviderRepository repo, File workingDirectory, ScmFileSet files, String tag) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArgument().setValue("label");
        command.createArgument().setValue("-i");
        return command;
    }

    public static Commandline createLabelsyncCommandLine(PerforceScmProviderRepository repo, File workingDirectory, ScmFileSet files, String tag) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArgument().setValue("labelsync");
        command.createArgument().setValue("-l");
        command.createArgument().setValue(tag);
        try {
            String candir = workingDirectory.getCanonicalPath();
            File[] fs = files.getFiles();
            for (int i = 0; i < fs.length; ++i) {
                File file = fs[i];
                String canfile = file.getCanonicalPath();
                if (canfile.startsWith(candir)) {
                    canfile = canfile.substring(candir.length() + 1);
                }
                command.createArgument().setValue(file.getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return command;
    }

    public static String createLabelSpecification(PerforceScmProviderRepository repo, ScmFileSet files, String tag) {
        StringBuffer buf = new StringBuffer();
        buf.append("Label: ").append(tag).append(NEWLINE);
        buf.append("View: ").append(PerforceScmProvider.getCanonicalRepoPath(repo.getPath())).append(NEWLINE);
        return buf.toString();
    }
}

