/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.command.checkout;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.starteam.command.StarteamCommand;
import org.apache.maven.scm.provider.starteam.command.StarteamCommandLineUtils;
import org.apache.maven.scm.provider.starteam.command.checkout.StarteamCheckOutConsumer;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class StarteamCheckOutCommand
extends AbstractCheckOutCommand
implements StarteamCommand {
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag) throws ScmException {
        if (fileSet.getFiles().length != 0) {
            throw new ScmException("This provider doesn't support checking out subsets of a directory");
        }
        this.getLogger().info("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        StarteamScmProviderRepository repository = (StarteamScmProviderRepository)repo;
        StarteamCheckOutConsumer consumer = new StarteamCheckOutConsumer(this.getLogger(), fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        Commandline cl = StarteamCheckOutCommand.createCommandLine(repository, fileSet.getBasedir(), tag);
        int exitCode = StarteamCommandLineUtils.executeCommandline(cl, consumer, stderr, this.getLogger());
        if (exitCode != 0) {
            return new CheckOutScmResult(cl.toString(), "The starteam command failed.", stderr.getOutput(), false);
        }
        return new CheckOutScmResult(cl.toString(), consumer.getCheckedOutFiles());
    }

    public static Commandline createCommandLine(StarteamScmProviderRepository repo, File workingDirectory, String tag) {
        Commandline cl = StarteamCommandLineUtils.createStarteamBaseCommandLine("co", workingDirectory, repo);
        if (tag != null && tag.trim().length() != 0) {
            cl.createArgument().setValue("-vl");
            cl.createArgument().setValue(tag);
        }
        cl.createArgument().setValue("-is");
        return cl;
    }
}

