/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn;

import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.AbstractScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.util.EntriesReader;
import org.apache.maven.scm.provider.svn.util.Entry;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.scm.repository.UnknownRepositoryStructure;

public abstract class AbstractSvnScmProvider
extends AbstractScmProvider {
    public String getScmSpecificFilename() {
        return ".svn";
    }

    public ScmProviderRepository makeProviderScmRepository(String scmSpecificUrl, char delimiter) throws ScmRepositoryException {
        ScmUrlParserResult result = this.parseScmUrl(scmSpecificUrl);
        if (result.messages.size() > 0) {
            throw new ScmRepositoryException("The scm url is invalid.", result.messages);
        }
        return result.repository;
    }

    public ScmProviderRepository makeProviderScmRepository(File path) throws ScmRepositoryException, UnknownRepositoryStructure {
        if (path == null || !path.isDirectory()) {
            throw new ScmRepositoryException(path.getAbsolutePath() + " isn't a valid directory.");
        }
        File svnDirectory = new File(path, ".svn");
        if (!svnDirectory.exists()) {
            throw new ScmRepositoryException(path.getAbsolutePath() + " isn't a svn checkout directory.");
        }
        File svnEntriesFile = new File(svnDirectory, "entries");
        String svnUrl = null;
        try {
            FileReader reader = new FileReader(svnEntriesFile);
            EntriesReader entriesReader = new EntriesReader();
            List entries = entriesReader.read(reader);
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                Entry svnEntry = (Entry)i.next();
                if (!"".equals(svnEntry.getName())) continue;
                svnUrl = svnEntry.getUrl();
            }
        }
        catch (Exception e) {
            ScmRepositoryException ex = new ScmRepositoryException("Can't read " + svnEntriesFile.getAbsolutePath());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
        return this.makeProviderScmRepository(svnUrl, ':');
    }

    public List validateScmUrl(String scmSpecificUrl, char delimiter) {
        List messages = new ArrayList();
        try {
            this.makeProviderScmRepository(scmSpecificUrl, delimiter);
        }
        catch (ScmRepositoryException e) {
            messages = e.getValidationMessages();
        }
        return messages;
    }

    public String getScmType() {
        return "svn";
    }

    private ScmUrlParserResult parseScmUrl(String scmSpecificUrl) {
        ScmUrlParserResult result = new ScmUrlParserResult();
        String url = scmSpecificUrl;
        if (url.startsWith("file")) {
            if (!url.startsWith("file:///") && !url.startsWith("file://localhost/")) {
                result.messages.add("A svn 'file' url must be on the form 'file:///' or 'file://localhost/'.");
                return result;
            }
        } else if (url.startsWith("https")) {
            if (!url.startsWith("https://")) {
                result.messages.add("A svn 'http' url must be on the form 'https://'.");
                return result;
            }
        } else if (url.startsWith("http")) {
            if (!url.startsWith("http://")) {
                result.messages.add("A svn 'http' url must be on the form 'http://'.");
                return result;
            }
        } else if (url.startsWith("svn+ssh")) {
            if (!url.startsWith("svn+ssh://")) {
                result.messages.add("A svn 'svn+ssh' url must be on the form 'svn+ssh://'.");
                return result;
            }
        } else if (url.startsWith("svn")) {
            if (!url.startsWith("svn://")) {
                result.messages.add("A svn 'svn' url must be on the form 'svn://'.");
                return result;
            }
        } else {
            result.messages.add(url + " url isn't a valid svn URL.");
            return result;
        }
        result.repository = new SvnScmProviderRepository(url);
        return result;
    }

    protected abstract SvnCommand getAddCommand();

    public AddScmResult add(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (AddScmResult)this.executeCommand(this.getAddCommand(), repository, fileSet, parameters);
    }

    protected abstract SvnCommand getChangeLogCommand();

    public ChangeLogScmResult changelog(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (ChangeLogScmResult)this.executeCommand(this.getChangeLogCommand(), repository, fileSet, parameters);
    }

    protected abstract SvnCommand getCheckInCommand();

    public CheckInScmResult checkin(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (CheckInScmResult)this.executeCommand(this.getCheckInCommand(), repository, fileSet, parameters);
    }

    protected abstract SvnCommand getCheckOutCommand();

    public CheckOutScmResult checkout(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (CheckOutScmResult)this.executeCommand(this.getCheckOutCommand(), repository, fileSet, parameters);
    }

    protected abstract SvnCommand getDiffCommand();

    public DiffScmResult diff(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (DiffScmResult)this.executeCommand(this.getDiffCommand(), repository, fileSet, parameters);
    }

    protected abstract SvnCommand getRemoveCommand();

    public RemoveScmResult remove(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (RemoveScmResult)this.executeCommand(this.getRemoveCommand(), repository, fileSet, parameters);
    }

    protected abstract SvnCommand getStatusCommand();

    public StatusScmResult status(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (StatusScmResult)this.executeCommand(this.getStatusCommand(), repository, fileSet, parameters);
    }

    protected abstract SvnCommand getTagCommand();

    public TagScmResult tag(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (TagScmResult)this.executeCommand(this.getTagCommand(), repository, fileSet, parameters);
    }

    protected abstract SvnCommand getUpdateCommand();

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (UpdateScmResult)this.executeCommand(this.getUpdateCommand(), repository, fileSet, parameters);
    }

    protected ScmResult executeCommand(SvnCommand command, ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        command.setLogger(this.getLogger());
        return command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    private static class ScmUrlParserResult {
        List messages = new ArrayList();
        ScmProviderRepository repository;

        private ScmUrlParserResult() {
        }
    }
}

