/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.repository;

import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;

public class SvnScmProviderRepository
extends ScmProviderRepositoryWithHost {
    private String url;
    private String tagBase;

    public SvnScmProviderRepository(String url) {
        this.parseUrl(url);
    }

    public SvnScmProviderRepository(String url, String user, String password) {
        this(url);
        this.setUser(user);
        this.setPassword(password);
    }

    public String getUrl() {
        return this.url;
    }

    public String getTagBase() {
        return this.tagBase;
    }

    public void setTagBase(String tagBase) {
        this.tagBase = tagBase;
    }

    private void parseUrl(String url) {
        String protocol = null;
        if (url.startsWith("file")) {
            protocol = "file://";
        } else if (url.startsWith("https")) {
            protocol = "https://";
        } else if (url.startsWith("http")) {
            protocol = "http://";
        } else if (url.startsWith("svn+ssh")) {
            protocol = "svn+ssh://";
        } else if (url.startsWith("svn")) {
            protocol = "svn://";
        }
        if (protocol == null) {
            return;
        }
        String urlPath = url.substring(protocol.length());
        int indexAt = urlPath.indexOf("@");
        if (indexAt > 0 && !"svn+ssh://".equals(protocol)) {
            this.setUser(urlPath.substring(0, indexAt));
            urlPath = urlPath.substring(indexAt + 1);
            this.url = protocol + urlPath;
        } else {
            this.url = protocol + urlPath;
        }
        if (!"file://".equals(protocol)) {
            int indexColon;
            int indexSlash = urlPath.indexOf("/");
            String hostPort = urlPath;
            if (indexSlash > 0) {
                hostPort = urlPath.substring(0, indexSlash);
            }
            if ((indexColon = hostPort.indexOf(":")) > 0) {
                this.setHost(hostPort.substring(0, indexColon));
                this.setPort(Integer.parseInt(hostPort.substring(indexColon + 1)));
            } else {
                this.setHost(hostPort);
            }
        }
    }

    public String toString() {
        return this.getUrl();
    }
}

