/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.resolver.bod.binary;

import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.resolver.bod.BuildOnDemandResolutionException;
import org.codehaus.mojo.resolver.bod.binary.AbstractOSBinaryDependencyManager;
import org.codehaus.mojo.tools.rpm.RpmFormattingException;
import org.codehaus.mojo.tools.rpm.RpmInfoFormatter;
import org.codehaus.mojo.tools.rpm.RpmInstallException;
import org.codehaus.mojo.tools.rpm.RpmMediator;
import org.codehaus.mojo.tools.rpm.RpmQueryException;

public class RpmBinaryDependencyManager
extends AbstractOSBinaryDependencyManager {
    private RpmInfoFormatter rpmInfoFormatter;
    private RpmMediator rpmMediator;
    private String rpmDbPath;
    private boolean forceAllInstalls = true;

    protected boolean installDependencyOnSystem(MavenProject project) throws BuildOnDemandResolutionException {
        String rpmName;
        String dbPath = this.getDbPath(project);
        try {
            rpmName = this.rpmInfoFormatter.formatRpmNameWithoutVersion(project);
        }
        catch (RpmFormattingException e) {
            throw new BuildOnDemandResolutionException("Failed to format RPM name from project: " + project.getId(), e);
        }
        try {
            if (this.forceAllInstalls || !this.rpmMediator.isRpmInstalled(rpmName, project.getVersion(), dbPath)) {
                Artifact artifact = project.getArtifact();
                this.rpmMediator.install(rpmName, artifact.getFile(), dbPath, this.forceAllInstalls);
            }
        }
        catch (RpmQueryException e) {
            throw new BuildOnDemandResolutionException("Error querying for the existence of: " + rpmName + " in RPM database: " + dbPath, e);
        }
        catch (RpmInstallException e) {
            throw new BuildOnDemandResolutionException("Failed to install RPM dependency: " + rpmName + " for project: " + project.getId() + " in RPM database: " + dbPath, e);
        }
        return true;
    }

    private String getDbPath(MavenProject project) {
        Properties properties = project.getProperties();
        String dbPath = this.rpmDbPath;
        if (dbPath == "" && properties != null) {
            dbPath = properties.getProperty("rpmDbPath");
            this.getLogger().debug("Using RPM database path from POM: '" + dbPath + "'.");
        } else {
            this.getLogger().debug("Using RPM database path from plugin parameter: '" + dbPath + "'.");
        }
        return dbPath;
    }

    protected boolean isDependencyInstalledOnSystem(MavenProject project) throws BuildOnDemandResolutionException {
        String rpmName;
        String dbPath = this.getDbPath(project);
        try {
            rpmName = this.rpmInfoFormatter.formatRpmNameWithoutVersion(project);
        }
        catch (RpmFormattingException e) {
            throw new BuildOnDemandResolutionException("Failed to format RPM name from project: " + project.getId(), e);
        }
        try {
            return this.rpmMediator.isRpmInstalled(rpmName, dbPath);
        }
        catch (RpmQueryException e) {
            throw new BuildOnDemandResolutionException("Failed to query RPM database: " + dbPath + " for: " + rpmName, e);
        }
    }
}

