/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.resolver.bod.pom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.DebugResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.resolver.WarningResolutionListener;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.io.logging.DefaultMessageHolder;
import org.apache.maven.shared.io.logging.MessageHolder;
import org.codehaus.mojo.resolver.bod.BuildOnDemandResolutionException;
import org.codehaus.mojo.resolver.bod.pom.DependencyPOMResolver;
import org.codehaus.mojo.tools.project.extras.ProjectReleaseInfoUtils;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDependencyPOMResolver
extends AbstractLogEnabled
implements DependencyPOMResolver {
    public static final String ROLE_HINT = "default";
    private ArtifactMetadataSource metadataSource;
    private MavenProjectBuilder projectBuilder;
    private ArtifactFactory artifactFactory;
    private ArtifactCollector artifactCollector;

    public DefaultDependencyPOMResolver(ArtifactMetadataSource metadataSource, MavenProjectBuilder projectBuilder, ArtifactFactory artifactFactory, ArtifactCollector artifactCollector, int logLevel) {
        this.metadataSource = metadataSource;
        this.projectBuilder = projectBuilder;
        this.artifactFactory = artifactFactory;
        this.artifactCollector = artifactCollector;
        this.enableLogging((Logger)new ConsoleLogger(logLevel, ROLE_HINT));
    }

    public DefaultDependencyPOMResolver() {
    }

    @Override
    public List<MavenProject> resolveDependencyPoms(MavenProject project, List<MavenProject> reactorProjects, ArtifactRepository localRepository, Set<String> previousBuilds) throws BuildOnDemandResolutionException {
        Set<String> completedBuilds = previousBuilds;
        if (completedBuilds == null) {
            completedBuilds = new HashSet<String>();
        }
        DefaultMessageHolder errors = new DefaultMessageHolder();
        this.getLogger().debug("Resolving build candidates from master project: " + project.getId());
        Map<String, MavenProject> buildCandidates = this.resolveBuildCandidateMap(project, localRepository, (MessageHolder)errors);
        if (!errors.isEmpty()) {
            throw new BuildOnDemandResolutionException("While collecting build candidates:\n\n" + errors.render());
        }
        if (buildCandidates == null || buildCandidates.isEmpty()) {
            return Collections.emptyList();
        }
        this.getLogger().debug("Removing builds which are already in progress...");
        this.removeBuildsInProgress(buildCandidates, reactorProjects);
        this.getLogger().debug("...done. Remaining build candidates: " + buildCandidates);
        this.getLogger().debug("Removing builds which have already completed elsewhere...");
        this.removeCompletedBuilds(buildCandidates, completedBuilds);
        this.getLogger().debug("...done. Remaining build candidates: " + buildCandidates);
        errors = new DefaultMessageHolder();
        if (!errors.isEmpty()) {
            throw new BuildOnDemandResolutionException("While removing build candidates with existing binary artifacts:\n\n" + errors.render());
        }
        if (buildCandidates.isEmpty()) {
            this.getLogger().info("Nothing to build for project: " + project.getId());
            return Collections.emptyList();
        }
        this.getLogger().info("Found " + buildCandidates.size() + " build candidates for project: " + project.getId());
        return new ArrayList<MavenProject>(buildCandidates.values());
    }

    protected void removeCompletedBuilds(Map<String, MavenProject> buildCandidates, Set<String> completedBuilds) {
        for (String id : completedBuilds) {
            buildCandidates.remove(id);
        }
    }

    protected Map<String, MavenProject> resolveBuildCandidateMap(MavenProject project, ArtifactRepository localRepository, MessageHolder errors) throws BuildOnDemandResolutionException {
        ArrayList<Object> listeners = new ArrayList<Object>();
        if (this.getLogger().isDebugEnabled()) {
            listeners.add(new DebugResolutionListener(this.getLogger()));
        }
        listeners.add(new WarningResolutionListener(this.getLogger()));
        ScopeArtifactFilter filter = new ScopeArtifactFilter("test");
        HashMap<String, MavenProject> dependencyPoms = new HashMap<String, MavenProject>();
        Artifact projectArtifact = project.getArtifact();
        if (projectArtifact == null) {
            projectArtifact = this.artifactFactory.createBuildArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), "pom");
        }
        this.getLogger().debug("Project artifact is: " + projectArtifact);
        Set dependencyArtifacts = project.getDependencyArtifacts();
        if (dependencyArtifacts == null) {
            try {
                dependencyArtifacts = project.createArtifacts(this.artifactFactory, null, (ArtifactFilter)filter);
            }
            catch (InvalidDependencyVersionException e) {
                errors.addMessage((CharSequence)("Failed to create dependency artifacts for: " + project.getId()), (Throwable)e);
                return Collections.emptyMap();
            }
        }
        int preResolveErrorSize = errors.size();
        ArtifactResolutionResult result = null;
        try {
            this.getLogger().debug("Direct dependencies: " + dependencyArtifacts);
            result = this.artifactCollector.collect(dependencyArtifacts, projectArtifact, localRepository, project.getRemoteArtifactRepositories(), this.metadataSource, (ArtifactFilter)filter, listeners);
        }
        catch (ArtifactResolutionException e) {
            this.getLogger().info("Failed to resolve dependency POMs for: " + project.getId());
            errors.addMessage((CharSequence)("Failed to resolve dependency POMs for: " + project.getId()), (Throwable)e);
        }
        if (errors.size() != preResolveErrorSize) {
            throw new BuildOnDemandResolutionException("Failed to resolve one or more dependency POMs.\n\n" + errors.render());
        }
        if (result != null) {
            dependencyPoms.putAll(this.createProjectInstances(result.getArtifactResolutionNodes(), localRepository, errors));
        }
        this.getLogger().debug("Resolved " + dependencyPoms.size() + " dependency POMs: " + dependencyPoms);
        return dependencyPoms;
    }

    private Set<Artifact> injectImpliedVersionRanges(Set<Artifact> dependencyArtifacts) throws InvalidVersionSpecificationException {
        LinkedHashSet<Artifact> results = new LinkedHashSet<Artifact>();
        if (dependencyArtifacts != null) {
            for (Artifact dependencyArtifact : dependencyArtifacts) {
                String version = dependencyArtifact.getVersion();
                version = ProjectReleaseInfoUtils.formatImpliedReleaseNumberVersionRanges((String)version);
                Artifact result = this.artifactFactory.createDependencyArtifact(dependencyArtifact.getGroupId(), dependencyArtifact.getArtifactId(), VersionRange.createFromVersionSpec((String)version), dependencyArtifact.getType(), dependencyArtifact.getClassifier(), dependencyArtifact.getScope(), null, dependencyArtifact.isOptional());
                result.setArtifactHandler(dependencyArtifact.getArtifactHandler());
                results.add(result);
            }
        }
        return results;
    }

    protected Map<String, MavenProject> createProjectInstances(Set<ResolutionNode> artifactResolutionNodes, ArtifactRepository localRepository, MessageHolder errors) {
        if (artifactResolutionNodes == null || artifactResolutionNodes.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, MavenProject> projectsByVersionlessId = new HashMap<String, MavenProject>(artifactResolutionNodes.size());
        for (ResolutionNode node : artifactResolutionNodes) {
            Artifact projectArtifact = node.getArtifact();
            List remoteRepositories = node.getRemoteRepositories();
            String id = ArtifactUtils.versionlessKey((Artifact)projectArtifact);
            try {
                MavenProject project = this.projectBuilder.buildFromRepository(projectArtifact, remoteRepositories, localRepository);
                projectsByVersionlessId.put(id, project);
            }
            catch (ProjectBuildingException e) {
                errors.addMessage((CharSequence)("Failed to build project: " + id), (Throwable)e);
            }
        }
        return projectsByVersionlessId;
    }

    protected void removeBuildsInProgress(Map<String, MavenProject> buildCandidatesByVersionlessId, List<MavenProject> currentProjects) {
        if (currentProjects == null || currentProjects.isEmpty()) {
            return;
        }
        for (MavenProject project : currentProjects) {
            buildCandidatesByVersionlessId.remove(ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId()));
        }
    }
}

