/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.build;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.log.ScmLogDispatcher;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.hg.HgUtils;
import org.apache.maven.scm.provider.hg.command.HgConsumer;
import org.codehaus.plexus.util.StringUtils;

public class HgChangeSetMojo
extends AbstractMojo {
    private ScmLogDispatcher logger = new ScmLogDispatcher();
    private MavenProject project;
    private File scmDirectory;

    private void checkResult(ScmResult result) throws MojoExecutionException {
        if (!result.isSuccess()) {
            this.getLog().debug((CharSequence)"Provider message:");
            this.getLog().debug((CharSequence)(result.getProviderMessage() == null ? "" : result.getProviderMessage()));
            this.getLog().debug((CharSequence)"Command output:");
            this.getLog().debug((CharSequence)(result.getCommandOutput() == null ? "" : result.getCommandOutput()));
            throw new MojoExecutionException("Command failed." + StringUtils.defaultString((Object)result.getProviderMessage()));
        }
    }

    public void execute() throws MojoExecutionException {
        try {
            String previousChangeSet = this.getChangeSetProperty();
            String previousChangeSetDate = this.getChangeSetDateProperty();
            if (previousChangeSet == null || previousChangeSetDate == null) {
                String changeSet = this.getChangeSet();
                String changeSetDate = this.getChangeSetDate();
                this.getLog().info((CharSequence)("Setting Mercurial Changeset: " + changeSet));
                this.getLog().info((CharSequence)("Setting Mercurial Changeset Date: " + changeSetDate));
                this.setChangeSetProperty(changeSet);
                this.setChangeSetDateProperty(changeSetDate);
            }
        }
        catch (ScmException e) {
            throw new MojoExecutionException("SCM Exception", (Exception)((Object)e));
        }
    }

    protected String getChangeSet() throws ScmException, MojoExecutionException {
        HgOutputConsumer consumer = new HgOutputConsumer((ScmLogger)this.logger);
        ScmResult result = HgUtils.execute((HgConsumer)consumer, (ScmLogger)this.logger, (File)this.scmDirectory, (String[])new String[]{"id", "-i"});
        this.checkResult(result);
        return consumer.getOutput();
    }

    protected String getChangeSetDate() throws ScmException, MojoExecutionException {
        HgOutputConsumer consumer = new HgOutputConsumer((ScmLogger)this.logger);
        ScmResult result = HgUtils.execute((HgConsumer)consumer, (ScmLogger)this.logger, (File)this.scmDirectory, (String[])new String[]{"log", "-r", ".", "--template", "\"{date|isodate}\""});
        this.checkResult(result);
        return consumer.getOutput();
    }

    protected String getChangeSetDateProperty() {
        return this.getProperty("changeSetDate");
    }

    protected String getChangeSetProperty() {
        return this.getProperty("changeSet");
    }

    protected String getProperty(String property) {
        return this.project.getProperties().getProperty(property);
    }

    private void setChangeSetDateProperty(String changeSetDate) {
        this.setProperty("changeSetDate", changeSetDate);
    }

    private void setChangeSetProperty(String changeSet) {
        this.setProperty("changeSet", changeSet);
    }

    private void setProperty(String property, String value) {
        if (value != null) {
            this.project.getProperties().put(property, value);
        }
    }

    private static class HgOutputConsumer
    extends HgConsumer {
        private String output;

        private HgOutputConsumer(ScmLogger logger) {
            super(logger);
        }

        public void doConsume(ScmFileStatus status, String line) {
            this.output = line;
        }

        private String getOutput() {
            return this.output;
        }
    }
}

