/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class AdaptNbVersion {
    public static final String TYPE_SPECIFICATION = "spec";
    public static final String TYPE_IMPLEMENTATION = "impl";
    private static final String SNAPSHOT = "SNAPSHOT";

    public static String adaptVersion(String version, Object type) {
        StringTokenizer tok = new StringTokenizer(version, ".");
        if (SNAPSHOT.equals(version) && TYPE_IMPLEMENTATION.equals(type)) {
            return "0.0.0." + AdaptNbVersion.generateSnapshotValue();
        }
        StringBuffer toReturn = new StringBuffer();
        while (tok.hasMoreTokens()) {
            int snapshotIndex;
            String token = tok.nextToken();
            if (TYPE_IMPLEMENTATION.equals(type) && (snapshotIndex = token.indexOf(SNAPSHOT)) > 0) {
                String repl = token.substring(0, snapshotIndex) + AdaptNbVersion.generateSnapshotValue();
                if (token.length() > snapshotIndex + SNAPSHOT.length()) {
                    repl = token.substring(snapshotIndex + SNAPSHOT.length());
                }
                token = repl;
            }
            if (TYPE_SPECIFICATION.equals(type)) {
                if (token.indexOf(45) > 0) {
                    token = token.substring(0, token.indexOf(45));
                } else if (token.indexOf(95) > 0) {
                    token = token.substring(0, token.indexOf(95));
                }
                try {
                    Integer intValue = Integer.valueOf(token);
                    token = intValue.toString();
                }
                catch (NumberFormatException exc) {
                    token = "";
                }
            }
            if (token.length() <= 0) continue;
            if (toReturn.length() != 0) {
                toReturn.append(".");
            }
            toReturn.append(token);
        }
        if (toReturn.length() == 0) {
            toReturn.append("0.0.0");
        }
        return toReturn.toString();
    }

    private static String generateSnapshotValue() {
        return new SimpleDateFormat("yyyyMMdd").format(new Date());
    }
}

