/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.GenerateKey;
import org.apache.tools.ant.taskdefs.SignJar;
import org.apache.tools.ant.taskdefs.Taskdef;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.AndSelector;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.apache.tools.ant.types.selectors.OrSelector;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.netbeans.nbbuild.MakeJNLP;
import org.netbeans.nbbuild.ModuleSelector;

public class CreateWebstartAppMojo
extends AbstractMojo {
    private MavenProject project;
    protected MavenProjectHelper projectHelper;
    protected String brandingToken;
    private File outputDirectory;
    private File destinationFile;
    private String webstartClassifier;
    private String codebase;
    private File masterJnlpFile;
    private String keystore;
    private String keystorepassword;
    private String keystorealias;
    private boolean processJarVersions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("$codebase".equals(this.codebase)) {
            this.codebase = "$$codebase";
        }
        if (!"nbm-application".equals(this.project.getPackaging())) {
            throw new MojoExecutionException("This goal only makes sense on project with nbm-application packaging.");
        }
        Project antProject = new Project();
        antProject.init();
        if (this.keystore != null && this.keystorealias != null && this.keystorepassword != null) {
            File ks = new File(this.keystore);
            if (!ks.exists()) {
                throw new MojoFailureException("Cannot find keystore file at " + ks.getAbsolutePath());
            }
        } else {
            if (this.keystore != null || this.keystorepassword != null || this.keystorealias != null) {
                throw new MojoFailureException("If you want to sign the jnlp application, you need to define all three keystore related parameters.");
            }
            this.getLog().warn((CharSequence)"Keystore related parameters not set, generating a default keystore.");
            GenerateKey genTask = (GenerateKey)antProject.createTask("genkey");
            genTask.setAlias("jnlp");
            genTask.setStorepass("netbeans");
            genTask.setDname("CN=" + System.getProperty("user.name"));
            genTask.setKeystore(new File(this.outputDirectory, "generated.keystore").getAbsolutePath());
            genTask.execute();
            this.keystore = new File(this.outputDirectory, "generated.keystore").getAbsolutePath();
            this.keystorepassword = "netbeans";
            this.keystorealias = "jnlp";
        }
        Taskdef taskdef = (Taskdef)antProject.createTask("taskdef");
        taskdef.setClassname("org.netbeans.nbbuild.MakeJNLP");
        taskdef.setName("makejnlp");
        taskdef.execute();
        taskdef = (Taskdef)antProject.createTask("taskdef");
        taskdef.setClassname("org.netbeans.nbbuild.VerifyJNLP");
        taskdef.setName("verifyjnlp");
        taskdef.execute();
        try {
            File webstartBuildDir = new File(this.outputDirectory + File.separator + "webstart" + File.separator + this.brandingToken);
            if (webstartBuildDir.exists()) {
                FileUtils.deleteDirectory((File)webstartBuildDir);
            }
            webstartBuildDir.mkdirs();
            this.getLog().info((CharSequence)("Generating webstartable binaries at " + webstartBuildDir.getAbsolutePath()));
            File nbmBuildDirFile = new File(this.outputDirectory, this.brandingToken);
            MakeJNLP jnlpTask = (MakeJNLP)antProject.createTask("makejnlp");
            jnlpTask.setDir(webstartBuildDir);
            jnlpTask.setCodebase(this.codebase);
            jnlpTask.setVerify(false);
            jnlpTask.setPermissions("<security><all-permissions/></security>");
            jnlpTask.setSignJars(true);
            jnlpTask.setAlias(this.keystorealias);
            jnlpTask.setKeystore(this.keystore);
            jnlpTask.setStorePass(this.keystorepassword);
            jnlpTask.setProcessJarVersions(this.processJarVersions);
            FileSet fs = jnlpTask.createModules();
            fs.setDir(nbmBuildDirFile);
            OrSelector or = new OrSelector();
            AndSelector and = new AndSelector();
            FilenameSelector inc = new FilenameSelector();
            inc.setName("*/modules/**/*.jar");
            or.addFilename(inc);
            inc = new FilenameSelector();
            inc.setName("*/lib/**/*.jar");
            or.addFilename(inc);
            inc = new FilenameSelector();
            inc.setName("*/core/**/*.jar");
            or.addFilename(inc);
            ModuleSelector ms = new ModuleSelector();
            Parameter included = new Parameter();
            included.setName("includeClusters");
            included.setValue("");
            Parameter excluded = new Parameter();
            excluded.setName("excludeClusters");
            excluded.setValue("");
            Parameter exModules = new Parameter();
            exModules.setName("excludeModules");
            exModules.setValue("");
            ms.setParameters(new Parameter[]{included, excluded, exModules});
            and.add((FileSelector)or);
            and.add((FileSelector)ms);
            fs.addAnd(and);
            jnlpTask.execute();
            String extSnippet = this.generateExtensions(fs, antProject, "");
            Properties props = new Properties();
            props.setProperty("jnlp.resources", extSnippet);
            props.setProperty("jnlp.codebase", this.codebase);
            props.setProperty("app.name", this.brandingToken);
            props.setProperty("app.icon", "master.png");
            props.setProperty("app.title", this.project.getName());
            if (this.project.getOrganization() != null) {
                props.setProperty("app.vendor", this.project.getOrganization().getName());
            } else {
                props.setProperty("app.vendor", "Nobody");
            }
            String description = this.project.getDescription() != null ? this.project.getDescription() : "No Project Description";
            props.setProperty("app.description", description);
            props.setProperty("branding.token", this.brandingToken);
            props.setProperty("netbeans.jnlp.fixPolicy", "true");
            File masterJnlp = new File(webstartBuildDir.getAbsolutePath() + File.separator + "master.jnlp");
            this.filterCopy(this.masterJnlpFile, "/master.jnlp", masterJnlp, props);
            File startup = this.copyLauncher(this.outputDirectory, nbmBuildDirFile);
            File jnlpDestination = new File(webstartBuildDir.getAbsolutePath() + File.separator + "startup.jar");
            SignJar signTask = (SignJar)antProject.createTask("signjar");
            signTask.setKeystore(this.keystore);
            signTask.setStorepass(this.keystorepassword);
            signTask.setAlias(this.keystorealias);
            signTask.setSignedjar(jnlpDestination);
            signTask.setJar(startup);
            signTask.execute();
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(nbmBuildDirFile);
            ds.setIncludes(new String[]{"**/locale/*.jar"});
            ds.scan();
            String[] includes = ds.getIncludedFiles();
            StringBuffer brandRefs = new StringBuffer();
            if (includes != null && includes.length > 0) {
                File brandingDir = new File(webstartBuildDir, "branding");
                brandingDir.mkdirs();
                for (String incBran : includes) {
                    File source = new File(nbmBuildDirFile, incBran);
                    File dest = new File(brandingDir, source.getName());
                    FileUtils.copyFile((File)source, (File)dest);
                    brandRefs.append("    <jar href='branding/" + dest.getName() + "'/>\n");
                }
            }
            File brandingJnlp = new File(webstartBuildDir.getAbsolutePath() + File.separator + "branding.jnlp");
            props.setProperty("jnlp.branding.jars", brandRefs.toString());
            this.filterCopy(null, "/branding.jnlp", brandingJnlp, props);
            if (this.destinationFile.exists()) {
                this.destinationFile.delete();
            }
            ZipArchiver archiver = new ZipArchiver();
            archiver.addDirectory(webstartBuildDir);
            archiver.setDestFile(this.destinationFile);
            archiver.createArchive();
            this.projectHelper.attachArtifact(this.project, "zip", this.webstartClassifier, this.destinationFile);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error creating webstartable binary.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyLauncher(File standaloneBuildDir, File builtInstallation) throws IOException {
        File file;
        File jnlpStarter = new File(builtInstallation.getAbsolutePath() + File.separator + "harness" + File.separator + "jnlp" + File.separator + "jnlp-launcher.jar");
        InputStream source = null;
        FileOutputStream outstream = null;
        try {
            source = !jnlpStarter.exists() ? ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("webstart/jnlp-launcher.jar") : new FileInputStream(jnlpStarter);
            File jnlpDestination = new File(standaloneBuildDir.getAbsolutePath() + File.separator + "jnlp-launcher.jar");
            outstream = new FileOutputStream(jnlpDestination);
            IOUtil.copy((InputStream)source, (OutputStream)outstream);
            file = jnlpDestination;
        }
        catch (Throwable throwable) {
            IOUtil.close(source);
            IOUtil.close(outstream);
            throw throwable;
        }
        IOUtil.close((InputStream)source);
        IOUtil.close((OutputStream)outstream);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterCopy(File sourceFile, String resourcePath, File destinationFile, Properties filterProperties) throws IOException {
        BufferedReader source = null;
        OutputStreamWriter destination = null;
        try {
            InputStream instream = sourceFile != null ? new FileInputStream(sourceFile) : ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourcePath);
            FileOutputStream outstream = new FileOutputStream(destinationFile);
            source = new BufferedReader(new InputStreamReader(instream, "UTF-8"));
            destination = new OutputStreamWriter((OutputStream)outstream, "UTF-8");
            InterpolationFilterReader reader = new InterpolationFilterReader((Reader)source, (Map)filterProperties, "${", "}");
            IOUtil.copy((Reader)reader, (Writer)destination);
        }
        catch (Throwable throwable) {
            IOUtil.close(source);
            IOUtil.close(destination);
            throw throwable;
        }
        IOUtil.close((Reader)source);
        IOUtil.close((Writer)destination);
    }

    private String generateExtensions(FileSet files, Project antProject, String masterPrefix) throws IOException {
        StringBuffer buff = new StringBuffer();
        for (String nm : files.getDirectoryScanner(antProject).getIncludedFiles()) {
            File jar = new File(files.getDir(antProject), nm);
            if (!jar.canRead()) {
                throw new IOException("Cannot read file: " + jar);
            }
            JarFile theJar = new JarFile(jar);
            String codenamebase = theJar.getManifest().getMainAttributes().getValue("OpenIDE-Module");
            if (codenamebase == null) {
                throw new IOException("Not a NetBeans Module: " + jar);
            }
            int slash = codenamebase.indexOf(47);
            if (slash >= 0) {
                codenamebase = codenamebase.substring(0, slash);
            }
            String dashcnb = codenamebase.replace('.', '-');
            buff.append("    <extension name='" + codenamebase + "' href='" + masterPrefix + dashcnb + ".jnlp' />\n");
            theJar.close();
        }
        return buff.toString();
    }
}

