/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.GenerateKey;
import org.apache.tools.ant.taskdefs.SignJar;
import org.apache.tools.ant.taskdefs.Taskdef;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.AndSelector;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.apache.tools.ant.types.selectors.OrSelector;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.netbeans.nbbuild.MakeJNLP;
import org.netbeans.nbbuild.ModuleSelector;
import org.netbeans.nbbuild.VerifyJNLP;

public class CreateWebstartAppMojo
extends AbstractMojo {
    private MavenProject project;
    protected MavenProjectHelper projectHelper;
    protected String brandingToken;
    private File outputDirectory;
    private File destinationFile;
    private String webstartClassifier;
    private String codebase;
    private File masterJnlpFile;
    private String keystore;
    private String keystorepassword;
    private String keystorealias;
    private boolean processJarVersions;
    private String additionalArguments;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"nbm-application".equals(this.project.getPackaging())) {
            throw new MojoExecutionException("This goal only makes sense on project with nbm-application packaging.");
        }
        Project antProject = new Project();
        antProject.init();
        if (this.keystore != null && this.keystorealias != null && this.keystorepassword != null) {
            File ks = new File(this.keystore);
            if (!ks.exists()) {
                throw new MojoFailureException("Cannot find keystore file at " + ks.getAbsolutePath());
            }
        } else {
            if (this.keystore != null || this.keystorepassword != null || this.keystorealias != null) {
                throw new MojoFailureException("If you want to sign the jnlp application, you need to define all three keystore related parameters.");
            }
            File generatedKeystore = new File(this.outputDirectory, "generated.keystore");
            if (!generatedKeystore.exists()) {
                this.getLog().warn((CharSequence)"Keystore related parameters not set, generating a default keystore.");
                GenerateKey genTask = (GenerateKey)antProject.createTask("genkey");
                genTask.setAlias("jnlp");
                genTask.setStorepass("netbeans");
                genTask.setDname("CN=" + System.getProperty("user.name"));
                genTask.setKeystore(generatedKeystore.getAbsolutePath());
                genTask.execute();
            }
            this.keystore = generatedKeystore.getAbsolutePath();
            this.keystorepassword = "netbeans";
            this.keystorealias = "jnlp";
        }
        Taskdef taskdef = (Taskdef)antProject.createTask("taskdef");
        taskdef.setClassname("org.netbeans.nbbuild.MakeJNLP");
        taskdef.setName("makejnlp");
        taskdef.execute();
        taskdef = (Taskdef)antProject.createTask("taskdef");
        taskdef.setClassname("org.netbeans.nbbuild.VerifyJNLP");
        taskdef.setName("verifyjnlp");
        taskdef.execute();
        try {
            File webstartBuildDir = new File(this.outputDirectory + File.separator + "webstart" + File.separator + this.brandingToken);
            if (webstartBuildDir.exists()) {
                FileUtils.deleteDirectory((File)webstartBuildDir);
            }
            webstartBuildDir.mkdirs();
            final String localCodebase = this.codebase != null ? this.codebase : webstartBuildDir.toURI().toString();
            this.getLog().info((CharSequence)("Generating webstartable binaries at " + webstartBuildDir.getAbsolutePath()));
            File nbmBuildDirFile = new File(this.outputDirectory, this.brandingToken);
            MakeJNLP jnlpTask = (MakeJNLP)antProject.createTask("makejnlp");
            jnlpTask.setDir(webstartBuildDir);
            jnlpTask.setCodebase(localCodebase);
            jnlpTask.setVerify(false);
            jnlpTask.setPermissions("<security><all-permissions/></security>");
            jnlpTask.setSignJars(true);
            jnlpTask.setAlias(this.keystorealias);
            jnlpTask.setKeystore(this.keystore);
            jnlpTask.setStorePass(this.keystorepassword);
            jnlpTask.setProcessJarVersions(this.processJarVersions);
            FileSet fs = jnlpTask.createModules();
            fs.setDir(nbmBuildDirFile);
            OrSelector or = new OrSelector();
            AndSelector and = new AndSelector();
            FilenameSelector inc = new FilenameSelector();
            inc.setName("*/modules/**/*.jar");
            or.addFilename(inc);
            inc = new FilenameSelector();
            inc.setName("*/lib/**/*.jar");
            or.addFilename(inc);
            inc = new FilenameSelector();
            inc.setName("*/core/**/*.jar");
            or.addFilename(inc);
            ModuleSelector ms = new ModuleSelector();
            Parameter included = new Parameter();
            included.setName("includeClusters");
            included.setValue("");
            Parameter excluded = new Parameter();
            excluded.setName("excludeClusters");
            excluded.setValue("");
            Parameter exModules = new Parameter();
            exModules.setName("excludeModules");
            exModules.setValue("");
            ms.setParameters(new Parameter[]{included, excluded, exModules});
            and.add((FileSelector)or);
            and.add((FileSelector)ms);
            fs.addAnd(and);
            jnlpTask.execute();
            String extSnippet = this.generateExtensions(fs, antProject, "");
            Properties props = new Properties();
            props.setProperty("jnlp.codebase", localCodebase);
            props.setProperty("app.name", this.brandingToken);
            props.setProperty("app.title", this.project.getName());
            if (this.project.getOrganization() != null) {
                props.setProperty("app.vendor", this.project.getOrganization().getName());
            } else {
                props.setProperty("app.vendor", "Nobody");
            }
            String description = this.project.getDescription() != null ? this.project.getDescription() : "No Project Description";
            props.setProperty("app.description", description);
            props.setProperty("branding.token", this.brandingToken);
            props.setProperty("netbeans.jnlp.fixPolicy", "false");
            StringBuilder stBuilder = new StringBuilder();
            if (this.additionalArguments != null) {
                StringTokenizer st = new StringTokenizer(this.additionalArguments);
                while (st.hasMoreTokens()) {
                    String arg = st.nextToken();
                    if (!arg.startsWith("-J")) continue;
                    if (stBuilder.length() > 0) {
                        stBuilder.append(' ');
                    }
                    stBuilder.append(arg.substring(2));
                }
            }
            props.setProperty("netbeans.run.params", stBuilder.toString());
            File masterJnlp = new File(webstartBuildDir.getAbsolutePath() + File.separator + this.brandingToken + ".jnlp");
            this.filterCopy(this.masterJnlpFile, "master.jnlp", masterJnlp, props);
            File startup = this.copyLauncher(this.outputDirectory, nbmBuildDirFile);
            File jnlpDestination = new File(webstartBuildDir.getAbsolutePath() + File.separator + "startup.jar");
            SignJar signTask = (SignJar)antProject.createTask("signjar");
            signTask.setKeystore(this.keystore);
            signTask.setStorepass(this.keystorepassword);
            signTask.setAlias(this.keystorealias);
            signTask.setSignedjar(jnlpDestination);
            signTask.setJar(startup);
            signTask.execute();
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(nbmBuildDirFile);
            ds.setIncludes(new String[]{"**/locale/*.jar"});
            ds.scan();
            String[] includes = ds.getIncludedFiles();
            StringBuilder brandRefs = new StringBuilder();
            if (includes != null && includes.length > 0) {
                File brandingDir = new File(webstartBuildDir, "branding");
                brandingDir.mkdirs();
                for (String incBran : includes) {
                    File source = new File(nbmBuildDirFile, incBran);
                    File dest = new File(brandingDir, source.getName());
                    FileUtils.copyFile((File)source, (File)dest);
                    brandRefs.append("    <jar href='branding/").append(dest.getName()).append("'/>\n");
                }
                signTask = (SignJar)antProject.createTask("signjar");
                signTask.setKeystore(this.keystore);
                signTask.setStorepass(this.keystorepassword);
                signTask.setAlias(this.keystorealias);
                FileSet set = new FileSet();
                set.setDir(brandingDir);
                set.setIncludes("*.jar");
                signTask.addFileset(set);
                signTask.execute();
            }
            File modulesJnlp = new File(webstartBuildDir.getAbsolutePath() + File.separator + "modules.jnlp");
            props.setProperty("jnlp.branding.jars", brandRefs.toString());
            props.setProperty("jnlp.resources", extSnippet);
            this.filterCopy(null, "branding.jnlp", modulesJnlp, props);
            this.getLog().info((CharSequence)"Verifying generated webstartable content.");
            VerifyJNLP verifyTask = (VerifyJNLP)antProject.createTask("verifyjnlp");
            FileSet verify = new FileSet();
            verify.setFile(masterJnlp);
            verifyTask.addConfiguredFileset(verify);
            verifyTask.execute();
            if (this.destinationFile.exists()) {
                this.destinationFile.delete();
            }
            ZipArchiver archiver = new ZipArchiver();
            if (this.codebase != null) {
                this.getLog().warn((CharSequence)"Defining <codebase>/${nbm.webstart.codebase} is generally unnecessary");
                archiver.addDirectory(webstartBuildDir);
            } else {
                archiver.addDirectory(webstartBuildDir, null, new String[]{"**/*.jnlp"});
                for (final File jnlp : webstartBuildDir.listFiles()) {
                    if (!jnlp.getName().endsWith(".jnlp")) continue;
                    archiver.addResource(new PlexusIoResource(){

                        public InputStream getContents() throws IOException {
                            return new ByteArrayInputStream(FileUtils.fileRead((File)jnlp, (String)"UTF-8").replace(localCodebase, "$$codebase").getBytes("UTF-8"));
                        }

                        public long getLastModified() {
                            return jnlp.lastModified();
                        }

                        public boolean isExisting() {
                            return true;
                        }

                        public long getSize() {
                            return -1L;
                        }

                        public URL getURL() throws IOException {
                            return null;
                        }

                        public String getName() {
                            return jnlp.getAbsolutePath();
                        }

                        public boolean isFile() {
                            return true;
                        }

                        public boolean isDirectory() {
                            return false;
                        }
                    }, jnlp.getName(), archiver.getDefaultFileMode());
                }
            }
            File jdkhome = new File(System.getProperty("java.home"));
            File servlet = new File(jdkhome, "sample/jnlp/servlet/jnlp-servlet.jar");
            if (!servlet.isFile()) {
                servlet = new File(jdkhome.getParentFile(), "sample/jnlp/servlet/jnlp-servlet.jar");
            }
            if (servlet.isFile()) {
                archiver.addFile(servlet, "WEB-INF/lib/jnlp-servlet.jar");
                archiver.addResource(new PlexusIoResource(){

                    public InputStream getContents() throws IOException {
                        return new ByteArrayInputStream("<web-app>\n    <servlet>\n        <servlet-name>JnlpDownloadServlet</servlet-name>\n        <servlet-class>jnlp.sample.servlet.JnlpDownloadServlet</servlet-class>\n    </servlet>\n    <servlet-mapping>\n        <servlet-name>JnlpDownloadServlet</servlet-name>\n        <url-pattern>*.jnlp</url-pattern>\n    </servlet-mapping>\n</web-app>\n".getBytes());
                    }

                    public long getLastModified() {
                        return 0L;
                    }

                    public boolean isExisting() {
                        return true;
                    }

                    public long getSize() {
                        return -1L;
                    }

                    public URL getURL() throws IOException {
                        return null;
                    }

                    public String getName() {
                        return "web.xml";
                    }

                    public boolean isFile() {
                        return true;
                    }

                    public boolean isDirectory() {
                        return false;
                    }
                }, "WEB-INF/web.xml", archiver.getDefaultFileMode());
            }
            archiver.setDestFile(this.destinationFile);
            archiver.createArchive();
            this.projectHelper.attachArtifact(this.project, "war", this.webstartClassifier, this.destinationFile);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error creating webstartable binary.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyLauncher(File standaloneBuildDir, File builtInstallation) throws IOException {
        File file;
        File jnlpStarter = new File(builtInstallation.getAbsolutePath() + File.separator + "harness" + File.separator + "jnlp" + File.separator + "jnlp-launcher.jar");
        InputStream source = null;
        FileOutputStream outstream = null;
        try {
            source = !jnlpStarter.exists() ? ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("harness/jnlp/jnlp-launcher.jar") : new FileInputStream(jnlpStarter);
            File jnlpDestination = new File(standaloneBuildDir.getAbsolutePath() + File.separator + "jnlp-launcher.jar");
            outstream = new FileOutputStream(jnlpDestination);
            IOUtil.copy((InputStream)source, (OutputStream)outstream);
            file = jnlpDestination;
        }
        catch (Throwable throwable) {
            IOUtil.close(source);
            IOUtil.close(outstream);
            throw throwable;
        }
        IOUtil.close((InputStream)source);
        IOUtil.close((OutputStream)outstream);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterCopy(File sourceFile, String resourcePath, File destinationFile, Properties filterProperties) throws IOException {
        BufferedReader source = null;
        OutputStreamWriter destination = null;
        try {
            InputStream instream = sourceFile != null ? new FileInputStream(sourceFile) : ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourcePath);
            FileOutputStream outstream = new FileOutputStream(destinationFile);
            source = new BufferedReader(new InputStreamReader(instream, "UTF-8"));
            destination = new OutputStreamWriter((OutputStream)outstream, "UTF-8");
            InterpolationFilterReader reader = new InterpolationFilterReader((Reader)source, (Map)filterProperties, "${", "}");
            IOUtil.copy((Reader)reader, (Writer)destination);
        }
        catch (Throwable throwable) {
            IOUtil.close(source);
            IOUtil.close(destination);
            throw throwable;
        }
        IOUtil.close((Reader)source);
        IOUtil.close((Writer)destination);
    }

    private String generateExtensions(FileSet files, Project antProject, String masterPrefix) throws IOException {
        StringBuilder buff = new StringBuilder();
        for (String nm : files.getDirectoryScanner(antProject).getIncludedFiles()) {
            File jar = new File(files.getDir(antProject), nm);
            if (!jar.canRead()) {
                throw new IOException("Cannot read file: " + jar);
            }
            JarFile theJar = new JarFile(jar);
            String codenamebase = theJar.getManifest().getMainAttributes().getValue("OpenIDE-Module");
            if (codenamebase == null) {
                throw new IOException("Not a NetBeans Module: " + jar);
            }
            int slash = codenamebase.indexOf(47);
            if (slash >= 0) {
                codenamebase = codenamebase.substring(0, slash);
            }
            String dashcnb = codenamebase.replace('.', '-');
            buff.append("    <extension name='").append(codenamebase).append("' href='").append(masterPrefix).append(dashcnb).append(".jnlp' />\n");
            theJar.close();
        }
        return buff.toString();
    }
}

