/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.text.BreakIterator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.jar.Attributes;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.analyzer.DefaultClassAnalyzer;
import org.apache.maven.shared.dependency.analyzer.asm.ASMDependencyAnalyzer;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.codehaus.mojo.nbm.AbstractNbmMojo;
import org.codehaus.mojo.nbm.AdaptNbVersion;
import org.codehaus.mojo.nbm.CollectModuleLibrariesNodeVisitor;
import org.codehaus.mojo.nbm.ExamineManifest;
import org.codehaus.mojo.nbm.model.Dependency;
import org.codehaus.mojo.nbm.model.NetbeansModule;
import org.codehaus.plexus.util.IOUtil;

public class NetbeansManifestUpdateMojo
extends AbstractNbmMojo {
    protected File nbmBuildDir;
    protected File descriptor;
    private MavenProject project;
    protected File nbmJavahelpSource;
    private File sourceManifestFile;
    private File targetManifestFile;
    private String verifyRuntime;
    private static final String FAIL = "fail";
    private static final String WARN = "warn";
    private static final String SKIP = "skip";
    private List<String> publicPackages;
    private boolean useOSGiDependencies;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private DependencyTreeBuilder dependencyTreeBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        String packagesValue;
        Manifest manifest;
        ExamineManifest examinator;
        String moduleName;
        NetbeansModule module;
        block40: {
            block39: {
                File nbmManifest;
                super.registerNbmAntTasks();
                module = this.descriptor != null && this.descriptor.exists() ? this.readModuleDescriptor(this.descriptor) : this.createDefaultDescriptor(this.project, false);
                moduleName = module.getCodeNameBase();
                if (moduleName == null) {
                    moduleName = this.project.getGroupId() + "." + this.project.getArtifactId();
                    moduleName = moduleName.replaceAll("-", ".");
                }
                File specialManifest = this.sourceManifestFile;
                File file = nbmManifest = module.getManifest() != null ? new File(this.project.getBasedir(), module.getManifest()) : null;
                if (nbmManifest != null && nbmManifest.exists()) {
                    specialManifest = nbmManifest;
                }
                examinator = new ExamineManifest(this.getLog());
                if (specialManifest != null && specialManifest.exists()) {
                    examinator.setManifestFile(specialManifest);
                    examinator.checkFile();
                }
                this.getLog().info((CharSequence)"NBM Plugin generates manifest");
                manifest = null;
                if (specialManifest == null || !specialManifest.exists()) break block39;
                InputStreamReader reader = null;
                try {
                    reader = new InputStreamReader(new FileInputStream(specialManifest));
                    manifest = new Manifest((Reader)reader);
                }
                catch (IOException exc) {
                    manifest = new Manifest();
                    this.getLog().warn((CharSequence)("Error reading manifest at " + specialManifest), (Throwable)exc);
                    IOUtil.close((Reader)reader);
                }
                catch (ManifestException ex) {
                    this.getLog().warn((CharSequence)("Error reading manifest at " + specialManifest), (Throwable)ex);
                    manifest = new Manifest();
                    {
                        catch (Throwable throwable) {
                            IOUtil.close(reader);
                            throw throwable;
                        }
                    }
                    IOUtil.close((Reader)reader);
                }
                IOUtil.close((Reader)reader);
                break block40;
            }
            manifest = new Manifest();
        }
        String specVersion = AdaptNbVersion.adaptVersion(this.project.getVersion(), "spec");
        String implVersion = AdaptNbVersion.adaptVersion(this.project.getVersion(), "impl");
        Manifest.Section mainSection = manifest.getMainSection();
        this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Specification-Version", specVersion);
        this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Implementation-Version", implVersion);
        String timestamp = this.createTimestamp();
        this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Build-Version", timestamp);
        String projectCNB = this.conditionallyAddAttribute(mainSection, "OpenIDE-Module", moduleName);
        if (this.publicPackages != null && this.publicPackages.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String pub : this.publicPackages) {
                if (pub.endsWith(".**")) {
                    sb.append(pub);
                } else if (pub.endsWith(".*")) {
                    sb.append(pub).append("*");
                } else {
                    sb.append(pub).append(".*");
                }
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            packagesValue = sb.toString();
        } else {
            packagesValue = "-";
        }
        this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Public-Packages", packagesValue);
        this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Requires", "org.openide.modules.ModuleFormat1");
        if (!examinator.isLocalized()) {
            this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Display-Category", this.project.getGroupId());
            this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Name", this.project.getName());
            this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Short-Description", NetbeansManifestUpdateMojo.shorten(this.project.getDescription()));
            this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Long-Description", this.project.getDescription());
        }
        this.getLog().debug((CharSequence)("module =" + module));
        if (module != null) {
            DependencyNode treeroot = this.createDependencyTree(this.project, this.dependencyTreeBuilder, this.localRepository, this.artifactFactory, this.artifactMetadataSource, this.artifactCollector, "compile");
            HashMap<Artifact, ExamineManifest> examinerCache = new HashMap<Artifact, ExamineManifest>();
            List<Artifact> libArtifacts = NetbeansManifestUpdateMojo.getLibraryArtifacts(treeroot, module, this.project.getRuntimeArtifacts(), examinerCache, this.getLog(), this.useOSGiDependencies);
            List<AbstractNbmMojo.ModuleWrapper> moduleArtifacts = NetbeansManifestUpdateMojo.getModuleDependencyArtifacts(treeroot, module, this.project, examinerCache, libArtifacts, this.getLog(), this.useOSGiDependencies);
            String classPath = "";
            String dependencies = "";
            String depSeparator = " ";
            for (Artifact a : libArtifacts) {
                classPath = classPath + " ext/" + a.getGroupId() + "/" + a.getFile().getName();
            }
            for (AbstractNbmMojo.ModuleWrapper wr : moduleArtifacts) {
                if (wr.transitive) continue;
                Dependency dep = wr.dependency;
                Artifact artifact = wr.artifact;
                ExamineManifest depExaminator = (ExamineManifest)examinerCache.get(artifact);
                String type = dep.getType();
                String depToken = dep.getExplicitValue();
                if (depToken == null) {
                    if ("loose".equals(type)) {
                        depToken = depExaminator.getModuleWithRelease();
                    } else if ("spec".equals(type)) {
                        depToken = depExaminator.getModuleWithRelease() + " > " + (depExaminator.isNetbeansModule() ? depExaminator.getSpecVersion() : AdaptNbVersion.adaptVersion(depExaminator.getSpecVersion(), "spec"));
                    } else if ("impl".equals(type)) {
                        depToken = depExaminator.getModuleWithRelease() + " = " + (depExaminator.isNetbeansModule() ? depExaminator.getImplVersion() : AdaptNbVersion.adaptVersion(depExaminator.getImplVersion(), "impl"));
                    } else {
                        throw new MojoExecutionException("Wrong type of Netbeans dependency: " + type + " Allowed values are: loose, spec, impl.");
                    }
                }
                if (depToken == null) {
                    this.getLog().error((CharSequence)("Cannot properly resolve the netbeans dependency for " + dep.getId()));
                    continue;
                }
                dependencies = dependencies + depSeparator + depToken;
                depSeparator = ", ";
            }
            if (!this.verifyRuntime.equalsIgnoreCase(SKIP)) {
                try {
                    this.checkModuleClassPath(treeroot, libArtifacts, examinerCache, moduleArtifacts, projectCNB);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Error while checking runtime dependencies", (Exception)ex);
                }
            }
            if (this.nbmJavahelpSource.exists()) {
                String moduleJarName = this.stripVersionFromCodebaseName(moduleName).replace(".", "-");
                classPath = classPath + " docs/" + moduleJarName + ".jar";
            }
            if (classPath.length() > 0) {
                this.conditionallyAddAttribute(mainSection, Attributes.Name.CLASS_PATH.toString(), classPath.trim());
            }
            if (dependencies.length() > 0) {
                this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Module-Dependencies", dependencies);
            }
        }
        PrintWriter writer = null;
        try {
            if (!this.targetManifestFile.exists()) {
                this.targetManifestFile.getParentFile().mkdirs();
                this.targetManifestFile.createNewFile();
            }
            writer = new PrintWriter(this.targetManifestFile, "UTF-8");
            manifest.write(writer);
        }
        catch (IOException ex) {
            try {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    private String createTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String timestamp = dateFormat.format(new Date());
        return timestamp;
    }

    private String stripVersionFromCodebaseName(String cnb) {
        String base = cnb;
        int index = base.indexOf(47);
        if (index > -1) {
            base = base.substring(0, index).trim();
        }
        return base;
    }

    String conditionallyAddAttribute(Manifest.Section section, String key, String value) {
        Manifest.Attribute attr = section.getAttribute(key);
        if (attr == null) {
            attr = new Manifest.Attribute();
            attr.setName(key);
            attr.setValue(value != null ? value.replaceAll("\\s+", " ").trim() : "<undefined>");
            try {
                section.addConfiguredAttribute(attr);
            }
            catch (ManifestException ex) {
                this.getLog().error((CharSequence)("Cannot update manifest (key=" + key + ")"));
                ex.printStackTrace();
            }
        }
        return attr.getValue();
    }

    static String shorten(String paragraph) {
        if (paragraph == null || paragraph.length() == 0) {
            return null;
        }
        BreakIterator breaker = BreakIterator.getSentenceInstance();
        breaker.setText(paragraph);
        return paragraph.substring(0, breaker.following(0)).trim();
    }

    private void checkModuleClassPath(DependencyNode treeroot, List<Artifact> libArtifacts, Map<Artifact, ExamineManifest> examinerCache, List<AbstractNbmMojo.ModuleWrapper> moduleArtifacts, String projectCodeNameBase) throws IOException, MojoExecutionException, MojoFailureException {
        Set<String> deps = this.buildProjectDependencyClasses(this.project, libArtifacts);
        deps.retainAll(this.allProjectClasses(this.project));
        Set<String> own = this.projectModuleOwnClasses(this.project, libArtifacts);
        deps.removeAll(own);
        CollectModuleLibrariesNodeVisitor visitor = new CollectModuleLibrariesNodeVisitor(this.project.getRuntimeArtifacts(), examinerCache, this.getLog(), treeroot, this.useOSGiDependencies);
        treeroot.accept((DependencyNodeVisitor)visitor);
        Map<String, List<Artifact>> modules = visitor.getDeclaredArtifacts();
        HashMap<Artifact, Set<String>> moduleAllClasses = new HashMap<Artifact, Set<String>>();
        for (AbstractNbmMojo.ModuleWrapper wr : moduleArtifacts) {
            if (!modules.containsKey(wr.artifact.getDependencyConflictId())) continue;
            ExamineManifest man = examinerCache.get(wr.artifact);
            List<Artifact> arts = modules.get(wr.artifact.getDependencyConflictId());
            Set<String>[] classes = this.visibleModuleClasses(arts, man, wr.dependency, projectCodeNameBase);
            deps.removeAll(classes[0]);
            moduleAllClasses.put(wr.artifact, classes[1]);
        }
        if (!deps.isEmpty()) {
            Map<String, List<Artifact>> transmodules = visitor.getTransitiveArtifacts();
            for (AbstractNbmMojo.ModuleWrapper wr : moduleArtifacts) {
                if (!transmodules.containsKey(wr.artifact.getDependencyConflictId())) continue;
                ExamineManifest man = examinerCache.get(wr.artifact);
                List<Artifact> arts = transmodules.get(wr.artifact.getDependencyConflictId());
                Set<String>[] classes = this.visibleModuleClasses(arts, man, wr.dependency, projectCodeNameBase);
                classes[0].retainAll(deps);
                if (classes[0].size() > 0) {
                    this.getLog().error((CharSequence)("Project uses classes from transitive module " + wr.artifact.getId() + " which will not be accessible at runtime."));
                    deps.removeAll(classes[0]);
                }
                classes[1].retainAll(deps);
                if (classes[1].size() <= 0) continue;
                this.getLog().info((CharSequence)("Private classes referenced in transitive module: " + Arrays.toString(classes[1].toArray())));
                this.getLog().error((CharSequence)("Project depends on packages not accessible at runtime in transitive module " + wr.artifact.getId() + " which will not be accessible at runtime."));
                deps.removeAll(classes[1]);
            }
            for (Artifact a : moduleAllClasses.keySet()) {
                ArrayList<String> strs = new ArrayList<String>(deps);
                if (!deps.removeAll((Collection)moduleAllClasses.get(a))) continue;
                strs.retainAll((Collection)moduleAllClasses.get(a));
                this.getLog().info((CharSequence)("Private classes referenced in module: " + Arrays.toString(strs.toArray())));
                this.getLog().error((CharSequence)("Project depends on packages not accessible at runtime in module " + a.getId()));
            }
            if (this.verifyRuntime.equalsIgnoreCase(FAIL)) {
                if (!deps.isEmpty()) {
                    throw new MojoFailureException("Uncategorized problems with NetBeans dependency verification (maybe MNBMODULE-102): " + deps);
                }
                throw new MojoFailureException("See above for failures in runtime NetBeans dependencies verification.");
            }
        }
    }

    private Set<String> buildProjectDependencyClasses(MavenProject project, List<Artifact> libraries) throws IOException {
        HashSet<String> dependencyClasses = new HashSet<String>();
        String outputDirectory = project.getBuild().getOutputDirectory();
        dependencyClasses.addAll(this.buildDependencyClasses(outputDirectory));
        for (Artifact lib : libraries) {
            dependencyClasses.addAll(this.buildDependencyClasses(lib.getFile().getAbsolutePath()));
        }
        return dependencyClasses;
    }

    private Set<String> projectModuleOwnClasses(MavenProject project, List<Artifact> libraries) throws IOException {
        HashSet<String> projectClasses = new HashSet<String>();
        DefaultClassAnalyzer analyzer = new DefaultClassAnalyzer();
        String outputDirectory = project.getBuild().getOutputDirectory();
        URL fl = new File(outputDirectory).toURI().toURL();
        projectClasses.addAll(analyzer.analyze(fl));
        for (Artifact lib : libraries) {
            URL url = lib.getFile().toURI().toURL();
            projectClasses.addAll(analyzer.analyze(url));
        }
        return projectClasses;
    }

    private Set<String> allProjectClasses(MavenProject project) throws IOException {
        HashSet<String> projectClasses = new HashSet<String>();
        DefaultClassAnalyzer analyzer = new DefaultClassAnalyzer();
        String outputDirectory = project.getBuild().getOutputDirectory();
        URL fl = new File(outputDirectory).toURI().toURL();
        projectClasses.addAll(analyzer.analyze(fl));
        List libs = project.getRuntimeArtifacts();
        for (Artifact lib : libs) {
            URL url = lib.getFile().toURI().toURL();
            projectClasses.addAll(analyzer.analyze(url));
        }
        return projectClasses;
    }

    private Set<String>[] visibleModuleClasses(List<Artifact> moduleLibraries, ExamineManifest manifest, Dependency dep, String projectCodeNameBase) throws IOException, MojoFailureException {
        HashSet moduleClasses = new HashSet();
        HashSet<String> visibleModuleClasses = new HashSet<String>();
        DefaultClassAnalyzer analyzer = new DefaultClassAnalyzer();
        String type = dep.getType();
        if (dep.getExplicitValue() != null && dep.getExplicitValue().contains("=")) {
            type = "impl";
        }
        if (type == null || "loose".equals(type)) {
            type = "spec";
        }
        for (Artifact lib : moduleLibraries) {
            URL url = lib.getFile().toURI().toURL();
            moduleClasses.addAll(analyzer.analyze(url));
        }
        if ("spec".equals(type)) {
            String cnb = this.stripVersionFromCodebaseName(projectCodeNameBase);
            if (manifest.hasFriendPackages() && !manifest.getFriends().contains(cnb)) {
                if (this.verifyRuntime.equalsIgnoreCase(FAIL)) {
                    throw new MojoFailureException("Module dependency has friend dependency on " + manifest.getModule() + "but is not listed as friend.");
                }
                this.getLog().warn((CharSequence)("Module dependency has friend dependency on " + manifest.getModule() + "but is not listed as friend."));
            }
            List<Pattern> compiled = NetbeansManifestUpdateMojo.createCompiledPatternList(manifest.getPackages());
            if (this.useOSGiDependencies && manifest.isOsgiBundle()) {
                compiled = Collections.singletonList(Pattern.compile("(.+)"));
            }
            block1: for (String clazz : moduleClasses) {
                for (Pattern patt : compiled) {
                    if (!patt.matcher(clazz).matches()) continue;
                    visibleModuleClasses.add(clazz);
                    continue block1;
                }
            }
        } else if ("impl".equals(type)) {
            visibleModuleClasses.addAll(moduleClasses);
        } else {
            throw new MojoFailureException("Wrong type of module dependency " + type);
        }
        return new Set[]{visibleModuleClasses, moduleClasses};
    }

    static List<Pattern> createCompiledPatternList(List<String> packages) {
        ArrayList<Pattern> toRet = new ArrayList<Pattern>();
        for (String token : packages) {
            String patt;
            if (token.endsWith(".**")) {
                patt = "^" + Pattern.quote(token.substring(0, token.length() - 2)) + "(.+)";
                toRet.add(0, Pattern.compile(patt));
                continue;
            }
            patt = "^" + Pattern.quote(token.substring(0, token.length() - 1)) + "([^\\.]+)";
            toRet.add(Pattern.compile(patt));
        }
        return toRet;
    }

    private Set<String> buildDependencyClasses(String path) throws IOException {
        URL url = new File(path).toURI().toURL();
        ASMDependencyAnalyzer dependencyAnalyzer = new ASMDependencyAnalyzer();
        return dependencyAnalyzer.analyze(url);
    }
}

