/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.slf4j.LoggerFactory;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.resources.Project;
import org.sonar.batch.MavenProjectBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectTree {
    private List<Project> projects;
    private List<MavenProject> poms;
    private MavenProjectBuilder projectBuilder;

    public ProjectTree(MavenSession mavenSession, DatabaseSession databaseSession) {
        this.poms = mavenSession.getSortedProjects();
        this.projectBuilder = new MavenProjectBuilder(databaseSession);
    }

    protected ProjectTree(MavenProjectBuilder projectBuilder, List<MavenProject> poms) {
        this.projectBuilder = projectBuilder;
        this.poms = poms;
    }

    protected ProjectTree(List<Project> projects) {
        this.projects = new ArrayList<Project>(projects);
    }

    public void start() throws IOException {
        Project project;
        this.projects = Lists.newArrayList();
        HashMap paths = Maps.newHashMap();
        for (MavenProject mavenProject : this.poms) {
            project = this.projectBuilder.create(mavenProject);
            this.projects.add(project);
            paths.put(mavenProject.getBasedir().getCanonicalPath(), project);
        }
        for (Map.Entry entry : paths.entrySet()) {
            project = (Project)entry.getValue();
            MavenProject pom = project.getPom();
            for (Object moduleId : pom.getModules()) {
                File modulePath = new File(pom.getBasedir(), (String)moduleId);
                Project module = (Project)paths.get(modulePath.getCanonicalPath());
                if (module == null) continue;
                module.setParent(project);
            }
        }
        this.configureProjects();
        this.applyModuleExclusions();
    }

    private void configureProjects() {
        for (Project project : this.projects) {
            this.projectBuilder.configure(project);
        }
    }

    void applyModuleExclusions() {
        for (Project project : this.projects) {
            String[] excludedArtifactIds = project.getConfiguration().getStringArray("sonar.skippedModules");
            String[] includedArtifactIds = project.getConfiguration().getStringArray("sonar.includedModules");
            HashSet<String> includedModulesIdSet = new HashSet<String>();
            HashSet<String> excludedModulesIdSet = new HashSet<String>();
            if (includedArtifactIds != null) {
                includedModulesIdSet.addAll(Arrays.asList(includedArtifactIds));
            }
            if (excludedArtifactIds != null) {
                excludedModulesIdSet.addAll(Arrays.asList(excludedArtifactIds));
                includedModulesIdSet.removeAll(excludedModulesIdSet);
            }
            if (!includedModulesIdSet.isEmpty()) {
                for (Project currentProject : this.projects) {
                    if (includedModulesIdSet.contains(currentProject.getPom().getArtifactId())) continue;
                    this.exclude(currentProject);
                }
                continue;
            }
            for (String excludedArtifactId : excludedModulesIdSet) {
                Project excludedProject = this.getProjectByArtifactId(excludedArtifactId);
                this.exclude(excludedProject);
            }
        }
        Iterator<Project> it = this.projects.iterator();
        while (it.hasNext()) {
            Project project;
            project = it.next();
            if (!project.isExcluded()) continue;
            LoggerFactory.getLogger(this.getClass()).info("Module {} is excluded from analysis", (Object)project.getName());
            project.removeFromParent();
            it.remove();
        }
    }

    private void exclude(Project project) {
        if (project != null) {
            project.setExcluded(true);
            for (Project module : project.getModules()) {
                this.exclude(module);
            }
        }
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public Project getProjectByArtifactId(String artifactId) {
        for (Project project : this.projects) {
            if (!project.getPom().getArtifactId().equals(artifactId)) continue;
            return project;
        }
        return null;
    }

    public Project getRootProject() {
        for (Project project : this.projects) {
            if (project.getParent() != null) continue;
            return project;
        }
        throw new IllegalStateException("Can not find the root project from the list of Maven modules");
    }
}

