/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Event;
import org.sonar.api.batch.SonarIndex;
import org.sonar.api.design.Dependency;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilter;
import org.sonar.api.measures.MeasuresFilters;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectLink;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Violation;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.DefaultResourceCreationLock;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.ResourceFilters;
import org.sonar.batch.ViolationFilters;
import org.sonar.batch.index.Bucket;
import org.sonar.batch.index.PersistenceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultIndex
extends SonarIndex {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultIndex.class);
    private RulesProfile profile;
    private PersistenceManager persistence;
    private DefaultResourceCreationLock lock;
    private MetricFinder metricFinder;
    private ViolationFilters violationFilters;
    private ResourceFilters resourceFilters;
    private Project currentProject;
    private Map<Resource, Bucket> buckets = Maps.newHashMap();
    private Set<Dependency> dependencies = Sets.newHashSet();
    private Map<Resource, Map<Resource, Dependency>> outgoingDependenciesByResource = Maps.newHashMap();
    private Map<Resource, Map<Resource, Dependency>> incomingDependenciesByResource = Maps.newHashMap();
    private ProjectTree projectTree;

    public DefaultIndex(PersistenceManager persistence, DefaultResourceCreationLock lock, ProjectTree projectTree, MetricFinder metricFinder) {
        this.persistence = persistence;
        this.lock = lock;
        this.projectTree = projectTree;
        this.metricFinder = metricFinder;
    }

    public void start() {
        Project rootProject = this.projectTree.getRootProject();
        Bucket bucket = new Bucket((Resource)rootProject);
        this.buckets.put((Resource)rootProject, bucket);
        this.persistence.saveProject(rootProject);
        this.currentProject = rootProject;
        for (Project project : rootProject.getModules()) {
            this.addProject(project);
        }
    }

    private void addProject(Project project) {
        this.addResource((Resource)project);
        for (Project module : project.getModules()) {
            this.addProject(module);
        }
    }

    public Project getProject() {
        return this.currentProject;
    }

    public void setCurrentProject(Project project, ResourceFilters resourceFilters, ViolationFilters violationFilters, RulesProfile profile) {
        this.currentProject = project;
        this.resourceFilters = resourceFilters;
        this.violationFilters = violationFilters;
        this.profile = profile;
    }

    public void clear() {
        Iterator<Map.Entry<Resource, Bucket>> it = this.buckets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Resource, Bucket> entry = it.next();
            Resource resource = entry.getKey();
            if (ResourceUtils.isSet((Resource)resource)) continue;
            entry.getValue().clear();
            it.remove();
        }
        Set<Dependency> projectDependencies = this.getDependenciesBetweenProjects();
        this.dependencies.clear();
        this.incomingDependenciesByResource.clear();
        this.outgoingDependenciesByResource.clear();
        for (Dependency projectDependency : projectDependencies) {
            projectDependency.setId(null);
            this.registerDependency(projectDependency);
        }
        this.lock.unlock();
    }

    public Resource addResource(Resource resource) {
        Bucket bucket = this.getOrAddBucket(resource);
        return bucket != null ? bucket.getResource() : null;
    }

    public Resource getResource(Resource resource) {
        Bucket bucket = this.buckets.get(resource);
        if (bucket != null) {
            return bucket.getResource();
        }
        return null;
    }

    private Bucket getOrAddBucket(Resource resource) {
        Bucket bucket = this.buckets.get(resource);
        if (bucket != null) {
            return bucket;
        }
        if (this.lock.isLocked() && !ResourceUtils.isLibrary((Resource)resource)) {
            LOG.warn("The following resource has not been registered before saving data: " + resource);
        }
        resource.setEffectiveKey(DefaultIndex.calculateResourceEffectiveKey(this.currentProject, resource));
        bucket = new Bucket(resource);
        Bucket parentBucket = null;
        Resource parent = resource.getParent();
        if (parent != null) {
            parentBucket = this.getOrAddBucket(parent);
        } else if (!ResourceUtils.isLibrary((Resource)resource)) {
            parentBucket = this.buckets.get(this.currentProject);
        }
        bucket.setParent(parentBucket);
        this.buckets.put(resource, bucket);
        boolean excluded = this.checkExclusion(resource, parentBucket);
        if (!excluded) {
            this.persistence.saveResource(this.currentProject, resource);
        }
        return bucket;
    }

    static String calculateResourceEffectiveKey(Project project, Resource resource) {
        String effectiveKey = resource.getKey();
        if (!StringUtils.equals((String)"PRJ", (String)resource.getScope())) {
            effectiveKey = new StringBuilder(400).append(project.getKey()).append(':').append(resource.getKey()).toString();
        }
        return effectiveKey;
    }

    private boolean checkExclusion(Resource resource, Bucket parent) {
        boolean excluded = parent != null && parent.isExcluded() || this.resourceFilters != null && this.resourceFilters.isExcluded(resource);
        resource.setExcluded(excluded);
        return excluded;
    }

    public List<Resource> getChildren(Resource resource) {
        return this.getChildren(resource, false);
    }

    public List<Resource> getChildren(Resource resource, boolean includeExcludedResources) {
        ArrayList children = Lists.newArrayList();
        Bucket bucket = this.buckets.get(resource);
        if (bucket != null) {
            for (Bucket childBucket : bucket.getChildren()) {
                if (!includeExcludedResources && childBucket.isExcluded()) continue;
                children.add(childBucket.getResource());
            }
        }
        return children;
    }

    public Resource getParent(Resource resource) {
        Bucket bucket = this.buckets.get(resource);
        if (bucket != null && bucket.getParent() != null) {
            return bucket.getParent().getResource();
        }
        return null;
    }

    public Measure getMeasure(Resource resource, Metric metric) {
        Bucket bucket = this.buckets.get(resource);
        if (bucket != null) {
            return (Measure)bucket.getMeasures(MeasuresFilters.metric((Metric)metric));
        }
        return null;
    }

    public <M> M getMeasures(Resource resource, MeasuresFilter<M> filter) {
        Bucket bucket = this.buckets.get(resource);
        if (bucket != null) {
            return bucket.getMeasures(filter);
        }
        return null;
    }

    public Measure addMeasure(Resource resource, Measure measure) {
        Bucket bucket = this.getOrAddBucket(resource);
        if (!bucket.isExcluded()) {
            Metric metric = this.metricFinder.findByKey(measure.getMetricKey());
            if (metric == null) {
                throw new SonarException("Unknown metric: " + measure.getMetricKey());
            }
            measure.setMetric(metric);
            if (measure.getPersistenceMode().useMemory()) {
                bucket.addMeasure(measure);
            }
            if (measure.getPersistenceMode().useDatabase()) {
                this.persistence.saveMeasure(this.currentProject, resource, measure);
            }
        }
        return measure;
    }

    public void setSource(Resource resource, String source) {
        Bucket bucket = this.getOrAddBucket(resource);
        if (!bucket.isExcluded()) {
            this.persistence.setSource(this.currentProject, resource, source);
        }
    }

    public Dependency addDependency(Dependency dependency) {
        Dependency existingDep = this.getEdge(dependency.getFrom(), dependency.getTo());
        if (existingDep != null) {
            return existingDep;
        }
        Dependency parentDependency = dependency.getParent();
        if (parentDependency != null) {
            this.addDependency(parentDependency);
        }
        if (this.registerDependency(dependency)) {
            this.persistence.saveDependency(this.currentProject, dependency, parentDependency);
        }
        return dependency;
    }

    boolean registerDependency(Dependency dependency) {
        Bucket fromBucket = this.getOrAddBucket(dependency.getFrom());
        Bucket toBucket = this.getOrAddBucket(dependency.getTo());
        if (fromBucket != null && !fromBucket.isExcluded() && toBucket != null && !toBucket.isExcluded()) {
            this.dependencies.add(dependency);
            this.registerOutgoingDependency(dependency);
            this.registerIncomingDependency(dependency);
            return true;
        }
        return false;
    }

    private void registerOutgoingDependency(Dependency dependency) {
        Map<Resource, Dependency> outgoingDeps = this.outgoingDependenciesByResource.get(dependency.getFrom());
        if (outgoingDeps == null) {
            outgoingDeps = new HashMap<Resource, Dependency>();
            this.outgoingDependenciesByResource.put(dependency.getFrom(), outgoingDeps);
        }
        outgoingDeps.put(dependency.getTo(), dependency);
    }

    private void registerIncomingDependency(Dependency dependency) {
        Map<Resource, Dependency> incomingDeps = this.incomingDependenciesByResource.get(dependency.getTo());
        if (incomingDeps == null) {
            incomingDeps = new HashMap<Resource, Dependency>();
            this.incomingDependenciesByResource.put(dependency.getTo(), incomingDeps);
        }
        incomingDeps.put(dependency.getFrom(), dependency);
    }

    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    public Dependency getEdge(Resource from, Resource to) {
        Map<Resource, Dependency> map = this.outgoingDependenciesByResource.get(from);
        if (map != null) {
            return map.get(to);
        }
        return null;
    }

    public boolean hasEdge(Resource from, Resource to) {
        return this.getEdge(from, to) != null;
    }

    public Set<Resource> getVertices() {
        return this.buckets.keySet();
    }

    public Collection<Dependency> getOutgoingEdges(Resource from) {
        Map<Resource, Dependency> deps = this.outgoingDependenciesByResource.get(from);
        if (deps != null) {
            return deps.values();
        }
        return Collections.emptyList();
    }

    public Collection<Dependency> getIncomingEdges(Resource to) {
        Map<Resource, Dependency> deps = this.incomingDependenciesByResource.get(to);
        if (deps != null) {
            return deps.values();
        }
        return Collections.emptyList();
    }

    Set<Dependency> getDependenciesBetweenProjects() {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (Dependency dependency : this.dependencies) {
            if (!ResourceUtils.isSet((Resource)dependency.getFrom()) && !ResourceUtils.isSet((Resource)dependency.getTo())) continue;
            result.add(dependency);
        }
        return result;
    }

    public List<Violation> getViolations(Resource resource) {
        Bucket bucket = this.buckets.get(resource);
        if (bucket == null) {
            return Collections.emptyList();
        }
        return bucket.getViolations();
    }

    public void addViolation(Violation violation, boolean force) {
        Bucket bucket;
        Resource resource = violation.getResource();
        if (resource == null) {
            violation.setResource((Resource)this.currentProject);
        }
        if (!(bucket = this.getOrAddBucket(violation.getResource())).isExcluded()) {
            boolean isIgnored;
            boolean bl = isIgnored = !force && this.violationFilters != null && this.violationFilters.isIgnored(violation);
            if (!isIgnored) {
                ActiveRule activeRule = this.profile.getActiveRule(violation.getRule());
                if (activeRule == null) {
                    if (this.currentProject.getReuseExistingRulesConfig()) {
                        violation.setSeverity(violation.getRule().getSeverity());
                        this.doAddViolation(violation, bucket);
                    } else {
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).debug("Rule is not activated, ignoring violation {}", (Object)violation);
                    }
                } else {
                    violation.setSeverity(activeRule.getSeverity());
                    this.doAddViolation(violation, bucket);
                }
            }
        }
    }

    private void doAddViolation(Violation violation, Bucket bucket) {
        bucket.addViolation(violation);
    }

    public void addLink(ProjectLink link) {
        this.persistence.saveLink(this.currentProject, link);
    }

    public void deleteLink(String key) {
        this.persistence.deleteLink(this.currentProject, key);
    }

    public List<Event> getEvents(Resource resource) {
        return this.persistence.getEvents(resource);
    }

    public void deleteEvent(Event event) {
        this.persistence.deleteEvent(event);
    }

    public Event addEvent(Resource resource, String name, String description, String category, Date date) {
        Event event = new Event(name, description, category);
        event.setDate(date);
        this.persistence.saveEvent(this.currentProject, resource, event);
        return null;
    }
}

