/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.ResourceModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectLink;
import org.sonar.api.resources.Resource;
import org.sonar.batch.index.ResourcePersister;

public final class LinkPersister {
    private DatabaseSession session;
    private ResourcePersister resourcePersister;

    public LinkPersister(DatabaseSession session, ResourcePersister resourcePersister) {
        this.session = session;
        this.resourcePersister = resourcePersister;
    }

    public void saveLink(Project project, ProjectLink link) {
        Snapshot snapshot = this.resourcePersister.getSnapshot((Resource)project);
        if (snapshot != null) {
            ResourceModel projectDao = (ResourceModel)this.session.reattach(ResourceModel.class, (Object)snapshot.getResourceId());
            ProjectLink dbLink = projectDao.getProjectLink(link.getKey());
            if (dbLink == null) {
                link.setResource(projectDao);
                projectDao.getProjectLinks().add(link);
                this.session.save((Object)link);
            } else {
                dbLink.copyFieldsFrom(link);
                this.session.save((Object)dbLink);
            }
            this.session.commit();
        }
    }

    public void deleteLink(Project project, String linkKey) {
        ResourceModel model;
        ProjectLink dbLink;
        Snapshot snapshot = this.resourcePersister.getSnapshot((Resource)project);
        if (snapshot != null && (dbLink = (model = (ResourceModel)this.session.reattach(ResourceModel.class, (Object)snapshot.getResourceId())).getProjectLink(linkKey)) != null) {
            this.session.remove((Object)dbLink);
            model.getProjectLinks().remove(dbLink);
            this.session.commit();
        }
    }
}

