/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.channel;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelDispatcher<OUTPUT>
extends Channel<OUTPUT> {
    private static final Logger logger = LoggerFactory.getLogger(ChannelDispatcher.class);
    private final boolean failIfNoChannelToConsumeOneCharacter;
    private final Channel[] channels;

    public ChannelDispatcher(List<Channel> tokenizers) {
        this(tokenizers, false);
    }

    public ChannelDispatcher(List<Channel> tokenizers, boolean failIfNoChannelToConsumeOneCharacter) {
        this.channels = tokenizers.toArray(new Channel[0]);
        this.failIfNoChannelToConsumeOneCharacter = failIfNoChannelToConsumeOneCharacter;
    }

    @Override
    public boolean consume(CodeReader code, OUTPUT output) {
        int nextChar = code.peek();
        while (nextChar != -1) {
            boolean channelConsumed = false;
            for (Channel channel : this.channels) {
                if (!channel.consume(code, output)) continue;
                channelConsumed = true;
                break;
            }
            if (!channelConsumed) {
                String message = "None of the channel has been able to handle character '" + (char)code.peek() + "' (decimal value " + code.peek() + ") at line " + code.getLinePosition() + ", column " + code.getColumnPosition();
                if (this.failIfNoChannelToConsumeOneCharacter) {
                    throw new IllegalStateException(message);
                }
                logger.debug(message);
                code.pop();
            }
            nextChar = code.peek();
        }
        return true;
    }
}

