/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.projectapi.AuxiliaryConfigBasedPreferencesProvider;
import org.netbeans.modules.projectapi.AuxiliaryConfigImpl;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.CacheDirectoryProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.Parameters;

public class ProjectUtils {
    private static final Logger LOG = Logger.getLogger(ProjectUtils.class.getName());

    private ProjectUtils() {
    }

    public static ProjectInformation getInformation(Project p) {
        ProjectInformation pi = (ProjectInformation)p.getLookup().lookup(ProjectInformation.class);
        if (pi != null) {
            return pi;
        }
        return new BasicInformation(p);
    }

    public static Sources getSources(Project p) {
        Sources s = (Sources)p.getLookup().lookup(Sources.class);
        if (s != null) {
            return s;
        }
        return GenericSources.genericOnly(p);
    }

    public static boolean hasSubprojectCycles(final Project master, final Project candidate) {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                return ProjectUtils.visit(new HashMap(), master, master, candidate);
            }
        });
    }

    public static Preferences getPreferences(Project project, Class clazz, boolean shared) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"clazz", (Object)clazz);
        return AuxiliaryConfigBasedPreferencesProvider.getPreferences(project, clazz, shared);
    }

    private static boolean visit(Map<Project, Boolean> encountered, Project curr, Project master, Project candidate) {
        if (encountered.containsKey(curr)) {
            if (encountered.get(curr).booleanValue()) {
                return false;
            }
            LOG.log(Level.FINE, "Encountered cycle in {0} from {1} at {2} via {3}", new Object[]{master, candidate, curr, encountered});
            return true;
        }
        encountered.put(curr, false);
        SubprojectProvider spp = (SubprojectProvider)curr.getLookup().lookup(SubprojectProvider.class);
        if (spp != null) {
            Set<? extends Project> subprojects = spp.getSubprojects();
            LOG.log(Level.FINEST, "Found subprojects {0} from {1}", new Object[]{subprojects, curr});
            for (Project project : subprojects) {
                if (ProjectUtils.visit(encountered, project, master, candidate)) {
                    return true;
                }
                if (candidate != project) continue;
                candidate = null;
            }
        }
        if (candidate != null && curr == master && ProjectUtils.visit(encountered, candidate, master, candidate)) {
            return true;
        }
        assert (!encountered.get(curr).booleanValue());
        encountered.put(curr, true);
        return false;
    }

    public static AuxiliaryConfiguration getAuxiliaryConfiguration(Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        return new AuxiliaryConfigImpl(project);
    }

    public static FileObject getCacheDirectory(Project project, Class<?> owner) throws IOException {
        CacheDirectoryProvider cdp = (CacheDirectoryProvider)project.getLookup().lookup(CacheDirectoryProvider.class);
        FileObject d = cdp != null ? cdp.getCacheDirectory() : FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)String.format("Projects/extra/%s-%08x", ProjectUtils.getInformation(project).getName().replace('/', '_'), project.getProjectDirectory().getPath().hashCode()));
        return FileUtil.createFolder((FileObject)d, (String)AuxiliaryConfigBasedPreferencesProvider.findCNBForClass(owner));
    }

    private static final class BasicInformation
    implements ProjectInformation {
        private final Project p;

        public BasicInformation(Project p) {
            this.p = p;
        }

        @Override
        public String getName() {
            try {
                return this.p.getProjectDirectory().getURL().toExternalForm();
            }
            catch (FileStateInvalidException e) {
                return e.toString();
            }
        }

        @Override
        public String getDisplayName() {
            return this.p.getProjectDirectory().getNameExt();
        }

        @Override
        public Icon getIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/projectapi/resources/empty.gif", (boolean)false);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public Project getProject() {
            return this.p;
        }
    }
}

