/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectapi;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.projectapi.MetaLookupMerger;
import org.netbeans.spi.project.LookupMerger;
import org.netbeans.spi.project.LookupProvider;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class LazyLookupProviders {
    private LazyLookupProviders() {
    }

    public static LookupProvider forProjectServiceProvider(final Map<String, Object> attrs) throws ClassNotFoundException {
        return new LookupProvider(){

            @Override
            public Lookup createAdditionalLookup(final Lookup lkp) {
                return new ProxyLookup(){
                    Collection<String> serviceNames;
                    {
                        this.serviceNames = Arrays.asList(((String)attrs.get("service")).split(","));
                    }

                    protected void beforeLookup(Lookup.Template<?> template) {
                        if (this.serviceNames != null && this.serviceNames.contains(template.getType().getName())) {
                            Class service = template.getType();
                            try {
                                Object instance = LazyLookupProviders.loadPSPInstance((String)attrs.get("class"), (String)attrs.get("method"), lkp);
                                if (!service.isInstance(instance)) {
                                    throw new ClassCastException("Instance of " + instance.getClass() + " unassignable to " + service);
                                }
                                this.setLookups(new Lookup[]{Lookups.singleton((Object)instance)});
                                this.serviceNames = null;
                            }
                            catch (Exception x) {
                                Exceptions.attachMessage((Throwable)x, (String)("while loading from " + attrs));
                                Exceptions.printStackTrace((Throwable)x);
                            }
                        }
                    }
                };
            }
        };
    }

    private static Object loadPSPInstance(String implName, String methodName, Lookup lkp) throws Exception {
        ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        Class<?> clazz = loader.loadClass(implName);
        if (methodName == null) {
            for (Constructor<?> c : clazz.getConstructors()) {
                Object[] vals = LazyLookupProviders.valuesFor(c.getParameterTypes(), lkp);
                if (vals == null) continue;
                return c.newInstance(vals);
            }
        } else {
            for (Method m : clazz.getMethods()) {
                Object[] vals;
                if (!m.getName().equals(methodName) || (vals = LazyLookupProviders.valuesFor(m.getParameterTypes(), lkp)) == null) continue;
                return m.invoke(null, vals);
            }
        }
        throw new RuntimeException(implName + "." + methodName);
    }

    private static Object[] valuesFor(Class[] params, Lookup lkp) {
        if (params.length > 2) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (Class param : params) {
            if (param == Lookup.class) {
                values.add(lkp);
                continue;
            }
            if (param == Project.class) {
                Project project = (Project)lkp.lookup(Project.class);
                if (project == null) {
                    throw new IllegalArgumentException("Lookup " + lkp + " did not contain any Project instance");
                }
                values.add(project);
                continue;
            }
            return null;
        }
        return values.toArray();
    }

    public static MetaLookupMerger forLookupMerger(final Map<String, Object> attrs) throws ClassNotFoundException {
        return new MetaLookupMerger(){
            private final String serviceName;
            private LookupMerger<?> delegate;
            private final ChangeSupport cs;
            {
                this.serviceName = (String)attrs.get("service");
                this.cs = new ChangeSupport((Object)this);
            }

            @Override
            public void probing(Class<?> service) {
                if (this.delegate == null && service.getName().equals(this.serviceName)) {
                    try {
                        LookupMerger m = (LookupMerger)attrs.get("lookupMergerInstance");
                        if (service != m.getMergeableClass()) {
                            throw new ClassCastException(service + " vs. " + m.getMergeableClass());
                        }
                        this.delegate = m;
                        this.cs.fireChange();
                    }
                    catch (Exception x) {
                        Exceptions.printStackTrace((Throwable)x);
                    }
                }
            }

            @Override
            public LookupMerger merger() {
                return this.delegate;
            }

            @Override
            public void addChangeListener(ChangeListener listener) {
                this.cs.addChangeListener(listener);
                assert (this.cs.hasListeners());
            }

            @Override
            public void removeChangeListener(ChangeListener listener) {
                this.cs.removeChangeListener(listener);
            }

            public String toString() {
                return "MetaLookupMerger[" + this.serviceName + "]";
            }
        };
    }
}

