/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.spi.viewmodel.Models;
import org.openide.util.WeakSet;

public class DefaultTreeExpansionManager {
    private static Map<Models.CompoundModel, DefaultTreeExpansionManager> managers = new WeakHashMap<Models.CompoundModel, DefaultTreeExpansionManager>();
    private Object currentChildren;
    private Map<Object, Set<Object>> expandedNodes = new HashMap<Object, Set<Object>>();

    public static synchronized DefaultTreeExpansionManager get(Models.CompoundModel model) {
        if (model == null) {
            throw new NullPointerException();
        }
        DefaultTreeExpansionManager manager = managers.get(model);
        if (manager == null) {
            manager = new DefaultTreeExpansionManager();
            managers.put(model, manager);
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void copyExpansions(Models.CompoundModel oldCM, Models.CompoundModel newCM) {
        HashMap<Object, Set<Object>> expandedNodes;
        DefaultTreeExpansionManager oldManager = DefaultTreeExpansionManager.get(oldCM);
        DefaultTreeExpansionManager newManager = DefaultTreeExpansionManager.get(newCM);
        DefaultTreeExpansionManager defaultTreeExpansionManager = oldManager;
        synchronized (defaultTreeExpansionManager) {
            expandedNodes = new HashMap<Object, Set<Object>>(oldManager.expandedNodes);
        }
        defaultTreeExpansionManager = newManager;
        synchronized (defaultTreeExpansionManager) {
            newManager.expandedNodes.putAll(expandedNodes);
        }
    }

    private DefaultTreeExpansionManager() {
    }

    public void setChildrenToActOn(Object ch) {
        this.currentChildren = ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isExpanded(Object child) {
        if (this.currentChildren == null) {
            throw new NullPointerException("Call setChildrenToActOn() before!!!");
        }
        try {
            Set<Object> expanded = this.expandedNodes.get(this.currentChildren);
            if (expanded != null && expanded.contains(child)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.currentChildren = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setExpanded(Object child) {
        if (this.currentChildren == null) {
            throw new NullPointerException("Call setChildrenToActOn() before!!!");
        }
        try {
            WeakSet expanded = this.expandedNodes.get(this.currentChildren);
            if (expanded == null) {
                expanded = new WeakSet();
                this.expandedNodes.put(this.currentChildren, (Set<Object>)expanded);
            }
            expanded.add((Object)child);
        }
        finally {
            this.currentChildren = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCollapsed(Object child) {
        if (this.currentChildren == null) {
            throw new NullPointerException("Call setChildrenToActOn() before!!!");
        }
        try {
            Set<Object> expanded = this.expandedNodes.get(this.currentChildren);
            if (expanded != null) {
                expanded.remove(child);
            }
        }
        finally {
            this.currentChildren = null;
        }
    }
}

