/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.event.ActionEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.awt.ContextAction;
import org.openide.awt.ContextSelection;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

class ContextManager {
    private static final Map<LookupRef, Reference<ContextManager>> CACHE = new HashMap<LookupRef, Reference<ContextManager>>();
    private static final Map<LookupRef, Reference<ContextManager>> SURVIVE = new HashMap<LookupRef, Reference<ContextManager>>();
    private Map<Class, LSet> listeners = new HashMap<Class, LSet>();
    private Lookup lookup;
    private LSet<Lookup.Provider> selectionAll;

    private ContextManager(Lookup lookup) {
        this.lookup = lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContextManager findManager(Lookup context, boolean survive) {
        Map<LookupRef, Reference<ContextManager>> map = CACHE;
        synchronized (map) {
            ContextManager g;
            Map<LookupRef, Reference<ContextManager>> map2 = survive ? SURVIVE : CACHE;
            LookupRef lr = new LookupRef(context);
            GMReference ref = map2.get(lr);
            ContextManager contextManager = g = ref == null ? null : ref.get();
            if (g == null) {
                g = survive ? new SurviveManager(context) : new ContextManager(context);
                ref = new GMReference(g, lr, survive);
                map2.put(lr, ref);
            }
            return g;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache(LookupRef lr, GMReference ref, boolean survive) {
        Map<LookupRef, Reference<ContextManager>> map = CACHE;
        synchronized (map) {
            Map<LookupRef, Reference<ContextManager>> map2;
            Map<LookupRef, Reference<ContextManager>> map3 = map2 = survive ? SURVIVE : CACHE;
            if (map2.get(lr) == ref) {
                map2.remove(lr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void registerListener(Class<T> type, ContextAction<T> a) {
        Map<LookupRef, Reference<ContextManager>> map = CACHE;
        synchronized (map) {
            Lookup.Result<T> result;
            LSet<T> existing = this.findLSet(type);
            if (existing == null) {
                result = this.createResult(this.lookup.lookupResult(type));
                existing = new LSet<T>(result, type);
                this.listeners.put(type, existing);
            }
            existing.add(a);
            if (a.selectMode == ContextSelection.ALL) {
                if (this.selectionAll == null) {
                    result = this.createResult(this.lookup.lookupResult(Lookup.Provider.class));
                    this.selectionAll = new LSet<Lookup.Provider>(result, Lookup.Provider.class);
                }
                this.selectionAll.add(a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void unregisterListener(Class<T> type, ContextAction<T> a) {
        Map<LookupRef, Reference<ContextManager>> map = CACHE;
        synchronized (map) {
            LSet<T> existing = this.findLSet(type);
            if (existing != null) {
                existing.remove(a);
                if (existing.isEmpty()) {
                    this.listeners.remove(type);
                }
            }
            if (a.selectMode == ContextSelection.ALL && this.selectionAll != null) {
                this.selectionAll.remove(a);
                if (this.selectionAll.isEmpty()) {
                    this.selectionAll = null;
                }
            }
        }
    }

    public boolean isSurvive() {
        return false;
    }

    public <T> boolean isEnabled(Class<T> type, ContextSelection selectMode, ContextAction.Performer<? super T> enabler) {
        Lookup.Result<T> result = this.findResult(type);
        boolean e = this.isEnabledOnData(result, type, selectMode);
        if (e && enabler != null) {
            e = enabler.enabled(this.listFromResult(result));
        }
        return e;
    }

    private <T> boolean isEnabledOnData(Lookup.Result<T> result, Class<T> type, ContextSelection selectMode) {
        switch (selectMode) {
            case EXACTLY_ONE: {
                HashSet instances = new HashSet(result.allItems());
                return instances.size() == 1;
            }
            case ANY: {
                return !result.allItems().isEmpty();
            }
            case EACH: {
                if (result.allItems().isEmpty()) {
                    return false;
                }
                Lookup.Result items = this.lookup.lookupResult(Lookup.Provider.class);
                if (result.allItems().size() != items.allItems().size()) {
                    return false;
                }
                Lookup.Template template = new Lookup.Template(type);
                for (Lookup.Provider prov : items.allInstances()) {
                    if (prov.getLookup().lookupItem(template) != null) continue;
                    return false;
                }
                return true;
            }
            case ALL: {
                if (result.allItems().isEmpty()) {
                    return false;
                }
                Lookup.Result items = this.lookup.lookupResult(Lookup.Provider.class);
                if (result.allItems().size() < items.allItems().size()) {
                    return false;
                }
                Lookup.Template template = new Lookup.Template(type);
                for (Lookup.Provider prov : items.allInstances()) {
                    if (prov.getLookup().lookupItem(template) != null) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> LSet<T> findLSet(Class<T> type) {
        Map<LookupRef, Reference<ContextManager>> map = CACHE;
        synchronized (map) {
            return this.listeners.get(type);
        }
    }

    private <T> Lookup.Result<T> findResult(Class<T> type) {
        LSet<T> lset = this.findLSet(type);
        Lookup.Result result = lset != null ? lset.result : this.lookup.lookupResult(type);
        return result;
    }

    protected <T> Lookup.Result<T> createResult(Lookup.Result<T> res) {
        return res;
    }

    public <T> void actionPerformed(ActionEvent e, ContextAction.Performer<? super T> perf, final Class<T> type, ContextSelection selectMode) {
        Lookup.Result<T> result = this.findResult(type);
        final List<T> all = this.listFromResult(result);
        class LkpAE
        implements Lookup.Provider {
            private Lookup lookup;

            LkpAE() {
            }

            public Lookup getLookup() {
                if (this.lookup == null) {
                    this.lookup = new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])all.toArray()), Lookups.exclude((Lookup)ContextManager.this.lookup, (Class[])new Class[]{type})});
                }
                return this.lookup;
            }
        }
        perf.actionPerformed(e, Collections.unmodifiableList(all), new LkpAE());
    }

    private <T> List<? extends T> listFromResult(Lookup.Result<T> result) {
        ArrayList all;
        Collection col = result.allInstances();
        if (col instanceof List) {
            all = (ArrayList)col;
        } else {
            ArrayList arr = new ArrayList();
            arr.addAll(col);
            all = arr;
        }
        return all;
    }

    static class LookupRef
    extends WeakReference<Lookup> {
        private final int hashCode;

        public LookupRef(Lookup referent) {
            super(referent);
            this.hashCode = System.identityHashCode(referent);
        }

        public boolean equals(Object obj) {
            if (obj instanceof LookupRef) {
                LookupRef lr = (LookupRef)obj;
                return this.get() == lr.get();
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static final class LSet<T>
    extends WeakSet<ContextAction>
    implements LookupListener,
    Runnable {
        final Lookup.Result<T> result;

        public LSet(Lookup.Result<T> context, Class<T> type) {
            this.result = context;
            this.result.addLookupListener((LookupListener)this);
            this.result.allItems();
        }

        public void resultChanged(LookupEvent ev) {
            Mutex.EVENT.readAccess((Runnable)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ContextAction[] arr;
            Map map = CACHE;
            synchronized (map) {
                arr = (ContextAction[])this.toArray(new ContextAction[0]);
            }
            for (ContextAction a : arr) {
                a.updateState();
            }
        }
    }

    private static final class NeverEmptyResult<T>
    extends Lookup.Result<T> {
        private final Lookup.Result<T> delegate;
        private Collection<? extends Lookup.Item<T>> allItems = Collections.emptyList();
        private Collection<? extends T> allInstances = Collections.emptyList();
        private Set<Class<? extends T>> allClasses = Collections.emptySet();

        public NeverEmptyResult(Lookup.Result<T> delegate) {
            this.delegate = delegate;
        }

        public void addLookupListener(LookupListener l) {
            this.delegate.addLookupListener(l);
        }

        public void removeLookupListener(LookupListener l) {
            this.delegate.removeLookupListener(l);
        }

        public Collection<? extends Lookup.Item<T>> allItems() {
            Collection res = this.delegate.allItems();
            if (!res.isEmpty()) {
                this.allItems = res;
            }
            return this.allItems;
        }

        public Collection<? extends T> allInstances() {
            Collection res = this.delegate.allInstances();
            if (!res.isEmpty()) {
                this.allInstances = res;
            }
            return this.allInstances;
        }

        public Set<Class<? extends T>> allClasses() {
            Set res = this.delegate.allClasses();
            if (!res.isEmpty()) {
                this.allClasses = res;
            }
            return this.allClasses;
        }
    }

    private static final class SurviveManager
    extends ContextManager {
        private SurviveManager(Lookup context) {
            super(context);
        }

        @Override
        public boolean isSurvive() {
            return true;
        }

        @Override
        protected <T> Lookup.Result<T> createResult(Lookup.Result<T> res) {
            return new NeverEmptyResult<T>(res);
        }
    }

    private static final class GMReference
    extends WeakReference<ContextManager>
    implements Runnable {
        private LookupRef context;
        private boolean survive;

        public GMReference(ContextManager m, LookupRef context, boolean survive) {
            super(m, Utilities.activeReferenceQueue());
            this.context = context;
            this.survive = survive;
        }

        @Override
        public void run() {
            ContextManager.clearCache(this.context, this, this.survive);
        }
    }
}

