/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.naming;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.FolderName;
import org.netbeans.modules.masterfs.filebasedfs.naming.NameRef;
import org.netbeans.modules.masterfs.filebasedfs.utils.Utils;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;

public final class NamingFactory {
    private static NameRef[] names = new NameRef[2];
    private static int namesCount;

    public static synchronized FileNaming fromFile(File file) {
        LinkedList<File> list = new LinkedList<File>();
        for (File current = file; current != null; current = current.getParentFile()) {
            list.addFirst(current);
        }
        FileNaming fileName = null;
        for (int i = 0; i < list.size(); ++i) {
            File f = (File)list.get(i);
            if ("\\\\".equals(f.getPath())) {
                ++i;
                continue;
            }
            FileType type = i == list.size() - 1 ? FileType.unknown : FileType.directory;
            fileName = NamingFactory.registerInstanceOfFileNaming(fileName, f, type);
        }
        return fileName;
    }

    public static synchronized int getSize() {
        return namesCount;
    }

    public static synchronized FileNaming fromFile(FileNaming parentFn, File file, boolean ignoreCache) {
        return NamingFactory.registerInstanceOfFileNaming(parentFn, file, null, ignoreCache, FileType.unknown);
    }

    public static synchronized FileNaming checkCaseSensitivity(FileNaming childName, File f) throws IOException {
        if (!childName.getFile().getName().equals(f.getName())) {
            boolean isCaseSensitive;
            boolean bl = isCaseSensitive = !Utils.equals(new File(f, "a"), new File(f, "A"));
            if (!isCaseSensitive) {
                FileName fn = (FileName)childName;
                fn.updateCase(f.getName());
            }
        }
        return childName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileNaming[] rename(FileNaming fNaming, String newName, ProvidedExtensions.IOHandler handler) throws IOException {
        LinkedHashSet<FileNaming> all = new LinkedHashSet<FileNaming>();
        FileNaming newNaming = fNaming.rename(newName, handler);
        boolean retVal = newNaming != fNaming;
        Class<NamingFactory> clazz = NamingFactory.class;
        synchronized (NamingFactory.class) {
            all.add(newNaming);
            NamingFactory.renameChildren(fNaming, all);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return retVal ? all.toArray(new FileNaming[all.size()]) : null;
        }
    }

    private static void renameChildren(FileNaming root, Collection<FileNaming> all) {
        assert (Thread.holdsLock(NamingFactory.class));
        HashSet not = new HashSet(names.length);
        for (int i = 0; i < names.length; ++i) {
            block1: for (NameRef value = names[i]; value != null; value = value.next()) {
                FileNaming fN = (FileNaming)value.get();
                LinkedList<FileNaming> above = new LinkedList<FileNaming>();
                FileNaming up = fN;
                while (true) {
                    if (up == null || not.contains(up)) {
                        not.addAll(above);
                        continue block1;
                    }
                    above.addFirst(up);
                    if (root.equals(up) || all.contains(up)) {
                        all.addAll(above);
                        continue block1;
                    }
                    up = up.getParent();
                }
            }
        }
    }

    public static Integer createID(File file) {
        return Utils.hashCode(file);
    }

    private static FileNaming registerInstanceOfFileNaming(FileNaming parentName, File file, FileType type) {
        return NamingFactory.registerInstanceOfFileNaming(parentName, file, null, false, type);
    }

    private static void rehash(int newSize) {
        int i;
        assert (Thread.holdsLock(NamingFactory.class));
        NameRef[] arr = new NameRef[newSize];
        for (i = 0; i < names.length; ++i) {
            NameRef v = names[i];
            if (v == null) continue;
            for (NameRef nr : names[i].disconnectAll()) {
                FileNaming fn = (FileNaming)nr.get();
                if (fn == null) continue;
                Integer id = NamingFactory.createID(fn.getFile());
                int index = Math.abs(id) % arr.length;
                NameRef prev = arr[index];
                arr[index] = nr;
                if (prev == null) {
                    nr.setIndex(index);
                    continue;
                }
                nr.setNext(prev);
            }
        }
        for (i = 0; i < arr.length; ++i) {
            assert (NamingFactory.checkIndex(arr, i));
        }
        names = arr;
    }

    private static FileNaming registerInstanceOfFileNaming(FileNaming parentName, File file, FileNaming newValue, boolean ignoreCache, FileType type) {
        FileNaming retVal;
        assert (Thread.holdsLock(NamingFactory.class));
        NamingFactory.cleanQueue();
        Integer key = NamingFactory.createID(file);
        int index = Math.abs(key) % names.length;
        NameRef ref = NamingFactory.getReference(names[index], file);
        FileNaming cachedElement = ref != null ? (FileNaming)ref.get() : null;
        Boolean cachedIsDirectory = null;
        Boolean fileIsDirectory = null;
        if (ignoreCache) {
            if (cachedElement != null && (cachedIsDirectory = Boolean.valueOf(cachedElement.isDirectory())) != (fileIsDirectory = Boolean.valueOf(file.isDirectory()))) {
                cachedElement = null;
            }
            if (cachedElement != null) {
                try {
                    NamingFactory.checkCaseSensitivity(cachedElement, file);
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        Boolean filesEqual = null;
        if (cachedElement != null && (filesEqual = Boolean.valueOf(Utils.equals(cachedElement.getFile(), file))).booleanValue()) {
            retVal = cachedElement;
        } else {
            block18: {
                retVal = newValue == null ? NamingFactory.createFileNaming(file, key, parentName, type) : newValue;
                NameRef refRetVal = new NameRef(retVal);
                NameRef prev = names[index];
                NamingFactory.names[index] = refRetVal;
                if (prev == null) {
                    refRetVal.setIndex(index);
                } else {
                    refRetVal.setNext(prev);
                }
                assert (NamingFactory.checkIndex(names, index));
                if (ref != null) {
                    NameRef nr = refRetVal;
                    while (true) {
                        if (nr.next() == ref) {
                            FileNaming orig = (FileNaming)ref.get();
                            if (orig instanceof FileName) {
                                ((FileName)orig).recordCleanup("cachedElement: " + cachedElement + " ref: " + orig + " file: " + file + " filesEqual: " + filesEqual + " cachedIsDirectory: " + cachedIsDirectory + " fileIsDirectory: " + fileIsDirectory);
                            }
                            ref.clear();
                            nr.skip(ref);
                            break block18;
                        }
                        nr = nr.next();
                    }
                }
                ++namesCount;
            }
            assert (NamingFactory.checkIndex(names, index));
            if (namesCount * 4 > names.length * 3) {
                NamingFactory.rehash(names.length * 2);
            }
        }
        assert (retVal != null);
        return retVal;
    }

    private static NameRef getReference(NameRef value, File f) {
        while (value != null) {
            FileNaming fn = (FileNaming)value.get();
            if (fn != null && Utils.equals(fn.getFile(), f)) {
                return value;
            }
            value = value.next();
        }
        return null;
    }

    private static FileNaming createFileNaming(File f, Integer theKey, FileNaming parentName, FileType type) {
        FileName retVal = null;
        if (type.equals((Object)FileType.unknown)) {
            type = f.isDirectory() ? FileType.directory : FileType.file;
        }
        switch (type) {
            case file: {
                retVal = new FileName(parentName, f, theKey);
                break;
            }
            case directory: {
                retVal = new FolderName(parentName, f, theKey);
            }
        }
        return retVal;
    }

    public static String dumpId(Integer id) {
        return NamingFactory.dump(id, null);
    }

    public static synchronized boolean isValid(FileNaming fn) {
        int index = Math.abs(fn.getId()) % names.length;
        for (NameRef value = names[index]; value != null; value = value.next()) {
            if (value.get() != fn) continue;
            return true;
        }
        return false;
    }

    static synchronized String dump(Integer id, File file) {
        StringBuilder sb = new StringBuilder();
        String hex = Integer.toHexString(id);
        sb.append("Showing references to ").append(hex).append("\n");
        int cnt = 0;
        int index = Math.abs(id) % names.length;
        for (NameRef value = names[index]; value != null; value = value.next()) {
            if (file != null && !file.equals(value.getFile())) continue;
            ++cnt;
            NamingFactory.dumpFileNaming(sb, value.get());
        }
        sb.append("References: ").append(cnt);
        return sb.toString();
    }

    private static void dumpFileNaming(StringBuilder sb, Object fn) {
        if (fn == null) {
            sb.append("null");
            return;
        }
        if (fn instanceof FolderName) {
            sb.append("FolderName: ");
        } else {
            sb.append("FileName: ");
        }
        sb.append(fn).append("#").append(Integer.toHexString(fn.hashCode())).append("@").append(Integer.toHexString(System.identityHashCode(fn))).append("\n");
        if (fn instanceof FileName) {
            ((FileName)fn).dumpCreation(sb);
        }
    }

    private static void cleanQueue() {
        assert (Thread.holdsLock(NamingFactory.class));
        while (true) {
            NameRef nr;
            if ((nr = (NameRef)NameRef.QUEUE.poll()) == null) {
                return;
            }
            int index = nr.getIndex();
            if (index == -1) continue;
            if (names[index] != null) {
                NamingFactory.names[index] = names[index].remove(nr);
                --namesCount;
            }
            if (!$assertionsDisabled && !NamingFactory.checkIndex(names, index)) break;
        }
        throw new AssertionError();
    }

    private static boolean checkIndex(NameRef[] arr, int index) {
        if (arr[index] == null) {
            return true;
        }
        return index == arr[index].getIndex();
    }

    static enum FileType {
        file,
        directory,
        unknown;

    }
}

