/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.netbeans.modules.maven.LogicalViewProviderImpl;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.nodes.AnnotatedAbstractNode;
import org.netbeans.modules.maven.nodes.DependenciesNode;
import org.netbeans.modules.maven.nodes.OthersRootChildren;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

class OthersRootNode
extends AnnotatedAbstractNode {
    private FileObject file;
    private static final String SHOW_AS_PACKAGES = "show.as.packages";
    private static final String PREF_RESOURCES_UI = "org/netbeans/modules/maven/resources/ui";

    OthersRootNode(NbMavenProjectImpl mavproject, boolean testResource, FileObject fo) {
        super((Children)new OthersRootChildren(mavproject, testResource), Lookups.fixed((Object[])new Object[]{fo, DataFolder.findFolder((FileObject)fo), new ChildDelegateFind()}));
        this.setName(testResource ? "OtherTestRoots" : "OtherRoots");
        this.setDisplayName(testResource ? NbBundle.getMessage(OthersRootNode.class, (String)"LBL_Other_Test_Sources") : NbBundle.getMessage(OthersRootNode.class, (String)"LBL_Other_Sources"));
        this.file = fo;
    }

    public Action[] getActions(boolean context) {
        List<Action> supers = Arrays.asList(super.getActions(context));
        ArrayList<Action> lst = new ArrayList<Action>(supers.size() + 5);
        lst.addAll(supers);
        lst.add(new ShowAsPackagesAction());
        Action[] retValue = new Action[lst.size()];
        retValue = lst.toArray(retValue);
        return retValue;
    }

    private Image getIcon(boolean opened) {
        Image badge = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/others-badge.png", (boolean)true);
        return ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(opened), (Image)badge, (int)8, (int)8);
    }

    @Override
    protected Image getIconImpl(int param) {
        return this.getIcon(false);
    }

    @Override
    protected Image getOpenedIconImpl(int param) {
        return this.getIcon(true);
    }

    public String getDisplayName() {
        String s = super.getDisplayName();
        try {
            s = this.file.getFileSystem().getStatus().annotateName(s, Collections.singleton(this.file));
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return s;
    }

    public String getHtmlDisplayName() {
        try {
            FileSystem.Status stat = this.file.getFileSystem().getStatus();
            if (stat instanceof FileSystem.HtmlStatus) {
                FileSystem.HtmlStatus hstat = (FileSystem.HtmlStatus)stat;
                String result = hstat.annotateNameHtml(super.getDisplayName(), Collections.singleton(this.file));
                if (!super.getDisplayName().equals(result)) {
                    return result;
                }
            }
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return super.getHtmlDisplayName();
    }

    static boolean showAsPackages() {
        Preferences prefs = NbPreferences.root().node(PREF_RESOURCES_UI);
        boolean b = prefs.getBoolean(SHOW_AS_PACKAGES, true);
        return b;
    }

    static class ChildDelegateFind
    implements LogicalViewProviderImpl.FindDelegate {
        ChildDelegateFind() {
        }

        @Override
        public Node[] getDelegates(Node current) {
            return current.getChildren().getNodes(true);
        }
    }

    private class ShowAsPackagesAction
    extends AbstractAction
    implements Presenter.Popup {
        public ShowAsPackagesAction() {
            String s = NbBundle.getMessage(DependenciesNode.class, (String)"LBL_ShowAsPackages");
            this.putValue("Name", s);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean b = OthersRootNode.showAsPackages();
            Preferences prefs = NbPreferences.root().node(OthersRootNode.PREF_RESOURCES_UI);
            prefs.putBoolean(OthersRootNode.SHOW_AS_PACKAGES, !b);
            try {
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            ((OthersRootChildren)OthersRootNode.this.getChildren()).doRefresh();
        }

        public JMenuItem getPopupPresenter() {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(this);
            mi.setSelected(OthersRootNode.showAsPackages());
            return mi;
        }
    }
}

