/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.cache;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.sonar.runner.cache.DeleteFileOnCloseInputStream;
import org.sonar.runner.cache.DirectoryLock;
import org.sonar.runner.cache.Logger;
import org.sonar.runner.cache.PersistentCacheInvalidation;

public class PersistentCache {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private static final String DIGEST_ALGO = "MD5";
    private final PersistentCacheInvalidation invalidation;
    private final Logger logger;
    private final Path dir;
    private DirectoryLock lock;

    PersistentCache(Path dir, PersistentCacheInvalidation invalidation, Logger logger, DirectoryLock lock) {
        this.dir = dir;
        this.invalidation = invalidation;
        this.logger = logger;
        this.lock = lock;
        this.reconfigure();
        logger.debug("cache: " + dir);
    }

    public synchronized void reconfigure() {
        try {
            Files.createDirectories(this.dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to create cache dir", e);
        }
    }

    public Path getDirectory() {
        return this.dir;
    }

    @CheckForNull
    public synchronized String getString(@Nonnull String obj) throws IOException {
        byte[] cached = this.get(obj);
        if (cached == null) {
            return null;
        }
        return new String(cached, ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public synchronized InputStream getStream(@Nonnull String obj) throws IOException {
        String key = PersistentCache.getKey(obj);
        try {
            this.lock();
            Path path = this.getCacheCopy(key);
            if (path == null) {
                InputStream inputStream = null;
                return inputStream;
            }
            DeleteFileOnCloseInputStream deleteFileOnCloseInputStream = new DeleteFileOnCloseInputStream(new FileInputStream(path.toFile()), path);
            return deleteFileOnCloseInputStream;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public synchronized byte[] get(@Nonnull String obj) throws IOException {
        String key = PersistentCache.getKey(obj);
        try {
            this.lock();
            byte[] cached = this.getCache(key);
            if (cached != null) {
                this.logger.debug("cache hit for " + obj + " -> " + key);
                byte[] byArray = cached;
                return byArray;
            }
            this.logger.debug("cache miss for " + obj + " -> " + key);
        }
        finally {
            this.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void put(@Nonnull String obj, @Nonnull InputStream stream) throws IOException {
        String key = PersistentCache.getKey(obj);
        try {
            this.lock();
            this.putCache(key, stream);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void put(@Nonnull String obj, @Nonnull byte[] value) throws IOException {
        String key = PersistentCache.getKey(obj);
        try {
            this.lock();
            this.putCache(key, value);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        this.logger.info("cache: clearing");
        try {
            this.lock();
            this.deleteCacheEntries(new DirectoryClearFilter());
        }
        catch (IOException e) {
            this.logger.error("Error clearing cache", e);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clean() {
        this.logger.info("cache: cleaning");
        try {
            this.lock();
            this.deleteCacheEntries(new DirectoryCleanFilter());
        }
        catch (IOException e) {
            this.logger.error("Error cleaning cache", e);
        }
        finally {
            this.unlock();
        }
    }

    private void lock() throws IOException {
        this.lock.lock();
    }

    private void unlock() {
        this.lock.unlock();
    }

    private static String getKey(String uri) {
        try {
            String key = uri;
            MessageDigest digest = MessageDigest.getInstance(DIGEST_ALGO);
            digest.update(key.getBytes(StandardCharsets.UTF_8));
            return PersistentCache.byteArrayToHex(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Couldn't create hash", e);
        }
    }

    private void deleteCacheEntries(DirectoryStream.Filter<Path> filter) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.dir, filter);){
            for (Path p : stream) {
                try {
                    Files.delete(p);
                }
                catch (Exception e) {
                    this.logger.error("Error deleting " + p, e);
                }
            }
        }
    }

    private void putCache(String key, byte[] value) throws IOException {
        Path cachePath = this.getCacheEntryPath(key);
        Files.write(cachePath, value, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private void putCache(String key, InputStream stream) throws IOException {
        Path cachePath = this.getCacheEntryPath(key);
        Files.copy(stream, cachePath, StandardCopyOption.REPLACE_EXISTING);
    }

    private byte[] getCache(String key) throws IOException {
        Path cachePath = this.getCacheEntryPath(key);
        if (!this.validateCacheEntry(cachePath)) {
            return null;
        }
        return Files.readAllBytes(cachePath);
    }

    private Path getCacheCopy(String key) throws IOException {
        Path cachePath = this.getCacheEntryPath(key);
        if (!this.validateCacheEntry(cachePath)) {
            return null;
        }
        Path temp = Files.createTempFile("sonar_cache", null, new FileAttribute[0]);
        Files.copy(cachePath, temp, StandardCopyOption.REPLACE_EXISTING);
        return temp;
    }

    private boolean validateCacheEntry(Path cacheEntryPath) throws IOException {
        if (!Files.exists(cacheEntryPath, new LinkOption[0])) {
            return false;
        }
        if (this.invalidation.test(cacheEntryPath)) {
            this.logger.debug("cache: evicting entry");
            Files.delete(cacheEntryPath);
            return false;
        }
        return true;
    }

    private Path getCacheEntryPath(String key) {
        return this.dir.resolve(key);
    }

    public static String byteArrayToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private class DirectoryCleanFilter
    implements DirectoryStream.Filter<Path> {
        private DirectoryCleanFilter() {
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            if (PersistentCache.this.lock.getFileLockName().equals(entry.getFileName().toString())) {
                return false;
            }
            return PersistentCache.this.invalidation.test(entry);
        }
    }

    private class DirectoryClearFilter
    implements DirectoryStream.Filter<Path> {
        private DirectoryClearFilter() {
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            return !PersistentCache.this.lock.getFileLockName().equals(entry.getFileName().toString());
        }
    }
}

