package cz.cuni.amis.utils.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.LogRecord;

public class LogFormatter {
	
	private static SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
	
	private static String longestUnitName = "";
	
	private static String longestComponentName = "";
	
	private StringBuffer buffer = new StringBuffer(512);

	/**
	 * Whether to append "newline" after the log message.
	 */
	private boolean lineEnds = false;

	private String name = null;

	public static final String[] whitespaces = new String[] {
		"        ",
		"       ",
		"      ",
		"     ",
		"    ",
		"   ",
		"  ",
		" ",
		""
	};
	
	public LogFormatter(String unitName) {
		this.name = unitName;
	}
	
	public LogFormatter(String unitName, boolean appendLineEnd) {
		this.name = unitName;
		this.lineEnds = appendLineEnd;
	}
	
	public synchronized String format(LogRecord record) {
		buffer.delete(0, buffer.length());

		if (name != null) {
			String n = name;
			if (n == null) n = "null";
			if (n.length() > longestUnitName.length()) {
				StringBuffer longest = new StringBuffer();
				for (int i = 0; i < n.length(); ++i) {
					longest.append(" ");
				}
				longestUnitName = longest.toString();
			}
			buffer.append("(");
			buffer.append(n);
			buffer.append(") ");
			int count = longestUnitName.length() - n.length();
			for (int i = 0; i < count; ++i) {
				buffer.append(" ");
			}
		} else {
			if (longestUnitName.length() > 0) {
				buffer.append("()");
				buffer.append(longestUnitName);
			} else {
				buffer.append("() ");
			}
		}
		
		buffer.append("[");
		buffer.append(record.getLevel().toString());
		buffer.append("]");
		buffer.append(whitespaces[record.getLevel().toString().length()]);

		synchronized(dateFormat) {
			buffer.append(dateFormat.format(new Date(record.getMillis())));
		}
		
		buffer.append(" ");
		
		String n = record.getLoggerName();
		if (n == null) n = "null";
		if (n.length() > longestComponentName.length()) {
			StringBuffer longest = new StringBuffer();
			for (int i = 0; i < n.length(); ++i) {
				longest.append(" ");
			}
			longestComponentName = longest.toString();
		}
		buffer.append("<");
		buffer.append(n);
		buffer.append("> ");
		int count = longestComponentName.length() - n.length();
		for (int i = 0; i < count; ++i) {
			buffer.append(" ");
		}
		
		buffer.append(record.getMessage());
		
		if (lineEnds) {
			buffer.append("\r\n");
		}
		
		return buffer.toString();
	}

}
