/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.collections;

import cz.cuni.amis.utils.collections.CollectionEventListener;
import cz.cuni.amis.utils.listener.Listeners;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ObservableCollection<E>
implements Collection<E> {
    protected Collection<E> col = null;
    protected Listeners<CollectionEventListener> eventListeners = new Listeners();
    private ListenerNotifier preAddNotifier = new ListenerNotifier(){

        @Override
        public void notify(CollectionEventListener listener) {
            listener.preAddEvent(this.what, this.where);
        }
    };
    private ListenerNotifier postAddNotifier = new ListenerNotifier(){

        @Override
        public void notify(CollectionEventListener listener) {
            listener.postAddEvent(this.what, this.where);
        }
    };
    private ListenerNotifier preRemoveNotifier = new ListenerNotifier(){

        @Override
        public void notify(CollectionEventListener listener) {
            listener.preRemoveEvent(this.what, this.where);
        }
    };
    private ListenerNotifier postRemoveNotifier = new ListenerNotifier(){

        @Override
        public void notify(CollectionEventListener listener) {
            listener.postRemoveEvent(this.what, this.where);
        }
    };

    public void addCollectionListener(CollectionEventListener listener) {
        this.eventListeners.addStrongListener(listener);
    }

    public boolean removeCollectionListener(CollectionEventListener listener) {
        return this.eventListeners.removeListener(listener) > 0;
    }

    public ObservableCollection(Collection c) {
        this.col = c;
    }

    @Override
    public int size() {
        return this.col.size();
    }

    @Override
    public boolean isEmpty() {
        return this.col.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.col.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.col.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.col.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.col.toArray(a);
    }

    @Override
    public boolean add(E e) {
        List<E> add = Collections.singletonList(e);
        this.notifyPreAdd(add);
        boolean ret = this.col.add(e);
        this.notifyPostAdd(add);
        return ret;
    }

    @Override
    public boolean remove(Object o) {
        List<Object> rem = Collections.singletonList(o);
        this.notifyPreRemove(rem);
        boolean ret = this.col.remove(o);
        this.notifyPostRemove(rem);
        return ret;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.col.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.notifyPreAdd(c);
        boolean ret = this.col.addAll(c);
        this.notifyPostAdd(c);
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.notifyPreRemove(c);
        boolean ret = this.col.removeAll(c);
        this.notifyPostRemove(c);
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.col.retainAll(c);
    }

    @Override
    public void clear() {
        this.notifyPreRemove(this.col);
        this.col.clear();
        this.notifyPostRemove(this.col);
    }

    protected synchronized void notifyPreAdd(Collection<? extends E> add) {
        this.preAddNotifier.what = add;
        this.preAddNotifier.where = this;
        this.eventListeners.notify(this.preAddNotifier);
    }

    protected synchronized void notifyPostAdd(Collection<? extends E> add) {
        this.postAddNotifier.what = add;
        this.postAddNotifier.where = this;
        this.eventListeners.notify(this.postAddNotifier);
    }

    protected synchronized void notifyPreRemove(Collection<?> remove) {
        this.preRemoveNotifier.what = remove;
        this.preRemoveNotifier.where = this;
        this.eventListeners.notify(this.preRemoveNotifier);
    }

    protected synchronized void notifyPostRemove(Collection<?> remove) {
        this.postRemoveNotifier.what = remove;
        this.postRemoveNotifier.where = this;
        this.eventListeners.notify(this.postRemoveNotifier);
    }

    private abstract class ListenerNotifier
    implements Listeners.ListenerNotifier<CollectionEventListener> {
        public Collection what;
        public Collection where;

        @Override
        public Object getEvent() {
            return this.what;
        }

        @Override
        public abstract void notify(CollectionEventListener var1);
    }
}

