/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.future;

import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.TimeUnitToMillis;
import cz.cuni.amis.utils.exception.PogamutTimeoutException;
import cz.cuni.amis.utils.future.IFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class CombinedBooleanFuture
implements IFuture<Boolean> {
    private IFuture<Boolean>[] futures;

    public CombinedBooleanFuture(IFuture<Boolean>[] futures) {
        this.futures = futures;
        NullCheck.check(this.futures, "futures");
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean canceled = true;
        for (IFuture<Boolean> future : this.futures) {
            canceled = canceled && future.cancel(mayInterruptIfRunning);
        }
        return canceled;
    }

    @Override
    public Boolean get() {
        boolean result = true;
        for (IFuture<Boolean> future : this.futures) {
            Boolean futureResult = future.get();
            result = result && futureResult != null && futureResult != false;
        }
        return result;
    }

    @Override
    public Boolean get(long timeout, TimeUnit unit) {
        long timeoutMillis = TimeUnitToMillis.toMillis(timeout, unit);
        long start = System.currentTimeMillis();
        boolean result = true;
        for (IFuture<Boolean> future : this.futures) {
            long futureStart = System.currentTimeMillis();
            if (futureStart - start > timeoutMillis) {
                throw new PogamutTimeoutException("timeouted after " + timeout + " " + (Object)((Object)unit), (Object)this);
            }
            Boolean futureResult = future.get(timeoutMillis - (futureStart - start), TimeUnit.MILLISECONDS);
            result = result && futureResult != null && futureResult != false;
        }
        return result;
    }

    public Boolean[] getAll(long timeout, TimeUnit unit) {
        long timeoutMillis = TimeUnitToMillis.toMillis(timeout, unit);
        long start = System.currentTimeMillis();
        Boolean[] results = new Boolean[this.futures.length];
        int i = 0;
        for (IFuture<Boolean> future : this.futures) {
            long futureStart = System.currentTimeMillis();
            if (futureStart - start > timeoutMillis) {
                throw new PogamutTimeoutException("timeouted after " + timeout + " " + (Object)((Object)unit), (Object)this);
            }
            results[i++] = future.get(timeoutMillis - (futureStart - start), TimeUnit.MILLISECONDS);
        }
        return results;
    }

    @Override
    public boolean isCancelled() {
        boolean result = false;
        for (IFuture<Boolean> future : this.futures) {
            Boolean futureResult = future.isCancelled();
            result = result || futureResult != null && futureResult != false;
        }
        return result;
    }

    @Override
    public boolean isDone() {
        boolean result = true;
        for (IFuture<Boolean> future : this.futures) {
            result = result && future.isDone();
        }
        return result;
    }

    public Future<Boolean>[] getFutures() {
        return this.futures;
    }
}

