/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.iterators;

import cz.cuni.amis.utils.iterators.CircularIterator;

public class ShiftedCircularIterator<E>
extends CircularIterator<E> {
    private int steps;
    private int passedSteps = 0;

    public ShiftedCircularIterator(Iterable<E> toIterateOver, int steps) {
        super(toIterateOver);
        for (int i = 0; i < steps; ++i) {
            this.next();
        }
        this.steps = steps;
        this.passedSteps = 0;
    }

    @Override
    public boolean hasNext() {
        return this.getIterable().iterator().hasNext();
    }

    @Override
    public E next() {
        Object value = this.getIterator().next();
        ++this.passedSteps;
        if (!this.getIterator().hasNext()) {
            this.restartIterator();
            this.passedSteps = 0;
        }
        if (this.passedSteps == this.steps) {
            this.passedEnd = true;
        }
        return value;
    }

    @Override
    public void remove() {
        this.getIterator().remove();
    }

    @Override
    public boolean hasPassedEnd() {
        if (this.passedEnd) {
            this.passedEnd = false;
            return this.passedEnd;
        }
        return false;
    }
}

