package cz.cuni.amis.utils.astar;

import java.util.Collection;

/**
 * This class represents the search space for A* algorithm
 * 1) we need to know which neighbours the node has
 * 2) we need to know the travel cost between two nodes (edge cost)
 */
public interface AStarMap<NODE> {
	
	/**
	 * Should return the distance from nodeFrom to nodeTo
     * You can be sure that nodeTo is among the neighbours of nodeFrom.
	 * @param nodeFrom
	 * @param nodeTo
	 * @return cost of an edge
	 */
	public int getEdgeCost(NODE nodeFrom, NODE nodeTo);
	
	/**
	 * This should return a collection of nodes which are connected to this one.
	 */
	public Collection<NODE> getNodeNeighbours(NODE node);
}
