package cz.cuni.amis.concurrency;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.junit.Test;

public class TestHashMap {

	private static Map<Integer, Integer> ints = new HashMap<Integer, Integer>();
	
	private static int get(int i) {
		
		//System.out.println(Thread.currentThread().getName() + ": get(" + i + ")");
		
		Integer result = ints.get(i);
		
		if (result != null) {
			//System.out.println(Thread.currentThread().getName() + ": get(" + i + ") found");
			return result;
		}
		
		//System.out.println(Thread.currentThread().getName() + ": get(" + i + ") NOT FOUND!");
		
		synchronized(ints) {
			System.out.println(Thread.currentThread().getName() + ": get(" + i + ") regetting...");
			result = ints.get(i);
			if (result != null) {
				System.out.println(Thread.currentThread().getName() + ": get(" + i + ") sync get success!");
				return result;
			}
			System.out.println(Thread.currentThread().getName() + ": get(" + i + ") inserting...");
			ints.put(i, i);
			return i;
		}
		
	}
	
	private static final int COUNT = 10000;
	
	private static class InsertJob implements Runnable {

		@Override
		public void run() {
			for (int i = 0; i < COUNT; ++i) {
				get(i);
			}
		}
		
	}
	
	@Test
	public void test() {
		int threadCount = 30;
		
		System.out.println("[INFO] Creating " + threadCount + " threads...");
		
		Thread[] thread = new Thread[threadCount];
		for (int i = 0; i < threadCount; ++i) {
			thread[i] = new Thread(new InsertJob(), "T" + i);
		}
		
		System.out.println("[INFO] Starting " + threadCount + " threads...");
		
		for (int i = 0; i < threadCount; ++i) {
			thread[i].start();
		}
		
		System.out.println("[INFO] Joining " + threadCount + " threads...");
		
		for (int i = 0; i < threadCount; ++i) {
			try {
				thread[i].join();
			} catch (InterruptedException e) {
			}
		}
		
		System.out.println("[INFO] Checking results...");
		
		// CHECK RESULTS
		
		Integer[] keys = ints.keySet().toArray(new Integer[COUNT]);
		Integer[] values = ints.values().toArray(new Integer[COUNT]);
		
		if (keys.length != COUNT) {
			System.out.println("[ERROR] keys.length != " + COUNT + " == number of inserted pairs");
			throw new RuntimeException("[ERROR] keys.length != " + COUNT + " == number of inserted pairs");
		}
		if (values.length != COUNT) {
			System.out.println("[ERROR] values.length != " + COUNT + " == number of inserted pairs");
			throw new RuntimeException("[ERROR] values.length != " + COUNT + " == number of inserted pairs");
		}
		
		// NULL CHECKS
		
		for (int i = 0; i < keys.length; ++i) {
			if (keys[i] == null) {
				System.out.println("[ERROR] keys[" + i + "] == null");
				throw new RuntimeException("[ERROR] keys[" + i + "] == null");
			}
		}
		
		for (int i = 0; i < values.length; ++i) {
			if (values[i] == null) {
				System.out.println("[ERROR] values[" + i + "] == null");
				throw new RuntimeException("[ERROR] values[" + i + "] == null");
			}
		}
		
		Arrays.sort(keys);
		Arrays.sort(values);
		
		for (int i = 0; i < COUNT; ++i) {
			if (keys[i] != i) {
				System.out.println("[ERROR] keys[i] == " + keys[i] + " != " + i + " which is expected value");
				throw new RuntimeException("[ERROR] keys[i] == " + keys[i] + " != " + i + " which is expected value");
			}
			if (values[i] != i) {
				System.out.println("[ERROR] values[i] == " + values[i] + " != " + i + " which is expected value");
				throw new RuntimeException("[ERROR] values[i] == " + values[i] + " != " + i + " which is expected value");
			}
		}
		
		Integer[] keyRegs = new Integer[COUNT];
		Integer[] valueRegs = new Integer[COUNT];
		for (int i = 0; i < COUNT; ++i) {
			keyRegs[i] = i;
			valueRegs[i] = i;
		}
		
		for (Entry<Integer, Integer> entry : ints.entrySet()) {
			if (entry.getKey() == null) {
				System.out.println("[ERROR] map contains entry with key==null");
				throw new RuntimeException("[ERROR] map contains entry with key==null");
			}
			if (entry.getValue() == null) {
				System.out.println("[ERROR] map contains entry with value==null");
				throw new RuntimeException("[ERROR] map contains entry with value==null");
			}
			int key = entry.getKey();
			int value = entry.getValue();
			
			if (keyRegs[key] == null) {
				System.out.println("[ERROR] key " + key + " appears in the map twice");
				throw new RuntimeException("[ERROR] key " + key + " appears in the map twice");
			}
			keyRegs[key] = null;
			
			if (valueRegs[value] == null) {
				System.out.println("[ERROR] value " + value + " appears in the map twice");
				throw new RuntimeException("[ERROR] value " + value + " appears in the map twice");
			}
			valueRegs[value] = null;			
		}
		
		for (int i = 0; i < COUNT; ++i) {
			if (keyRegs[i] != null) {
				System.out.println("[ERROR] key " + i + " is not in the map");
				throw new RuntimeException("[ERROR] key " + i + " is not in the map");
			}
			if (valueRegs[i] != null) {
				System.out.println("[ERROR] value " + i + " is not in the map");
				throw new RuntimeException("[ERROR] value " + i + " is not in the map");
			}
		}
		
		for (int i = 0; i < COUNT; ++i) {
			Integer result = ints.get(i);
			if (result == null) {
				System.out.println("[ERROR] key " + i + " is not in the map");
				throw new RuntimeException("[ERROR] key " + i + " is not in the map");
			}
			if (result != i) {
				System.out.println("[ERROR] value under the key " + i + " is not " + i + " but " + result);
				throw new RuntimeException("[ERROR] value under the key " + i + " is not " + i + " but " + result);
			}
		}
		
		System.out.println("---/// TEST OK ///---");
	}
	
}
