/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.astar;

import cz.cuni.amis.utils.astar.AStarHeap;
import cz.cuni.amis.utils.astar.AStarHeapComparator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.junit.Before;
import org.junit.Test;

public class Test03_AStarHeap_DecreaseKey {
    Map<Integer, Integer> costs;
    AStarHeapComparator<Integer> comparator;
    AStarHeap<Integer> heap;

    @Before
    public void setup() {
        this.costs = new HashMap<Integer, Integer>();
        this.comparator = new AStarHeapComparator(this.costs);
        this.heap = new AStarHeap(this.comparator);
    }

    private void initCosts(int num) {
        for (int i = 0; i < num; ++i) {
            this.costs.put(i, i);
        }
    }

    private void initRevertCosts(int num) {
        for (int i = 0; i < num; ++i) {
            this.costs.put(i, num - i);
        }
    }

    private void putInHeapRandom(int num) {
        ArrayList<Integer> array = new ArrayList<Integer>(num);
        for (int i = 0; i < num; ++i) {
            array.add(i);
        }
        Random random = new Random(System.currentTimeMillis());
        while (array.size() > 0) {
            this.heap.add(array.remove(random.nextInt(array.size())));
        }
    }

    @Test
    public void test1() {
        int i;
        System.out.println("test1()");
        this.initCosts(100);
        this.putInHeapRandom(100);
        for (i = 0; i < 50; ++i) {
            if ((Integer)this.heap.getMin() != i) {
                System.out.println("[ERROR] Expecting " + i + ", got " + this.heap.getMin());
                throw new RuntimeException("[ERROR] Expecting " + i + ", got " + this.heap.getMin());
            }
            this.heap.deleteMin();
        }
        for (i = 50; i < 100; ++i) {
            this.costs.put(i, i - 25);
            this.heap.decreaseKey((Object)i);
        }
        for (i = 50; i < 100; ++i) {
            if ((Integer)this.heap.getMin() != i) {
                System.out.println("[ERROR] Expecting " + i + ", got " + this.heap.getMin());
                throw new RuntimeException("[ERROR] Expecting " + i + ", got " + this.heap.getMin());
            }
            this.heap.deleteMin();
        }
        System.out.println("---/// TEST OK ///---");
    }

    @Test
    public void test2() {
        int i;
        System.out.println("test2()");
        this.initCosts(101);
        this.putInHeapRandom(100);
        for (i = 0; i < 50; ++i) {
            if ((Integer)this.heap.getMin() != i) {
                System.out.println("[ERROR] Expecting " + i + ", got " + this.heap.getMin());
                throw new RuntimeException("[ERROR] Expecting " + i + ", got " + this.heap.getMin());
            }
            this.heap.deleteMin();
        }
        for (i = 50; i < 100; ++i) {
            this.costs.put(i, Math.abs(i - 75));
            this.heap.decreaseKey((Object)i);
        }
        if ((Integer)this.heap.getMin() != 75) {
            System.out.println("[ERROR] Expecting 75, got " + this.heap.getMin());
            throw new RuntimeException("[ERROR] Expecting 75, got " + this.heap.getMin());
        }
        this.heap.deleteMin();
        for (i = 50; i < 74; ++i) {
            int expecting1 = 74 - (i - 50);
            int expecting2 = 76 + (i - 50);
            System.out.println("Expecting: {" + expecting1 + ", " + expecting2 + "}...");
            int first = (Integer)this.heap.getMin();
            this.heap.deleteMin();
            int second = (Integer)this.heap.getMin();
            this.heap.deleteMin();
            if (!(first == expecting1 && second == expecting2 || first == expecting2 && second == expecting1)) {
                System.out.println("[ERROR] Got: " + expecting1 + ", " + expecting2);
                throw new RuntimeException("[ERROR] Expecting {" + expecting1 + ", " + expecting2 + "}, got " + first + ", " + second);
            }
            System.out.println("OK");
        }
        System.out.println("---/// TEST OK ///---");
    }
}

