/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.objectmanager;

import cz.cuni.amis.utils.objectmanager.IObjectFactory;
import java.lang.ref.SoftReference;
import java.util.LinkedList;
import java.util.Queue;

public class ObjectManager<ManagedObject> {
    private Queue<SoftReference<ManagedObject>> freeObjects;
    private IObjectFactory<ManagedObject> objectFactory;
    private int moreNewObjectsCount;

    public ObjectManager(IObjectFactory<ManagedObject> objectFactory) {
        this(objectFactory, 10, 5);
    }

    public ObjectManager(IObjectFactory<ManagedObject> objectFactory, int initialObjectCount) {
        this(objectFactory, initialObjectCount, 5);
    }

    public ObjectManager(IObjectFactory<ManagedObject> objectFactory, int initialObjectCount, int moreNewObjectsCount) {
        if (moreNewObjectsCount <= 0) {
            moreNewObjectsCount = 1;
        }
        this.moreNewObjectsCount = moreNewObjectsCount;
        this.objectFactory = objectFactory;
        this.freeObjects = new LinkedList<SoftReference<ManagedObject>>();
        this.generateNewObjects(initialObjectCount);
    }

    private void generateNewObjects(int count) {
        for (int i = 0; i < count; ++i) {
            this.freeObjects.add(new SoftReference<ManagedObject>(this.objectFactory.newObject()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedObject get() {
        Queue<SoftReference<ManagedObject>> queue = this.freeObjects;
        synchronized (queue) {
            if (this.freeObjects.size() == 0) {
                this.generateNewObjects(this.moreNewObjectsCount);
            }
            SoftReference<ManagedObject> reference = this.freeObjects.poll();
            ManagedObject obj = reference.get();
            while (obj == null && this.freeObjects.size() > 0) {
                reference = this.freeObjects.poll();
                obj = reference.get();
            }
            if (obj != null) {
                return obj;
            }
            return this.objectFactory.newObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void giveBack(ManagedObject obj) {
        Queue<SoftReference<ManagedObject>> queue = this.freeObjects;
        synchronized (queue) {
            this.freeObjects.add(new SoftReference<ManagedObject>(obj));
        }
    }
}

