/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.listener;

import cz.cuni.amis.utils.listener.IListener;
import cz.cuni.amis.utils.listener.Listeners;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class ListenersMap<Key> {
    private Map<Key, Listeners<IListener>> listenersMap = new ConcurrentHashMap<Key, Listeners<IListener>>();
    private int listenersCount = 0;
    private Logger log;
    private String name;

    public Logger getLog() {
        return this.log;
    }

    private void setListenersLog(Key key, Listeners listeners) {
        listeners.setLog(this.log, this.name + key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLog(Logger log, String name) {
        Map<Key, Listeners<IListener>> map = this.listenersMap;
        synchronized (map) {
            this.log = log;
            this.name = name;
            this.name = this.name == null ? "ListenersMap-" : this.name + "-";
            for (Map.Entry<Key, Listeners<IListener>> entry : this.listenersMap.entrySet()) {
                this.setListenersLog(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Key key, IListener listener) {
        Map<Key, Listeners<IListener>> map = this.listenersMap;
        synchronized (map) {
            Listeners<IListener<Object>> listeners = this.listenersMap.get(key);
            if (listeners == null) {
                listeners = new Listeners();
                this.setListenersLog(key, listeners);
                this.listenersMap.put(key, listeners);
            }
            listeners.addWeakListener(listener);
            ++this.listenersCount;
        }
    }

    public boolean isListening(IListener listener) {
        for (Key key : this.listenersMap.keySet()) {
            if (!this.isListening(key, listener)) continue;
            return true;
        }
        return false;
    }

    public boolean isListening(Key key, IListener listener) {
        Listeners<IListener> listeners = this.listenersMap.get(key);
        if (listeners == null) {
            return false;
        }
        return listeners.isEqualListening(listener);
    }

    public void remove(IListener listener) {
        for (Key key : this.listenersMap.keySet()) {
            this.remove(key, listener);
        }
    }

    public void remove(Key key, IListener listener) {
        Listeners<IListener> listeners = this.listenersMap.get(key);
        if (listeners == null) {
            return;
        }
        this.listenersCount -= listeners.removeListener(listener);
    }

    public void notify(Listeners.ListenerNotifier<IListener> notifier) {
        for (Key key : this.listenersMap.keySet()) {
            this.notify(key, notifier);
        }
    }

    public void notify(Key key, Listeners.ListenerNotifier<IListener> notifier) {
        Listeners<IListener> listeners = this.listenersMap.get(key);
        if (listeners == null) {
            return;
        }
        listeners.notify(notifier);
    }

    public boolean notifySafe(Listeners.ListenerNotifier<IListener> notifier, Logger exceptionLog) {
        boolean noException = true;
        for (Key key : this.listenersMap.keySet()) {
            noException = this.notifySafe(key, notifier, exceptionLog) && noException;
        }
        return noException;
    }

    public boolean notifySafe(Key key, Listeners.ListenerNotifier<IListener> notifier, Logger exceptionLog) {
        Listeners<IListener> listeners = this.listenersMap.get(key);
        if (listeners == null) {
            return true;
        }
        return listeners.notifySafe(notifier, exceptionLog);
    }

    public boolean hasListeners() {
        return this.listenersCount > 0;
    }
}

