/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.concurrency;

import cz.cuni.amis.tests.ConcurrencyTest;
import cz.cuni.amis.tests.ConcurrentTask;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Test;

public class Test02_HashMap
extends ConcurrencyTest {
    public static HashMap<Integer, Integer> map = new HashMap();

    @Test
    public void test() {
        int threads = 40;
        int jobs = 1000;
        int add = 1000;
        ArrayList<IncValueAsync> tasks = new ArrayList<IncValueAsync>();
        for (int i = 0; i < jobs; ++i) {
            tasks.add(new IncValueAsync(0, add));
        }
        this.runConcurrent(tasks, threads);
        log.info("Checking map, expecting 0 items...");
        if (map.size() != 0) {
            this.testFailed("map.size() == " + map.size() + " != 0");
        }
        this.testOk();
    }

    public static class IncValueAsync
    extends ConcurrentTask {
        private int from;
        private int to;

        public IncValueAsync(int from, int to) {
            this.from = from;
            this.to = to;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runImpl() {
            HashMap<Integer, Integer> hashMap;
            int i;
            for (i = this.from; i < this.to; ++i) {
                hashMap = map;
                synchronized (hashMap) {
                    map.put(i, 1);
                    continue;
                }
            }
            for (i = this.from; i < this.to; ++i) {
                hashMap = map;
                synchronized (hashMap) {
                    map.get(i);
                    continue;
                }
            }
            for (i = this.from; i < this.to; ++i) {
                hashMap = map;
                synchronized (hashMap) {
                    map.remove(i);
                    continue;
                }
            }
        }
    }
}

