/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.concurrency;

import cz.cuni.amis.tests.BaseTest;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.Test;

public class Test08_HashSet
extends BaseTest {
    public static Set<Integer> set = new HashSet<Integer>();
    public static CountDownLatch latch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        int threads = 40;
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threads, threads, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        try {
            int total = 0;
            int jobs = 1000;
            int add = 1000;
            latch = new CountDownLatch(jobs);
            for (int i = 0; i < jobs; ++i) {
                executor.execute(new IncValueAsync(total, total + add));
                total += add;
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted.", e);
            }
            log.info("Checking set ... set.size() == " + set.size());
            if (set.size() != 0) {
                this.testFailed("HashSet.add() / HashSet.remove() has concurrency issues!");
            }
            this.testOk();
        }
        finally {
            executor.shutdownNow();
        }
    }

    public static class IncValueAsync
    implements Runnable {
        private int from;
        private int to;

        public IncValueAsync(int from, int to) {
            this.from = from;
            this.to = to;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Set<Integer> set;
            int i;
            for (i = this.from; i < this.to; ++i) {
                set = Test08_HashSet.set;
                synchronized (set) {
                    Test08_HashSet.set.add(i);
                    continue;
                }
            }
            for (i = this.from; i < this.to; ++i) {
                set = Test08_HashSet.set;
                synchronized (set) {
                    Test08_HashSet.set.remove(i);
                    continue;
                }
            }
            CountDownLatch countDownLatch = latch;
            synchronized (countDownLatch) {
                latch.countDown();
                System.out.println("Jobs remaining: " + latch.getCount());
            }
        }
    }
}

