/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.junit.Test;

public class Test04_Iterators
extends BaseTest {
    @Test
    public void test01_Simple() {
        int i;
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        ArrayList<Integer> list3 = new ArrayList<Integer>();
        for (i = 0; i < 5; ++i) {
            list1.add(i);
        }
        for (i = 5; i < 10; ++i) {
            list2.add(i);
        }
        for (i = 10; i < 15; ++i) {
            list3.add(i);
        }
        Iterators iterator = new Iterators(new Iterator[]{list1.iterator(), list2.iterator(), list3.iterator()});
        for (int i2 = 0; i2 < 15; ++i2) {
            Integer value;
            if (!iterator.hasNext()) {
                this.testFailed("iterator.hasNext() == false, can't be, there still need to be some elements");
            }
            if ((value = (Integer)iterator.next()) != i2) {
                log.info("iterator.next() == " + value + " != " + i2 + " == expected");
                this.testFailed("iterator.next() has returned wrong element!");
            }
            log.info("iterator.next() == " + value + " == " + i2 + " == expected");
        }
        if (iterator.hasNext()) {
            this.testFailed("iterator.hasNext() == true, but there should not be anymore elements");
        }
        boolean exception = false;
        try {
            iterator.next();
        }
        catch (NoSuchElementException e) {
            log.info("iterator.next() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.next() did not throw the exception even though it should have!");
        }
        this.testOk();
    }

    @Test
    public void test02_Remove() {
        int i;
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        ArrayList<Integer> list3 = new ArrayList<Integer>();
        for (i = 0; i < 5; ++i) {
            list1.add(i);
        }
        for (i = 5; i < 10; ++i) {
            list2.add(i);
        }
        for (i = 10; i < 15; ++i) {
            list3.add(i);
        }
        Iterators iterator = new Iterators(new Iterator[]{list1.iterator(), list2.iterator(), list3.iterator()});
        for (int i2 = 0; i2 < 15; ++i2) {
            Integer value;
            if (!iterator.hasNext()) {
                this.testFailed("iterator.hasNext() == false, can't be, there still need to be some elements");
            }
            if ((value = (Integer)iterator.next()) != i2) {
                log.info("iterator.next() == " + value + " != " + i2 + " == expected");
                this.testFailed("iterator.next() has returned wrong element!");
            }
            log.info("iterator.next() == " + value + " == " + i2 + " == expected");
            iterator.remove();
            log.info("value removed");
        }
        if (iterator.hasNext()) {
            this.testFailed("iterator.hasNext() == true, but there should not be anymore elements");
        }
        if (list1.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list1.size() == " + list1.size() + " > 0");
        }
        if (list2.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list2.size() == " + list1.size() + " > 0");
        }
        if (list3.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list3.size() == " + list1.size() + " > 0");
        }
        log.info("All lists are empty.");
        boolean exception = false;
        try {
            iterator.next();
        }
        catch (NoSuchElementException e) {
            log.info("iterator.next() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.next() did not throw the exception even though it should have!");
        }
        this.testOk();
    }

    @Test
    public void test03_RemoveExceptions() {
        int i;
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList list2 = new ArrayList();
        ArrayList<Integer> list3 = new ArrayList<Integer>();
        for (i = 0; i < 5; ++i) {
            list1.add(i);
        }
        for (i = 5; i < 10; ++i) {
            list3.add(i);
        }
        Iterators iterator = new Iterators(new Iterator[]{list1.iterator(), list2.iterator(), list3.iterator()});
        boolean exception = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        iterator.next();
        iterator.remove();
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        this.testOk();
    }

    @Test
    public void test04_EmptyIterator_First() {
        int i;
        ArrayList list1 = new ArrayList();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        ArrayList<Integer> list3 = new ArrayList<Integer>();
        for (i = 0; i < 5; ++i) {
            list2.add(i);
        }
        for (i = 5; i < 10; ++i) {
            list3.add(i);
        }
        Iterators iterator = new Iterators(new Iterator[]{list1.iterator(), list2.iterator(), list3.iterator()});
        boolean exception = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        iterator.next();
        iterator.remove();
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        for (int i2 = 1; i2 < 10; ++i2) {
            Integer value;
            if (!iterator.hasNext()) {
                this.testFailed("iterator.hasNext() == false, can't be, there still need to be some elements");
            }
            if ((value = (Integer)iterator.next()) != i2) {
                log.info("iterator.next() == " + value + " != " + i2 + " == expected");
                this.testFailed("iterator.next() has returned wrong element!");
            }
            log.info("iterator.next() == " + value + " == " + i2 + " == expected");
            iterator.remove();
            log.info("value removed");
        }
        if (iterator.hasNext()) {
            this.testFailed("iterator.hasNext() == true, but there should not be anymore elements");
        }
        if (list1.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list1.size() == " + list1.size() + " > 0");
        }
        if (list2.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list2.size() == " + list1.size() + " > 0");
        }
        if (list3.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list3.size() == " + list1.size() + " > 0");
        }
        log.info("All lists are empty.");
        try {
            iterator.next();
        }
        catch (NoSuchElementException e) {
            log.info("iterator.next() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.next() did not throw the exception even though it should have!");
        }
        this.testOk();
    }

    @Test
    public void test05_EmptyIterator_Middle() {
        int i;
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList list2 = new ArrayList();
        ArrayList<Integer> list3 = new ArrayList<Integer>();
        for (i = 0; i < 5; ++i) {
            list1.add(i);
        }
        for (i = 5; i < 10; ++i) {
            list3.add(i);
        }
        Iterators iterator = new Iterators(new Iterator[]{list1.iterator(), list2.iterator(), list3.iterator()});
        boolean exception = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        iterator.next();
        iterator.remove();
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        for (int i2 = 1; i2 < 10; ++i2) {
            Integer value;
            if (!iterator.hasNext()) {
                this.testFailed("iterator.hasNext() == false, can't be, there still need to be some elements");
            }
            if ((value = (Integer)iterator.next()) != i2) {
                log.info("iterator.next() == " + value + " != " + i2 + " == expected");
                this.testFailed("iterator.next() has returned wrong element!");
            }
            log.info("iterator.next() == " + value + " == " + i2 + " == expected");
            iterator.remove();
            log.info("value removed");
        }
        if (iterator.hasNext()) {
            this.testFailed("iterator.hasNext() == true, but there should not be anymore elements");
        }
        if (list1.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list1.size() == " + list1.size() + " > 0");
        }
        if (list2.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list2.size() == " + list1.size() + " > 0");
        }
        if (list3.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list3.size() == " + list1.size() + " > 0");
        }
        log.info("All lists are empty.");
        try {
            iterator.next();
        }
        catch (NoSuchElementException e) {
            log.info("iterator.next() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.next() did not throw the exception even though it should have!");
        }
        this.testOk();
    }

    @Test
    public void test06_EmptyIterator_Last() {
        int i;
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        ArrayList list3 = new ArrayList();
        for (i = 0; i < 5; ++i) {
            list1.add(i);
        }
        for (i = 5; i < 10; ++i) {
            list2.add(i);
        }
        Iterators iterator = new Iterators(new Iterator[]{list1.iterator(), list2.iterator(), list3.iterator()});
        boolean exception = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        iterator.next();
        iterator.remove();
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        for (int i2 = 1; i2 < 10; ++i2) {
            Integer value;
            if (!iterator.hasNext()) {
                this.testFailed("iterator.hasNext() == false, can't be, there still need to be some elements");
            }
            if ((value = (Integer)iterator.next()) != i2) {
                log.info("iterator.next() == " + value + " != " + i2 + " == expected");
                this.testFailed("iterator.next() has returned wrong element!");
            }
            log.info("iterator.next() == " + value + " == " + i2 + " == expected");
            iterator.remove();
            log.info("value removed");
        }
        if (iterator.hasNext()) {
            this.testFailed("iterator.hasNext() == true, but there should not be anymore elements");
        }
        if (list1.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list1.size() == " + list1.size() + " > 0");
        }
        if (list2.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list2.size() == " + list1.size() + " > 0");
        }
        if (list3.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list3.size() == " + list1.size() + " > 0");
        }
        log.info("All lists are empty.");
        try {
            iterator.next();
        }
        catch (NoSuchElementException e) {
            log.info("iterator.next() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.next() did not throw the exception even though it should have!");
        }
        this.testOk();
    }

    @Test
    public void test07_HasNext_And_Remove() {
        int i;
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        ArrayList<Integer> list3 = new ArrayList<Integer>();
        for (i = 0; i < 5; ++i) {
            list1.add(i);
        }
        for (i = 5; i < 10; ++i) {
            list2.add(i);
        }
        for (i = 10; i < 15; ++i) {
            list3.add(i);
        }
        Iterators iterator = new Iterators(new Iterator[]{list1.iterator(), list2.iterator(), list3.iterator()});
        for (int i2 = 0; i2 < 15; ++i2) {
            Integer value;
            if (!iterator.hasNext()) {
                this.testFailed("iterator.hasNext() == false, can't be, there still need to be some elements");
            }
            if ((value = (Integer)iterator.next()) != i2) {
                log.info("iterator.next() == " + value + " != " + i2 + " == expected");
                this.testFailed("iterator.next() has returned wrong element!");
            }
            log.info("iterator.next() == " + value + " == " + i2 + " == expected");
            iterator.hasNext();
            iterator.remove();
            log.info("value removed");
        }
        if (iterator.hasNext()) {
            this.testFailed("iterator.hasNext() == true, but there should not be anymore elements");
        }
        if (list1.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list1.size() == " + list1.size() + " > 0");
        }
        if (list2.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list2.size() == " + list1.size() + " > 0");
        }
        if (list3.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list3.size() == " + list1.size() + " > 0");
        }
        log.info("All lists are empty.");
        boolean exception = false;
        try {
            iterator.next();
        }
        catch (NoSuchElementException e) {
            log.info("iterator.next() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.next() did not throw the exception even though it should have!");
        }
        this.testOk();
    }

    @Test
    public void test08_HasNext_And_Remove_EmptyIterator_First() {
        int i;
        ArrayList list1 = new ArrayList();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        ArrayList<Integer> list3 = new ArrayList<Integer>();
        for (i = 0; i < 5; ++i) {
            list2.add(i);
        }
        for (i = 5; i < 10; ++i) {
            list3.add(i);
        }
        Iterators iterator = new Iterators(new Iterator[]{list1.iterator(), list2.iterator(), list3.iterator()});
        boolean exception = false;
        iterator.hasNext();
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        iterator.next();
        iterator.hasNext();
        iterator.remove();
        iterator.hasNext();
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        for (int i2 = 1; i2 < 10; ++i2) {
            Integer value;
            if (!iterator.hasNext()) {
                this.testFailed("iterator.hasNext() == false, can't be, there still need to be some elements");
            }
            if ((value = (Integer)iterator.next()) != i2) {
                log.info("iterator.next() == " + value + " != " + i2 + " == expected");
                this.testFailed("iterator.next() has returned wrong element!");
            }
            log.info("iterator.next() == " + value + " == " + i2 + " == expected");
            iterator.hasNext();
            iterator.remove();
            log.info("value removed");
        }
        if (iterator.hasNext()) {
            this.testFailed("iterator.hasNext() == true, but there should not be anymore elements");
        }
        if (list1.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list1.size() == " + list1.size() + " > 0");
        }
        if (list2.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list2.size() == " + list1.size() + " > 0");
        }
        if (list3.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list3.size() == " + list1.size() + " > 0");
        }
        log.info("All lists are empty.");
        try {
            iterator.next();
        }
        catch (NoSuchElementException e) {
            log.info("iterator.next() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.next() did not throw the exception even though it should have!");
        }
        this.testOk();
    }

    @Test
    public void test09_HasNext_And_Remove_EmptyIterator_Middle() {
        int i;
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList list2 = new ArrayList();
        ArrayList<Integer> list3 = new ArrayList<Integer>();
        for (i = 0; i < 5; ++i) {
            list1.add(i);
        }
        for (i = 5; i < 10; ++i) {
            list3.add(i);
        }
        Iterators iterator = new Iterators(new Iterator[]{list1.iterator(), list2.iterator(), list3.iterator()});
        boolean exception = false;
        iterator.hasNext();
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        iterator.next();
        iterator.hasNext();
        iterator.remove();
        iterator.hasNext();
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        for (int i2 = 1; i2 < 10; ++i2) {
            Integer value;
            if (!iterator.hasNext()) {
                this.testFailed("iterator.hasNext() == false, can't be, there still need to be some elements");
            }
            if ((value = (Integer)iterator.next()) != i2) {
                log.info("iterator.next() == " + value + " != " + i2 + " == expected");
                this.testFailed("iterator.next() has returned wrong element!");
            }
            log.info("iterator.next() == " + value + " == " + i2 + " == expected");
            iterator.hasNext();
            iterator.remove();
            log.info("value removed");
        }
        if (iterator.hasNext()) {
            this.testFailed("iterator.hasNext() == true, but there should not be anymore elements");
        }
        if (list1.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list1.size() == " + list1.size() + " > 0");
        }
        if (list2.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list2.size() == " + list1.size() + " > 0");
        }
        if (list3.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list3.size() == " + list1.size() + " > 0");
        }
        log.info("All lists are empty.");
        try {
            iterator.next();
        }
        catch (NoSuchElementException e) {
            log.info("iterator.next() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.next() did not throw the exception even though it should have!");
        }
        this.testOk();
    }

    @Test
    public void test10_HasNext_And_Remove_EmptyIterator_Last() {
        int i;
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        ArrayList list3 = new ArrayList();
        for (i = 0; i < 5; ++i) {
            list1.add(i);
        }
        for (i = 5; i < 10; ++i) {
            list2.add(i);
        }
        Iterators iterator = new Iterators(new Iterator[]{list1.iterator(), list2.iterator(), list3.iterator()});
        boolean exception = false;
        iterator.hasNext();
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        iterator.next();
        iterator.hasNext();
        iterator.remove();
        iterator.hasNext();
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        for (int i2 = 1; i2 < 10; ++i2) {
            Integer value;
            if (!iterator.hasNext()) {
                this.testFailed("iterator.hasNext() == false, can't be, there still need to be some elements");
            }
            if ((value = (Integer)iterator.next()) != i2) {
                log.info("iterator.next() == " + value + " != " + i2 + " == expected");
                this.testFailed("iterator.next() has returned wrong element!");
            }
            log.info("iterator.next() == " + value + " == " + i2 + " == expected");
            iterator.hasNext();
            iterator.remove();
            log.info("value removed");
        }
        if (iterator.hasNext()) {
            this.testFailed("iterator.hasNext() == true, but there should not be anymore elements");
        }
        if (list1.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list1.size() == " + list1.size() + " > 0");
        }
        if (list2.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list2.size() == " + list1.size() + " > 0");
        }
        if (list3.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list3.size() == " + list1.size() + " > 0");
        }
        log.info("All lists are empty.");
        try {
            iterator.next();
        }
        catch (NoSuchElementException e) {
            log.info("iterator.next() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.next() did not throw the exception even though it should have!");
        }
        this.testOk();
    }

    @Test
    public void test10_HasNext_And_Remove_EmptyIterator_First_NullIterator() {
        int i;
        ArrayList list1 = new ArrayList();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        ArrayList<Integer> list3 = new ArrayList<Integer>();
        for (i = 0; i < 5; ++i) {
            list2.add(i);
        }
        for (i = 5; i < 10; ++i) {
            list3.add(i);
        }
        Iterators iterator = new Iterators(new Iterator[]{null, list1.iterator(), list2.iterator(), list3.iterator()});
        boolean exception = false;
        iterator.hasNext();
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        iterator.next();
        iterator.hasNext();
        iterator.remove();
        iterator.hasNext();
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        for (int i2 = 1; i2 < 10; ++i2) {
            Integer value;
            if (!iterator.hasNext()) {
                this.testFailed("iterator.hasNext() == false, can't be, there still need to be some elements");
            }
            if ((value = (Integer)iterator.next()) != i2) {
                log.info("iterator.next() == " + value + " != " + i2 + " == expected");
                this.testFailed("iterator.next() has returned wrong element!");
            }
            log.info("iterator.next() == " + value + " == " + i2 + " == expected");
            iterator.hasNext();
            iterator.remove();
            log.info("value removed");
        }
        if (iterator.hasNext()) {
            this.testFailed("iterator.hasNext() == true, but there should not be anymore elements");
        }
        if (list1.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list1.size() == " + list1.size() + " > 0");
        }
        if (list2.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list2.size() == " + list1.size() + " > 0");
        }
        if (list3.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list3.size() == " + list1.size() + " > 0");
        }
        log.info("All lists are empty.");
        try {
            iterator.next();
        }
        catch (NoSuchElementException e) {
            log.info("iterator.next() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.next() did not throw the exception even though it should have!");
        }
        this.testOk();
    }

    @Test
    public void test12_HasNext_And_Remove_EmptyIterator_Middle_NullIterator() {
        int i;
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList list2 = new ArrayList();
        ArrayList<Integer> list3 = new ArrayList<Integer>();
        for (i = 0; i < 5; ++i) {
            list1.add(i);
        }
        for (i = 5; i < 10; ++i) {
            list3.add(i);
        }
        Iterators iterator = new Iterators(new Iterator[]{list1.iterator(), null, list2.iterator(), list3.iterator()});
        boolean exception = false;
        iterator.hasNext();
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        iterator.next();
        iterator.hasNext();
        iterator.remove();
        iterator.hasNext();
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        for (int i2 = 1; i2 < 10; ++i2) {
            Integer value;
            if (!iterator.hasNext()) {
                this.testFailed("iterator.hasNext() == false, can't be, there still need to be some elements");
            }
            if ((value = (Integer)iterator.next()) != i2) {
                log.info("iterator.next() == " + value + " != " + i2 + " == expected");
                this.testFailed("iterator.next() has returned wrong element!");
            }
            log.info("iterator.next() == " + value + " == " + i2 + " == expected");
            iterator.hasNext();
            iterator.remove();
            log.info("value removed");
        }
        if (iterator.hasNext()) {
            this.testFailed("iterator.hasNext() == true, but there should not be anymore elements");
        }
        if (list1.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list1.size() == " + list1.size() + " > 0");
        }
        if (list2.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list2.size() == " + list1.size() + " > 0");
        }
        if (list3.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list3.size() == " + list1.size() + " > 0");
        }
        log.info("All lists are empty.");
        try {
            iterator.next();
        }
        catch (NoSuchElementException e) {
            log.info("iterator.next() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.next() did not throw the exception even though it should have!");
        }
        this.testOk();
    }

    @Test
    public void test13_HasNext_And_Remove_EmptyIterator_Last_NullIterator() {
        int i;
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        ArrayList list3 = new ArrayList();
        for (i = 0; i < 5; ++i) {
            list1.add(i);
        }
        for (i = 5; i < 10; ++i) {
            list2.add(i);
        }
        Iterators iterator = new Iterators(new Iterator[]{list1.iterator(), list2.iterator(), null, list3.iterator()});
        boolean exception = false;
        iterator.hasNext();
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        iterator.next();
        iterator.hasNext();
        iterator.remove();
        iterator.hasNext();
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        for (int i2 = 1; i2 < 10; ++i2) {
            Integer value;
            if (!iterator.hasNext()) {
                this.testFailed("iterator.hasNext() == false, can't be, there still need to be some elements");
            }
            if ((value = (Integer)iterator.next()) != i2) {
                log.info("iterator.next() == " + value + " != " + i2 + " == expected");
                this.testFailed("iterator.next() has returned wrong element!");
            }
            log.info("iterator.next() == " + value + " == " + i2 + " == expected");
            iterator.hasNext();
            iterator.remove();
            log.info("value removed");
        }
        if (iterator.hasNext()) {
            this.testFailed("iterator.hasNext() == true, but there should not be anymore elements");
        }
        if (list1.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list1.size() == " + list1.size() + " > 0");
        }
        if (list2.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list2.size() == " + list1.size() + " > 0");
        }
        if (list3.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list3.size() == " + list1.size() + " > 0");
        }
        log.info("All lists are empty.");
        try {
            iterator.next();
        }
        catch (NoSuchElementException e) {
            log.info("iterator.next() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.next() did not throw the exception even though it should have!");
        }
        this.testOk();
    }

    @Test
    public void test14_HasNext_And_Remove_EmptyIterator_Last_NullIterator() {
        int i;
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        ArrayList list3 = new ArrayList();
        for (i = 0; i < 5; ++i) {
            list1.add(i);
        }
        for (i = 5; i < 10; ++i) {
            list2.add(i);
        }
        Iterators iterator = new Iterators(new Iterator[]{list1.iterator(), list2.iterator(), list3.iterator(), null});
        boolean exception = false;
        iterator.hasNext();
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        iterator.next();
        iterator.hasNext();
        iterator.remove();
        iterator.hasNext();
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        for (int i2 = 1; i2 < 10; ++i2) {
            Integer value;
            if (!iterator.hasNext()) {
                this.testFailed("iterator.hasNext() == false, can't be, there still need to be some elements");
            }
            if ((value = (Integer)iterator.next()) != i2) {
                log.info("iterator.next() == " + value + " != " + i2 + " == expected");
                this.testFailed("iterator.next() has returned wrong element!");
            }
            log.info("iterator.next() == " + value + " == " + i2 + " == expected");
            iterator.hasNext();
            iterator.remove();
            log.info("value removed");
        }
        if (iterator.hasNext()) {
            this.testFailed("iterator.hasNext() == true, but there should not be anymore elements");
        }
        if (list1.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list1.size() == " + list1.size() + " > 0");
        }
        if (list2.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list2.size() == " + list1.size() + " > 0");
        }
        if (list3.size() > 0) {
            this.testFailed("All values should have been removed by iterator, but list3.size() == " + list1.size() + " > 0");
        }
        log.info("All lists are empty.");
        try {
            iterator.next();
        }
        catch (NoSuchElementException e) {
            log.info("iterator.next() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.next() did not throw the exception even though it should have!");
        }
        this.testOk();
    }

    @Test
    public void test15_OnlyNull_1() {
        Iterators iterator = new Iterators(new Iterator[]{null});
        boolean exception = false;
        if (iterator.hasNext()) {
            this.testFailed("iterator.hasNext() == true even though there are no iterators!");
        }
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        try {
            iterator.next();
        }
        catch (NoSuchElementException e) {
            log.info("iterator.next() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.next() did not throw the exception even though it should have!");
        }
        this.testOk();
    }

    @Test
    public void test15_OnlyNull_2() {
        Iterators iterator = new Iterators(new Iterator[]{null, null});
        boolean exception = false;
        if (iterator.hasNext()) {
            this.testFailed("iterator.hasNext() == true even though there are no iterators!");
        }
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        try {
            iterator.next();
        }
        catch (NoSuchElementException e) {
            log.info("iterator.next() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.next() did not throw the exception even though it should have!");
        }
        this.testOk();
    }

    @Test
    public void test15_OnlyNull_3() {
        Iterators iterator = new Iterators(new Iterable[]{null});
        boolean exception = false;
        if (iterator.hasNext()) {
            this.testFailed("iterator.hasNext() == true even though there are no iterators!");
        }
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        try {
            iterator.next();
        }
        catch (NoSuchElementException e) {
            log.info("iterator.next() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.next() did not throw the exception even though it should have!");
        }
        this.testOk();
    }

    @Test
    public void test15_OnlyNull_4() {
        Iterators iterator = new Iterators(new Iterable[]{null, null});
        boolean exception = false;
        if (iterator.hasNext()) {
            this.testFailed("iterator.hasNext() == true even though there are no iterators!");
        }
        try {
            iterator.remove();
        }
        catch (IllegalStateException e) {
            log.info("iterator.remove() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.remove() did not throw the exception even though it should have!");
        }
        exception = false;
        try {
            iterator.next();
        }
        catch (NoSuchElementException e) {
            log.info("iterator.next() exception caught, CORRECT!");
            exception = true;
        }
        if (!exception) {
            this.testFailed("iterator.next() did not throw the exception even though it should have!");
        }
        this.testOk();
    }
}

