/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.introspection;

import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.FolderUnion;
import cz.cuni.amis.introspection.IntrospectionException;
import cz.cuni.amis.introspection.Property;
import cz.cuni.amis.introspection.java.Introspectable;
import cz.cuni.amis.introspection.java.Introspector;
import cz.cuni.amis.introspection.java.JFolder;
import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.introspection.java.ReflectionObjectFolder;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test01_JavaIntrospection {
    static final int KNOWS_AGE = 25;
    Person alice = null;

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
        this.alice = new Person("Alice", 23);
        this.alice.knows = new Person("Bob", 25);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void saveProperties() throws IOException, IntrospectionException {
        Folder folder = Introspector.getFolder((String)"Root", (Object)this.alice);
        Properties props = folder.createProperties();
        props.store(new FileOutputStream("test.properties"), "Test file with properties");
    }

    @Test
    public void loadFromProperties() throws FileNotFoundException, IOException, IntrospectionException {
        this.alice.name = "AAlliiccee";
        this.alice.knows.age = 100;
        Properties props = new Properties();
        props.load(new FileInputStream("target/test-classes/test.properties"));
        Folder folder = Introspector.getFolder((String)"Root", (Object)this.alice);
        folder.loadFromProperties(props);
        Assert.assertEquals((long)25L, (long)this.alice.knows.age);
    }

    @Test
    public void saveCustomProperties() throws IOException, IntrospectionException {
        this.alice.knows = new PersonCustomView("Fred", 25);
        Folder folder = Introspector.getFolder((String)"Root", (Object)this.alice);
        Properties props = folder.createProperties();
        props.store(new FileOutputStream("test.properties"), "Test file with properties");
    }

    public class PersonCustomView
    extends Person
    implements Introspectable {
        Folder folder;

        public PersonCustomView(String name, int age) {
            super(name, age);
        }

        public Folder getFolder(String name) {
            if (this.folder == null) {
                this.folder = new FolderUnion((Folder)new ReflectionObjectFolder(name, (Object)this), new Folder(name){

                    public Folder[] getFolders() {
                        return new Folder[0];
                    }

                    public Property[] getProperties() {
                        return new Property[]{new Property("myCustomProp"){
                            String myVal;
                            {
                                this.myVal = "myCustomValue";
                            }

                            public Object getValue() throws IntrospectionException {
                                return this.myVal;
                            }

                            public void setValue(Object newValue) throws IntrospectionException {
                                this.myVal = (String)newValue;
                            }

                            public Class getType() {
                                return String.class;
                            }
                        }};
                    }
                }, name);
            }
            return this.folder;
        }
    }

    public static class Person {
        @JProp
        public String name;
        @JProp
        public int age;
        @JFolder
        public Person knows;

        public Person(String name, int age) {
            this.name = name;
            this.age = age;
        }
    }
}

