/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.impl;

import cz.cuni.amis.planning4j.IAsyncPlanner;
import cz.cuni.amis.planning4j.IDomainProvider;
import cz.cuni.amis.planning4j.IPlanFuture;
import cz.cuni.amis.planning4j.IPlanner;
import cz.cuni.amis.planning4j.IPlanningResult;
import cz.cuni.amis.planning4j.IProblemProvider;
import cz.cuni.amis.planning4j.impl.PlanFuture;

public class AsyncPlannerWrapper
implements IAsyncPlanner {
    IPlanner planner;

    public AsyncPlannerWrapper(IPlanner planner) {
        this.planner = planner;
    }

    @Override
    public IPlanningResult plan(IDomainProvider domainProvider, IProblemProvider problemProvider) {
        return this.planner.plan(domainProvider, problemProvider);
    }

    @Override
    public IPlanFuture planAsync(IDomainProvider domainProvider, IProblemProvider problemProvider) {
        PlanFuture future = new PlanFuture();
        PlanningOperation operation = new PlanningOperation(future, domainProvider, problemProvider);
        new Thread((Runnable)operation, "AsyncPlanningWrapper").start();
        return future;
    }

    private class PlanningOperation
    implements Runnable {
        private PlanFuture future;
        private IDomainProvider domainProvider;
        private IProblemProvider problemProvider;

        public PlanningOperation(PlanFuture future, IDomainProvider domainProvider, IProblemProvider problemProvider) {
            this.future = future;
            this.domainProvider = domainProvider;
            this.problemProvider = problemProvider;
        }

        @Override
        public void run() {
            try {
                this.future.setResult(AsyncPlannerWrapper.this.planner.plan(this.domainProvider, this.problemProvider));
            }
            catch (Exception ex) {
                this.future.computationException(ex);
            }
        }
    }
}

