/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.impl;

import cz.cuni.amis.planning4j.impl.AbstractWriterBasedDomainProvider;
import cz.cuni.amis.planning4j.pddl.PDDLAction;
import cz.cuni.amis.planning4j.pddl.PDDLConstant;
import cz.cuni.amis.planning4j.pddl.PDDLDomain;
import cz.cuni.amis.planning4j.pddl.PDDLParameter;
import cz.cuni.amis.planning4j.pddl.PDDLPredicate;
import cz.cuni.amis.planning4j.pddl.PDDLRequirement;
import cz.cuni.amis.planning4j.pddl.PDDLType;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class PDDLDomainProvider
extends AbstractWriterBasedDomainProvider {
    private PDDLDomain domain;

    public PDDLDomainProvider(PDDLDomain domain) {
        this.domain = domain;
    }

    @Override
    public PDDLDomain getDomainAsPDDL() {
        return this.domain;
    }

    protected void writeRequirements(Writer writer) throws IOException {
        writer.write("\t(:requirements");
        for (PDDLRequirement req : this.domain.getRequirements()) {
            writer.write(" :" + req.getPddlName());
        }
        writer.write(")\n");
    }

    protected void writeOneType(Writer writer, PDDLType type) throws IOException {
        if (type.getAncestor() == null) {
            throw new NullPointerException("User defined types must have a non-null ancestor");
        }
        writer.write(" " + type.getTypeName() + " - " + type.getAncestor().getTypeName());
    }

    protected void writeTypes(Writer writer) throws IOException {
        writer.write("\t(:types ");
        for (PDDLType type : this.domain.getTypes()) {
            this.writeOneType(writer, type);
        }
        writer.write(")\n");
    }

    protected void writeOneConstant(Writer writer, PDDLConstant constant) throws IOException {
        writer.write("\t\t(" + constant.getStringForPDDL() + ")\n");
    }

    protected void writeConstants(Writer writer) throws IOException {
        writer.write("\t(:constants \n");
        for (PDDLConstant constant : this.domain.getConstants()) {
            this.writeOneConstant(writer, constant);
        }
        writer.write("\t)\n");
    }

    protected void writeParameters(Writer writer, List<PDDLParameter> parameters) throws IOException {
        for (PDDLParameter parameter : parameters) {
            writer.write(" " + parameter.getStringForPDDL());
        }
    }

    protected void writeOnePredicate(Writer writer, PDDLPredicate predicate) throws IOException {
        writer.write("\t\t(" + predicate.getName());
        this.writeParameters(writer, predicate.getParameters());
        writer.write(")\n");
    }

    protected void writePredicates(Writer writer) throws IOException {
        writer.write("\t(:predicates \n");
        for (PDDLPredicate predicate : this.domain.getPredicates()) {
            this.writeOnePredicate(writer, predicate);
        }
        writer.write("\t)\n");
    }

    protected void writeOneAction(Writer writer, PDDLAction action) throws IOException {
        writer.write("\t(:action " + action.getName() + "\n");
        List<PDDLParameter> parameters = action.getParameters();
        writer.write("\t\t:parameters (");
        this.writeParameters(writer, parameters);
        writer.write(")\n");
        String precondition = action.getPreconditionAsString();
        if (precondition != null && !precondition.isEmpty()) {
            writer.write("\t\t:precondition (" + precondition + ")\n");
        }
        writer.write("\t\t:effect (" + action.getEffectAsString() + ")\n");
        writer.write("\t)\n");
    }

    protected void writeActions(Writer writer) throws IOException {
        for (PDDLAction action : this.domain.getActions()) {
            this.writeOneAction(writer, action);
        }
    }

    @Override
    public void writeDomain(Writer writer) throws IOException {
        writer.write("(define (domain " + this.domain.getDomainName() + ")\n");
        this.writeRequirements(writer);
        if (!this.domain.getTypes().isEmpty()) {
            this.writeTypes(writer);
        }
        if (!this.domain.getConstants().isEmpty()) {
            this.writeConstants(writer);
        }
        if (!this.domain.getPredicates().isEmpty()) {
            this.writePredicates(writer);
        }
        if (!this.domain.getActions().isEmpty()) {
            this.writeActions(writer);
        }
        writer.write(")");
    }
}

